<?php $__env->startSection('title','Add User'); ?>

<?php $__env->startSection('content'); ?>

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Add User</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="<?php echo e(route('dashboard')); ?>">Home</a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="<?php echo e(route('administration.users')); ?>">Registered Users</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Add User</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <form method="POST" action="<?php echo e(route('administration.users.add')); ?>" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                   <div class="col-lg-3 col-12">
                                        <label>PHOTO</label>
                                        <input type="file" id="input-file-now-custom-2" name="image" value="<?php echo e(old('image')); ?>" class="dropify" data-height="300" data-allowed-file-extensions="jpeg png jpg"/>
                                        <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <p class="mt-2 text-center">Image must be square and at least 500x500 pixels</p>
                                    </div>
                                    <div class="col-lg-9 col-12">
                                        <h4 class="card-title mb-4">Personal Information</h4>
                                        <div class="row">
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>First Name*</label>
                                                <input type="text" class="form-control <?php $__errorArgs = ['firstname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="firstname" value="<?php echo e(old('firstname')); ?>" placeholder="Enter first name" required>
                                                <?php $__errorArgs = ['firstname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                 <label>Middle Name</label>
                                                <input type="text" class="form-control <?php $__errorArgs = ['middlename'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="middlename" value="<?php echo e(old('middlename')); ?>" placeholder="Enter middle name">
                                                <?php $__errorArgs = ['middlename'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>Last Name*</label>
                                                 <input type="text" class="form-control <?php $__errorArgs = ['lastname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="lastname" value="<?php echo e(old('lastname')); ?>" placeholder="Enter last name" required>
                                                <?php $__errorArgs = ['lastname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Employee No.*</label>
                                                <input type="text" class="form-control <?php $__errorArgs = ['employee_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('employee_number')); ?>" placeholder="Enter employee number" name="employee_number" required>
                                                <?php $__errorArgs = ['employee_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Department*</label>
                                                <input type="text" class="form-control <?php $__errorArgs = ['department'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('department')); ?>" placeholder="Enter department" name="department" required>
                                                <?php $__errorArgs = ['department'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Email*</label>
                                                <input type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('email')); ?>" placeholder="Enter email" name="email" required>
                                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Mobile No.</label>
                                                <input type="text" class="form-control <?php $__errorArgs = ['contact_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('contact_number')); ?>" placeholder="Enter mobile number" name="contact_number" maxlength="13">
                                                <?php $__errorArgs = ['contact_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="col-12 form-group">
                                                <h4 class="card-title mt-2">Account Information</h4>
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Username*</label>
                                                <input type="text" class="form-control <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('username')); ?>" placeholder="Enter username" name="username" required>
                                                <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Usertype*</label>
                                                <select class="form-control <?php $__errorArgs = ['usertype'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="usertype" id="usertype" required>
                                                    <option value="" disabled selected>Select Usertype</option>
                                                    <?php if(auth()->check() && auth()->user()->hasRole('super_admin')): ?>
                                                    <option title="System Full Access" value="super_admin" <?php echo e(old('usertype') == 'super_admin' ? 'selected' : ''); ?>>Super Admin</option>
                                                    <option title="System Full Access except adding of user." value="admin" <?php echo e(old('usertype') == 'admin' ? 'selected' : ''); ?>>Administrator</option>
                                                    <?php endif; ?>
                                                    <option title="Can add/update member information." value="admin_cashier" <?php echo e(old('usertype') == 'admin_cashier' ? 'selected' : ''); ?>>Admin Cashier</option>
                                                    <option title="Merchant Portal Access" value="merchant_admin" <?php echo e(old('usertype') == 'merchant_admin' ? 'selected' : ''); ?>>Merchant Admin</option>
                                                    <option title="Limited Merchant Portal Access" value="merchant_cashier" <?php echo e(old('usertype') == 'merchant_cashier' ? 'selected' : ''); ?>>Merchant Cashier</option>
                                                    <option title="View only the Registered Users" value="human_resource" <?php echo e(old('usertype') == 'human_resource' ? 'selected' : ''); ?>>Human Resource</option>
                                                    <option title="View only list of Merchants and Members" value="accounting" <?php echo e(old('usertype') == 'accounting' ? 'selected' : ''); ?>>Accounting</option>
                                                </select>
                                                <?php $__errorArgs = ['usertype'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Default Password</label>
                                                <input type="text" class="form-control" value="pplus2020" disabled>
                                            </div>
                                            <div class="col-lg-6 col-12 form-group <?php echo e(old('usertype') == 'merchant_admin' || old('usertype') == 'merchant_cashier' ? '' : 'd-none'); ?> " id="merchants">
                                                <label>Company/Merchant*</label>
                                                <select class="form-control" name="merchant_id" id="merchant_id"></select>
                                            </div>
                                            <div class="col-lg-12 col-12 form-group text-right">
                                                <a href="<?php echo e(route('administration.users')); ?>">
                                                    <button type="button" class="btn btn-danger">
                                                        <i class="mdi mdi-close-circle"></i> Cancel
                                                    </button>
                                                </a>
                                                <button type="submit" class="btn btn-info">
                                                    <i class="fa fa-save"></i> Save
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php echo $__env->make('dashboard.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
    </div>
    
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
   <script type="text/javascript">

        // All select option
        $('select').select2({
            width : '100%'
        });

        getAllMerchants();

        $('#usertype').on('change', function(){
            var usertype = ($(this).val());

            // select merchant_admin or merchant_cashier show merchants
            if (usertype == 'merchant_admin' || usertype == 'merchant_cashier') {

                $('#merchants').removeClass('d-none');
                $('#merchant_id').attr('required',true);
                $('#merchant_id').val('');
                $('#merchant_id').select2('');

                return true;
            }

            $('#merchants').addClass('d-none');
            $('#merchant_id').removeAttr('required',true);
        });

        function getAllMerchants() {
            $.ajax({
                type: "GET",
                url: "<?php echo e(route('administration.merchants')); ?>",
                success: function (response) {
                    $('#merchant_id').append('<option value="" disabled>Select Company/Merchant</option>');
                    for (i = 0; i < response.length; i++) {
                        $('#merchant_id').append('<option value='+response[i].id+' "<?php echo e(old("merchant_id") == 'response[i].id' ? "selected" : ''); ?>">'+response[i].name.toUpperCase()+'</option>');
                    }
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        }

   </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/pplus_web/resources/views/dashboard/administration/users/add.blade.php ENDPATH**/ ?>