<?php $__env->startSection('title','My Profile'); ?>
<?php $__env->startSection('styles'); ?>
    <style type="text/css">
        textarea {
          resize: none;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">My Profile</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="<?php echo e(route('dashboard')); ?>">Home</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">My Profile</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-4 col-xlg-3 col-md-5">
                    <div class="card">
                        <div class="card-body">
                            <center class="m-t-30">
                                <img src="<?php echo e($user->image); ?>" alt="user" class="rounded-circle img-fluid" style="height: 150px !important; width: 150px !important;">
                                <h4 class="card-title m-t-10">
                                    <?php if(auth()->check() && auth()->user()->hasRole('doctor')): ?> 
                                        <?php echo e($user->account->prefix); ?>.
                                    <?php endif; ?>
                                    <?php echo e(ucwords($user->firstname.' '.$user->lastname)); ?>

                                </h4>
                                <h6 class="card-subtitle"><?php echo e(ucwords(str_replace('_', ' ', $user->usertype))); ?></h6>
                            </center>
                        </div>
                        <div>
                            <hr> 
                        </div>
                        <div class="card-body"> 
                            <small class="text-muted">Username</small>
                            <h6><?php echo e($user->username); ?></h6> 
                            <small class="text-muted">Email address </small>
                            <h6><?php echo e($user->email); ?></h6>
                            <?php if(!auth()->check() || ! auth()->user()->hasRole('doctor')): ?>
                                <small class="text-muted">Employee Number </small>
                                <h6><?php echo e($user->account->employee_number); ?></h6>
                                <small class="text-muted">Deparment </small>
                                <h6><?php echo e($user->account->department); ?></h6> 
                            <?php else: ?>
                                <small class="text-muted">Bio </small>
                                <h6><?php echo e($user->account->contact_number); ?></h6>
                                <small class="text-muted">Bio </small>
                                <h6><?php echo e($user->account->bio ? $user->account->bio : '-'); ?></h6>
                            <?php endif; ?>
                            
                            <?php if(auth()->check() && auth()->user()->hasRole('merchant_admin')): ?>
                                <small class="text-muted">Company/Merchant </small>
                                <h6><?php echo e($user->account->merchant->name); ?></h6>  
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="col-lg-8 col-xlg-9 col-md-7">
                    <div class="card">
                        <!-- Tabs -->
                        <ul class="nav nav-pills custom-pills" id="pills-tab" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active" id="pills-setting-tab" data-toggle="pill" href="#previous-month" role="tab" aria-controls="pills-setting" aria-selected="false">Account Settings</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="pills-profile-tab" data-toggle="pill" href="#last-month" role="tab" aria-controls="pills-profile" aria-selected="false">Change Password</a>
                            </li>
                            <?php if(auth()->check() && auth()->user()->hasRole('doctor')): ?>
                                <li class="nav-item">
                                    <a class="nav-link" id="pills-schedules-tab" data-toggle="pill" href="#schedules" role="tab" aria-controls="pills-schedules" aria-selected="false">My Schedules</a>
                                </li>
                            <?php endif; ?>
                        </ul>

                        <!-- Tabs -->
                        <div class="tab-content" id="pills-tabContent">
                            <div class="tab-pane fade show active" id="previous-month" role="tabpanel" aria-labelledby="pills-setting-tab">
                                <div class="card-body">
                                    <form class="form-horizontal form-material" id="account-settings" data-parsley-validate novalidate>
                                        <?php echo csrf_field(); ?>
                                        <div class="row justify-content-center form-group">
                                            <div class="col-lg-10 col-12">
                                                <label>Email*</label>
                                                <input type="text" placeholder="Enter email" class="form-control form-control-line" name="email" id="email" value="<?php echo e($user->email); ?>" required>
                                                <small class="email"></small>                                       
                                            </div>
                                        </div>
                                        <div class="row justify-content-center form-group">
                                            <div class="col-lg-10 col-12">
                                                <label>Mobile No*</label>
                                                <input type="text" placeholder="Enter mobile number" class="form-control form-control-line" name="contact_number" id="contact_number" value="<?php echo e($user->account->contact_number); ?>" maxlength="13" required>
                                                <small class="contact_number"></small>                                         
                                            </div>
                                        </div>
                                        <?php if(auth()->check() && auth()->user()->hasRole('doctor')): ?>
                                            <div class="row justify-content-center form-group">
                                                <div class="col-lg-10 col-12">
                                                    <label>Bio</label>
                                                    <textarea class="form-control" rows="4" name="bio" id="bio" placeholder="Enter bio"><?php echo e($user->account->bio); ?></textarea>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                        <div class="row justify-content-center form-group">
                                            <div class="col-lg-10 col-12">
                                                <button type="submit" class="btn btn-info" id="save">
                                                    <i class="mdi mdi-content-save"></i> Save
                                                </button>                                  
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="last-month" role="tabpanel" aria-labelledby="pills-profile-tab">
                                <div class="card-body">
                                    <form class="form-horizontal form-material" id="change-password" data-parsley-validate novalidate>
                                        <?php echo csrf_field(); ?>
                                        <div class="row justify-content-center form-group">
                                            <div class="col-lg-10 col-12">
                                                <label>Current Password</label>
                                                <input type="password" placeholder="Enter current password" class="form-control form-control-line" name="current_password" id="current_password" required>
                                                <small class="current_password"></small>                                       
                                            </div>
                                        </div>
                                        <div class="row justify-content-center form-group">
                                            <div class="col-lg-10 col-12">
                                                <label>New Password</label>
                                                <input type="password" class="form-control" name="password" id="password" placeholder="Enter new password" data-parsley-minlength="8" required>
                                            </div>
                                        </div>
                                        <div class="row justify-content-center form-group">
                                            <div class="col-lg-10 col-12">
                                                <label>Confirm Password</label>
                                                <input type="password" class="form-control" name="confirm_password" value="" id="confirm_password" placeholder="Enter confirm password" data-parsley-minlength="8" data-parsley-equalto="#password" required>                                      
                                            </div>
                                        </div>
                                        <div class="row justify-content-center form-group">
                                            <div class="col-lg-10 col-12">
                                                <button type="submit" class="btn btn-info" id="save">
                                                    <i class="mdi mdi-content-save"></i> Change Password
                                                </button>                                  
                                            </div>
                                        </div>
                                    </form>                                 
                                </div>
                            </div>
                            <?php if(auth()->check() && auth()->user()->hasRole('doctor')): ?>
                            <div class="tab-pane fade" id="schedules" role="tabpanel" aria-labelledby="pills-schedules-tab">
                                <div class="card-body">
                                    <form class="form-horizontal form-material" id="change-schedules">
                                        <?php echo csrf_field(); ?>
                                        <div class="row">
                                            <div class="col-12">
                                                <label class="control-label">Monday</label>                                
                                            </div>
                                            <div class="col-lg-6 col-12">
                                                <div class="row form-group">
                                                    <div class="col-12">
                                                        <label class="control-label font-weight-light">(4AM - 12PM)</label>
                                                    </div>
                                                    <div class="col-6">
                                                        <input type="time" class="form-control monday-am" name="monday[]" value="<?php echo e($user->schedules->monday[0]); ?>" min="04:00" max="12:00">
                                                    </div> 
                                                    <div class="col-6">
                                                        <input type="time" class="form-control monday-am" name="monday[]" value="<?php echo e($user->schedules->monday[1]); ?>" min="04:00" max="12:00">
                                                    </div>   
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-12">
                                                <div class="row form-group">
                                                    <div class="col-12">
                                                        <label class="control-label font-weight-light">(1PM - 12:00AM)</label>
                                                    </div>
                                                    <div class="col-6">
                                                        <input type="time" class="form-control" name="monday[]" value="<?php echo e($user->schedules->monday[2]); ?>" min="13:00" max="00:00">
                                                    </div> 
                                                    <div class="col-6">
                                                        <input type="time" class="form-control" name="monday[]" value="<?php echo e($user->schedules->monday[3]); ?>" min="13:00" max="00:00">
                                                    </div>   
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-12">
                                                <label class="control-label">Tuesday</label>                                
                                            </div>
                                            <div class="col-lg-6 col-12">
                                                <div class="row form-group">
                                                    <div class="col-12">
                                                        <label class="control-label font-weight-light">(4AM - 12PM)</label>
                                                    </div>
                                                    <div class="col-6">
                                                        <input type="time" class="form-control" name="tuesday[]" value="<?php echo e($user->schedules->tuesday[0]); ?>" min="04:00" max="12:00">
                                                    </div> 
                                                    <div class="col-6">
                                                        <input type="time" class="form-control" name="tuesday[]" value="<?php echo e($user->schedules->tuesday[1]); ?>" min="04:00" max="12:00">
                                                    </div>   
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-12">
                                                <div class="row form-group">
                                                    <div class="col-12">
                                                        <label class="control-label font-weight-light">(1PM - 12:00AM)</label>
                                                    </div>
                                                    <div class="col-6">
                                                        <input type="time" class="form-control" name="tuesday[]" value="<?php echo e($user->schedules->tuesday[2]); ?>" min="13:00" max="00:00">
                                                    </div> 
                                                    <div class="col-6">
                                                        <input type="time" class="form-control" name="tuesday[]" value="<?php echo e($user->schedules->tuesday[3]); ?>" min="13:00" max="00:00">
                                                    </div>   
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-12">
                                                <label class="control-label">Wednesday</label>                                
                                            </div>
                                            <div class="col-lg-6 col-12">
                                                <div class="row form-group">
                                                    <div class="col-12">
                                                        <label class="control-label font-weight-light">(4AM - 12PM)</label>
                                                    </div>
                                                    <div class="col-6">
                                                        <input type="time" class="form-control" name="wednesday[]" value="<?php echo e($user->schedules->wednesday[0]); ?>" min="04:00" max="12:00">
                                                    </div> 
                                                    <div class="col-6">
                                                        <input type="time" class="form-control" name="wednesday[]" value="<?php echo e($user->schedules->wednesday[1]); ?>" min="04:00" max="12:00">
                                                    </div>   
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-12">
                                                <div class="row form-group">
                                                    <div class="col-12">
                                                        <label class="control-label font-weight-light">(1PM - 12:00AM)</label>
                                                    </div>
                                                    <div class="col-6">
                                                        <input type="time" class="form-control" name="wednesday[]" value="<?php echo e($user->schedules->wednesday[2]); ?>" min="13:00" max="00:00">
                                                    </div> 
                                                    <div class="col-6">
                                                        <input type="time" class="form-control" name="wednesday[]" value="<?php echo e($user->schedules->wednesday[3]); ?>" min="13:00" max="00:00">
                                                    </div>   
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-12">
                                                <label class="control-label">Thursday</label>                                
                                            </div>
                                            <div class="col-lg-6 col-12">
                                                <div class="row form-group">
                                                    <div class="col-12">
                                                        <label class="control-label font-weight-light">(4AM - 12PM)</label>
                                                    </div>
                                                    <div class="col-6">
                                                        <input type="time" class="form-control" name="thursday[]" value="<?php echo e($user->schedules->thursday[0]); ?>" min="04:00" max="12:00">
                                                    </div> 
                                                    <div class="col-6">
                                                        <input type="time" class="form-control" name="thursday[]" value="<?php echo e($user->schedules->thursday[1]); ?>" min="04:00" max="12:00">
                                                    </div>   
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-12">
                                                <div class="row form-group">
                                                    <div class="col-12">
                                                        <label class="control-label font-weight-light">(1PM - 12:00AM)</label>
                                                    </div>
                                                    <div class="col-6">
                                                        <input type="time" class="form-control" name="thursday[]" value="<?php echo e($user->schedules->thursday[2]); ?>" min="13:00" max="00:00">
                                                    </div> 
                                                    <div class="col-6">
                                                        <input type="time" class="form-control" name="thursday[]" value="<?php echo e($user->schedules->thursday[3]); ?>" min="13:00" max="00:00">
                                                    </div>   
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-12">
                                                <label class="control-label">Friday</label>                                
                                            </div>
                                            <div class="col-lg-6 col-12">
                                                <div class="row form-group">
                                                    <div class="col-12">
                                                        <label class="control-label font-weight-light">(4AM - 12PM)</label>
                                                    </div>
                                                    <div class="col-6">
                                                        <input type="time" class="form-control" name="friday[]" value="<?php echo e($user->schedules->friday[0]); ?>" min="04:00" max="12:00">
                                                    </div> 
                                                    <div class="col-6">
                                                        <input type="time" class="form-control" name="friday[]" value="<?php echo e($user->schedules->friday[1]); ?>" min="04:00" max="12:00">
                                                    </div>   
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-12">
                                                <div class="row form-group">
                                                    <div class="col-12">
                                                        <label class="control-label font-weight-light">(1PM - 12:00AM)</label>
                                                    </div>
                                                    <div class="col-6">
                                                        <input type="time" class="form-control" name="friday[]" value="<?php echo e($user->schedules->friday[2]); ?>" min="13:00" max="00:00">
                                                    </div> 
                                                    <div class="col-6">
                                                        <input type="time" class="form-control" name="friday[]" value="<?php echo e($user->schedules->friday[3]); ?>" min="13:00" max="00:00">
                                                    </div>   
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-12">
                                                <label class="control-label">Saturday</label>                                
                                            </div>
                                            <div class="col-lg-6 col-12">
                                                <div class="row form-group">
                                                    <div class="col-12">
                                                        <label class="control-label font-weight-light">(4AM - 12PM)</label>
                                                    </div>
                                                    <div class="col-6">
                                                        <input type="time" class="form-control" name="saturday[]" value="<?php echo e($user->schedules->saturday[0]); ?>" min="04:00" max="12:00">
                                                    </div> 
                                                    <div class="col-6">
                                                        <input type="time" class="form-control" name="saturday[]" value="<?php echo e($user->schedules->saturday[1]); ?>" min="04:00" max="12:00">
                                                    </div>   
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-12">
                                                <div class="row form-group">
                                                    <div class="col-12">
                                                        <label class="control-label font-weight-light">(1PM - 12:00AM)</label>
                                                    </div>
                                                    <div class="col-6">
                                                        <input type="time" class="form-control" name="saturday[]" value="<?php echo e($user->schedules->saturday[1]); ?>" min="04:00" max="12:00" min="13:00">
                                                    </div> 
                                                    <div class="col-6">
                                                        <input type="time" class="form-control" name="saturday[]" value="<?php echo e($user->schedules->saturday[2]); ?>" min="13:00" max="00:00">
                                                    </div>   
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-12">
                                                <label class="control-label">Sunday</label>                                
                                            </div>
                                            <div class="col-lg-6 col-12">
                                                <div class="row form-group">
                                                    <div class="col-12">
                                                        <label class="control-label font-weight-light">(4AM - 12PM)</label>
                                                    </div>
                                                    <div class="col-6">
                                                        <input type="time" class="form-control" name="sunday[]" value="<?php echo e($user->schedules->sunday[0]); ?>" min="04:00" max="12:00">
                                                    </div> 
                                                    <div class="col-6">
                                                        <input type="time" class="form-control" name="sunday[]" value="<?php echo e($user->schedules->sunday[1]); ?>" min="04:00" max="12:00">
                                                    </div>   
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-12">
                                                <div class="row form-group">
                                                    <div class="col-12">
                                                        <label class="control-label font-weight-light">(1PM - 12:00AM)</label>
                                                    </div>
                                                    <div class="col-6">
                                                        <input type="time" class="form-control" name="sunday[]" value="<?php echo e($user->schedules->sunday[2]); ?>" min="13:00" max="00:00">
                                                    </div> 
                                                    <div class="col-6">
                                                        <input type="time" class="form-control" name="sunday[]" value="<?php echo e($user->schedules->sunday[3]); ?>" min="13:00" max="00:00">
                                                    </div>   
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-12">
                                                <button type="submit" class="btn btn-info" id="save">
                                                    <i class="mdi mdi-content-save"></i> Change Schedule
                                                </button>                            
                                            </div>
                                        </div>
                                    </form>                                 
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php echo $__env->make('dashboard.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
    </div>
    
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script type="text/javascript">

        // account settings
        $('form#account-settings').submit( function(e){
            e.preventDefault();

            $(this).parsley().validate();
            if ($(this).parsley().isValid()) {

                var formData = $(this).serialize();
                $.ajax({
                    type: "POST",
                    url: "<?php echo e(route('profile')); ?>",
                    data: formData,
                    success: function (response) {

                        $('#email').removeClass('parsley-error');
                        $('.email').removeClass('text-danger');
                        $('.email').text('');
                        $('.contact_number').text('');

                        if (response.message == 'success') {
                            swal({
                                title: "Success",
                                text: 'Account updated successfully',
                                type: "success",
                                showConfirmButton: false,
                                timer: 1500
                            });
                        } else {
                            
                            if (response.message.email) {
                                $('#email').addClass('parsley-error');
                                $('.email').addClass('text-danger');
                                $('.email').text(response.message.email);
                            } else {
                                $('#contact_number').addClass('parsley-error');
                                $('.contact_number').addClass('text-danger');
                                $('.contact_number').addClass('text-danger');
                                $('.contact_number').text(response.message.contact_number);
                            }
                        }
                    },
                    error: function (response) {
                        console.log('Error:', response);
                    }
                });
            }
        });

        // change password
        $('form#change-password').submit( function(e){
            e.preventDefault();

            $(this).parsley().validate();
            if ($(this).parsley().isValid()) {

                var formData = $(this).serialize();
                $.ajax({
                    type: "POST",
                    url: "<?php echo e(route('profile.password')); ?>",
                    data: formData,
                    success: function (response) {
                        if (response.message == 'success') {
                            $('#current_password').removeClass('parsley-error');
                            $('.current_password').removeClass('text-danger');
                            $('.current_password').text('');

                            $('#current_password').val('');
                            $('#password').val('');
                            $('#confirm_password').val('');
                            
                            swal({
                                title: "Success",
                                text: 'Change password successfully',
                                type: "success",
                                showConfirmButton: false,
                                timer: 1500
                            });
                           
                        } else {
                            
                            $('#current_password').addClass('parsley-error');
                            $('.current_password').addClass('text-danger');
                            $('.current_password').text(response.message);                            
                        }
                    },
                    error: function (response) {
                        console.log('Error:', response);
                    }
                });
            }
        });

        // change schedules
        $('form#change-schedules').submit( function(e){
            e.preventDefault();

            var formData = $(this).serialize();
            $.ajax({
                type: "POST",
                url: "<?php echo e(route('profile.schedules')); ?>",
                data: formData,
                success: function (response) {
                    if (response.message == 'success') {
                        swal({
                            title: "Success",
                            text: 'Change Schedules successfully',
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });
                    }
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });
        
   </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/pplus_web/resources/views/dashboard/main/profile.blade.php ENDPATH**/ ?>