<?php $__env->startSection('title','Edit Doctor'); ?>

<?php $__env->startSection('content'); ?>

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Edit Doctor</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="<?php echo e(route('dashboard')); ?>">Home</a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="<?php echo e(route('merchants.doctors')); ?>">Doctors</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Edit Doctor</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <form method="POST" action="<?php echo e(route('merchants.doctors.update', base64_encode($doctor->user_id))); ?>" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                   <div class="col-lg-3 col-12">
                                        <label>PHOTO</label>
                                        <input type="file" id="input-file-now-custom-2" name="image" value="<?php echo e(old('image')); ?>" data-default-file="<?php echo e($doctor->path); ?>" class="dropify" data-height="300" data-allowed-file-extensions="jpeg png jpg"/>
                                        <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <p class="mt-2 text-center">Image must be square and at least 500x500 pixels</p>
                                    </div>
                                    <div class="col-lg-9 col-12">
                                        <h4 class="card-title mb-4">Personal Information</h4>
                                        <div class="row">
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>First Name*</label>
                                                <input type="text" class="form-control <?php $__errorArgs = ['firstname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="firstname" value="<?php echo e(old('firstname', $doctor->firstname)); ?>" placeholder="Enter first name" required>
                                                <?php $__errorArgs = ['firstname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                 <label>Middle Name</label>
                                                <input type="text" class="form-control <?php $__errorArgs = ['middlename'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="middlename" value="<?php echo e(old('middlename', $doctor->middlename)); ?>" placeholder="Enter middle name">
                                                <?php $__errorArgs = ['middlename'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>Last Name*</label>
                                                 <input type="text" class="form-control <?php $__errorArgs = ['lastname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="lastname" value="<?php echo e(old('lastname', $doctor->lastname)); ?>" placeholder="Enter last name" required>
                                                <?php $__errorArgs = ['lastname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>Prefix*</label>
                                                <input type="text" class="form-control <?php $__errorArgs = ['prefix'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('prefix', $doctor->prefix)); ?>" placeholder="Enter prefix" name="prefix" required>
                                                <?php $__errorArgs = ['prefix'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>Email*</label>
                                                <input type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('email', $doctor->email)); ?>" placeholder="Enter email" name="email" required>
                                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>Mobile No.*</label>
                                                <input type="text" class="form-control <?php $__errorArgs = ['contact_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('contact_number', $doctor->contact_number)); ?>" placeholder="Enter mobile number" name="contact_number" maxlength="13" required>
                                                <?php $__errorArgs = ['contact_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Minimum Consultation Fee*</label>
                                                <input type="text" class="form-control number <?php $__errorArgs = ['minimum_consultation_fee'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('minimum_consultation_fee', $doctor->minimum_consultation_fee)); ?>" placeholder="0.00" name="minimum_consultation_fee" required>
                                                <?php $__errorArgs = ['minimum_consultation_fee'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Maximum Consultation Fee*</label>
                                                <input type="text" class="form-control number <?php $__errorArgs = ['maximum_consultation_fee'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('maximum_consultation_fee', $doctor->maximum_consultation_fee)); ?>" placeholder="0.00" name="maximum_consultation_fee" required>
                                                <?php $__errorArgs = ['maximum_consultation_fee'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Specialities*</label>
                                                <select class="form-control multiple" name="doctor_specialities[]" id="doctor_specialities" multiple="multiple" required>
                                                    <?php $__currentLoopData = $specialities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $speciality): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if(is_array(old('doctor_specialities'))): ?>
                                                            <option value="<?php echo e($speciality->id); ?>" <?php echo e(in_array($speciality->id, old('doctor_specialities')) ? 'selected' : ''); ?>>
                                                                <?php echo e(ucwords($speciality->name)); ?>

                                                            </option>
                                                        <?php else: ?>
                                                            <option value="<?php echo e($speciality->id); ?>" <?php echo e(in_array($speciality->id, $doctor->specialities) ? 'selected' : ''); ?>>
                                                                <?php echo e(ucwords($speciality->name)); ?>

                                                            </option>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>HMO*</label>
                                                <select class="form-control multiple" name="doctor_payment_methods[]" id="doctor_payment_methods" multiple="multiple" required>
                                                    <?php if(is_array(old('doctor_payment_methods'))): ?>
                                                        <option value="maxicare" <?php echo e(in_array('maxicare', old('doctor_payment_methods')) ? 'selected' : ''); ?>>Maxicare</option>
                                                        <option value="life_insurance" <?php echo e(in_array('life_insurance', old('doctor_payment_methods')) ? 'selected' : ''); ?>>Life Insurance</option>
                                                        <option value="asian_care" <?php echo e(in_array('asian_care', old('doctor_payment_methods')) ? 'selected' : ''); ?>>Asian Care</option>
                                                        <option value="coco_life" <?php echo e(in_array('coco_life', old('doctor_payment_methods')) ? 'selected' : ''); ?>>Coco Life</option>
                                                    <?php else: ?>
                                                        <option value="maxicare" <?php echo e(in_array('maxicare', $doctor->payment_methods) ? 'selected' : ''); ?>>Maxicare</option>
                                                        <option value="life_insurance" <?php echo e(in_array('life_insurance', $doctor->payment_methods) ? 'selected' : ''); ?>>Life Insurance</option>
                                                        <option value="asian_care" <?php echo e(in_array('asian_care', $doctor->payment_methods) ? 'selected' : ''); ?>>Asian Care</option>
                                                        <option value="coco_life" <?php echo e(in_array('coco_life', $doctor->payment_methods) ? 'selected' : ''); ?>>Coco Life</option>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                            
                                            <div class="col-12 form-group">
                                                <h4 class="card-title mt-2">Account Information</h4>
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Username*</label>
                                                <input type="text" class="form-control <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('username', $doctor->username)); ?>" placeholder="Enter username" name="username" disabled>
                                                <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                
                                            <div class="col-lg-12 col-12 form-group text-right">
                                                <a href="<?php echo e(route('merchants.doctors')); ?>">
                                                    <button type="button" class="btn btn-danger">
                                                        <i class="mdi mdi-close-circle"></i> Cancel
                                                    </button>
                                                </a>
                                                <button type="submit" class="btn btn-info">
                                                    <i class="fa fa-save"></i> Update
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php echo $__env->make('dashboard.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
    </div>
    
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script type="text/javascript">
        
       // All select option
        $('select').select2({
            width : '100%'
        });

   </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/pplus_web/resources/views/dashboard/merchants/doctors/edit.blade.php ENDPATH**/ ?>