<?php $__env->startSection('title','Bayanihan Point Settings'); ?>

<?php $__env->startSection('content'); ?>

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Bayanihan Point Settings</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="<?php echo e(route('dashboard')); ?>">Home</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Bayanihan Point Settings</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-6 col-12">
                    <h4 class="page-title mt-2">
                        <i class="mdi mdi-account-settings-variant"></i>
                        List of Bayanihan Point Settings (<span id="count">0</span>)
                    </h4>                
                </div>
                <div class="col-lg-6 col-12 text-right">
                    <button class="btn btn-success" onclick="addMemberType()">
                        <i class="fa fa-plus"></i> Add Point Setting
                    </button>       
                </div>
                <div class="col-12 mt-1">
                    <div class="card">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="bayanihanSettingsTable" class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Points</th>
                                            <th>Status</th>
                                            <th>Date/Time Created</th>
                                            <th width="10%">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- modal -->
        <div id="addPointSettingModal" class="modal" tabindex="-1" role="dialog" aria-labelledby="vcenter" aria-hidden="true" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <form method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="modal-header">
                            <h4 class="modal-title" id="vcenter">
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                        </div>
                        <div class="modal-body">
                            <div class="form-group">
                                <label class="control-label">Points*</label>
                                <input type="text" class="form-control number-with-decimal" name="points" id="points" placeholder="Enter points" required>
                                <input type="hidden" name="bayanihan_id" id="bayanihan_id">
                                <div class="invalid-feedback points"></div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger waves-effect" data-dismiss="modal">Cancel</button>
                            <button type="submit" id="save" class="btn btn-info waves-effect">
                                <i class="fa fa-save"></i> Save
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <?php echo $__env->make('dashboard.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
    </div>
    
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script type="text/javascript">
       
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        var table = $('#bayanihanSettingsTable').DataTable({
            ajax: "<?php echo e(route('bayanihan.pointsettings.list')); ?>",
            columns: [
                { data : 'DT_RowIndex' },
                { data : 'points' },
                { data : 'status' },
                { data : 'created_at' },
                { data : 'action', orderable: false, searchable: false}
            ],
            paging      : true,
            lengthChange: true,
            searching   : true,
            ordering    : false,
            info        : true,
            autoWidth   : false,
            dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                        "<'row'<'col-12'tr>>" +
                        "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
            fnDrawCallback: function () {
                self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                $('#count').text(self.QtdOcorrenciasAgendadosHoje);
            }
        });

         // Modal Add
        function addMemberType() {
            $('#addPointSettingModal').modal('show');
            $('#save').removeAttr('disabled',true);
            $('#points').removeClass('is-invalid');
            $('.points').removeClass('invalid-feedback');
            $('.points').text('');
            $('#points').val('');

            $('#bayanihan_id').val('');

            var content = "<i class='mdi mdi-plus'></i> Add Point Setting";
            $('#vcenter').html(content);
        }

        // Modal Edit
        $('body').on('click','#edit', function(e){
            e.preventDefault();

            $('#save').removeAttr('disabled',true);
            $('#points').removeClass('is-invalid');
            $('.points').removeClass('invalid-feedback');
            $('.points').text('');
            
            var content = "<i class='mdi mdi-table-edit'></i> Edit Point Setting";
            $('#vcenter').html(content);

            var url = $(this).attr('href');

            $.ajax({
                type: "GET",
                url: url,
                success: function (response) {
                    $('#points').val(response.points);
                    $('#bayanihan_id').val(response.id);
                    $('#addPointSettingModal').modal('show');
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });

        // Form Add & Update
        $('form').submit( function(e){
            e.preventDefault();

            $('#save').attr('disabled',true);

            const bayanihan_id = $('#bayanihan_id').val();

            var url = bayanihan_id == '' ? '<?php echo e(route('bayanihan.pointsettings')); ?>' : 
                                    '<?php echo e(route('bayanihan.pointsettings.update')); ?>';

            var formData = $(this).serialize();

            $.ajax({
                type: "POST",
                url: url,
                data: formData,
                success: function (response) {

                    if (response.message == 'success') {
                        $('#save').removeAttr('disabled',true);
                        $('#addPointSettingModal').modal('hide');
                        $('#points').removeClass('is-invalid');
                        $('.points').removeClass('invalid-feedback');
                        $('.points').text('');
                        $('#points').val('');
        
                        table.ajax.reload();
                        swal({
                            title: "Success",
                            text: 'Point Setting successfully',
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });
                    } else {
                        $('#save').removeAttr('disabled',true);
                        $('#points').addClass('is-invalid');
                        $('.points').addClass('invalid-feedback');
                        $('.points').text(response.message.points);
                    }
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });

         // Status Activate or Deactivate
        $('body').on('click','#status', function(e){
            e.preventDefault();

            var url = $(this).attr('href');

            swal({
                title: "Are you sure?",
                text: "Once you Activate, it will Activate qualified points!",
                type: "warning",
                confirmButtonClass: 'btn-success',
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: 'Activate',
                closeOnConfirm: false,
            },
            ()=>{
                $.ajax({
                    type: "POST",
                    url: url,
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>"
                    },
                    success: function (response) {
                        table.ajax.reload();
                        swal({
                            title: "Activated!",
                            text: response.message,
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });
                    },
                    error: function (response) {
                        swal('Error!', response, 'danger');
                    }
                });
            });
        });

   </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/pplus_web/resources/views/dashboard/settings/bayanihan-points/index.blade.php ENDPATH**/ ?>