<?php $__env->startSection('title','Orders'); ?>
<?php $__env->startSection('styles'); ?>
    <style type="text/css">
        #orderTable tbody tr td:nth-child(2), 
        #orderTable tbody tr td:nth-child(3), 
        #orderTable tbody tr td:nth-child(4){
            padding-top: 24px !important;
        }
        .order-table tbody tr td:nth-child(1), 
        .order-table tbody tr td:nth-child(3), 
        .order-table tbody tr td:nth-child(4), 
        .order-table tbody tr td:nth-child(5){
            padding-top: 24px !important;
        }
        .order-table tbody tr td:nth-child(6){
            padding-top: 20px !important;
        }
        .form-group{
            margin-bottom: .6rem;
        }
        #viewOrderModal h5{
            font-weight: 500;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Orders</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="<?php echo e(route('dashboard')); ?>">Home</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Orders</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-6 col-12">
                    <h4 class="page-title mt-2">
                        <i class="mdi mdi-cart"></i>
                        List of Orders 
                    </h4>                
                </div>
                <div class="col-lg-6 col-12 text-right">
                    <button class="btn btn-success" onclick="ajaxReloadTable()">
                        <i class="mdi mdi-refresh"></i> Refresh
                    </button>  
                </div>
                <div class="col-12 mt-1">
                    <div class="card">
                        <div class="card-body">
                            <ul class="nav nav-tabs" role="tablist">
                                <li class="nav-item"> 
                                    <a class="nav-link active" data-toggle="tab" href="#pending" role="tab">
                                        <span class="hidden-xs-down"> 
                                            Pending (<span id="pending_count">0</span>)
                                        </span>
                                    </a> 
                                </li>
                                <li class="nav-item"> 
                                    <a class="nav-link" data-toggle="tab" href="#ongoing" role="tab">
                                        <span class="hidden-xs-down"> 
                                            Ongoing (<span id="ongoing_count">0</span>)
                                        </span>
                                    </a> 
                                </li>
                                <li class="nav-item"> 
                                    <a class="nav-link" data-toggle="tab" href="#completed" role="tab">
                                        <span class="hidden-xs-down"> 
                                            Completed (<span id="completed_count">0</span>)
                                        </span>
                                    </a> 
                                </li>
                                <li class="nav-item"> 
                                    <a class="nav-link" data-toggle="tab" href="#cancelled" role="tab">
                                        <span class="hidden-xs-down"> 
                                            Cancelled (<span id="cancelled_count">0</span>)
                                        </span>
                                    </a> 
                                </li>
                            </ul>
                            <!-- Tab panes -->
                            <div class="tab-content tabcontent-border">
                                <div class="tab-pane active" id="pending" role="tabpanel">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="table-responsive mt-4">
                                                <table id="pendingTable" class="table table-hover order-table">
                                                    <thead>
                                                        <tr>
				                                            <th>Reference #</th>
				                                            <th>Customer</th>
				                                            <th>Address</th>
				                                            <th>Date Scheduled</th>
				                                            <th>Status</th>
				                                            <th width="10%">Action</th>
				                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                    	
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane" id="ongoing" role="tabpanel">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="table-responsive mt-4">
                                                <table id="ongoingTable" class="table table-hover order-table">
                                                    <thead>
                                                        <tr>
				                                            <th>Reference #</th>
				                                            <th>Customer</th>
				                                            <th>Address</th>
				                                            <th>Date Scheduled</th>
				                                            <th>Status</th>
				                                            <th width="10%">Action</th>
				                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                    	
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane" id="completed" role="tabpanel">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="table-responsive mt-4">
                                                <table id="completedTable" class="table table-hover order-table">
                                                    <thead>
                                                        <tr>
                                                            <th>Reference #</th>
                                                            <th>Customer</th>
                                                            <th>Address</th>
                                                            <th>Date Scheduled</th>
                                                            <th>Status</th>
                                                            <th width="10%">Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane" id="cancelled" role="tabpanel">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="table-responsive mt-4">
                                                <table id="cancelledTable" class="table table-hover order-table">
                                                    <thead>
                                                        <tr>
				                                            <th>Reference #</th>
				                                            <th>Customer</th>
				                                            <th>Address</th>
				                                            <th>Date Scheduled</th>
				                                            <th>Status</th>
				                                            <th width="10%">Action</th>
				                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                    	
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- modal -->
        <?php echo $__env->make('dashboard.merchants.orders.partials.view-orders', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make('dashboard.merchants.orders.partials.update-order', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php echo $__env->make('dashboard.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
    </div>
    
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('admin_dashboard/assets/libs/moment/moment.js')); ?>"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/plug-ins/1.10.21/api/sum().js"></script>
    <script type="text/javascript">

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        var pendingTable = $('#pendingTable').DataTable({
            ajax: "<?php echo e(route('merchants.orders.list','status=pending')); ?>",
            columns: [
                { data : 'reference_id' },
                { data : 'name' },
                { data : 'address' },
                { data : 'date_scheduled' },
                { data : 'status' },
                { data : 'action', orderable: false, searchable: false}
            ],
            paging      : true,
            lengthChange: true,
            searching   : true,
            ordering    : false,
            info        : true,
            autoWidth   : false,
            dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                        "<'row'<'col-12'tr>>" +
                        "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
            fnDrawCallback: function () {
                self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                $('#pending_count').text(self.QtdOcorrenciasAgendadosHoje);
            }
        });

        var ongoingTable = $('#ongoingTable').DataTable({
            ajax: "<?php echo e(route('merchants.orders.list','status=ongoing')); ?>",
            columns: [
                { data : 'reference_id' },
                { data : 'name' },
                { data : 'address' },
                { data : 'date_scheduled' },
                { data : 'status' },
                { data : 'action', orderable: false, searchable: false}
            ],
            paging      : true,
            lengthChange: true,
            searching   : true,
            ordering    : false,
            info        : true,
            autoWidth   : false,
            dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                        "<'row'<'col-12'tr>>" +
                        "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
            fnDrawCallback: function () {
                self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                $('#ongoing_count').text(self.QtdOcorrenciasAgendadosHoje);
            }
        });

        var completedTable = $('#completedTable').DataTable({
            ajax: "<?php echo e(route('merchants.orders.list','status=completed')); ?>",
            columns: [
                { data : 'reference_id' },
                { data : 'name' },
                { data : 'address' },
                { data : 'date_scheduled' },
                { data : 'status' },
                { data : 'action', orderable: false, searchable: false}
            ],
            paging      : true,
            lengthChange: true,
            searching   : true,
            ordering    : false,
            info        : true,
            autoWidth   : false,
            dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                        "<'row'<'col-12'tr>>" +
                        "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
            fnDrawCallback: function () {
                self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                $('#completed_count').text(self.QtdOcorrenciasAgendadosHoje);
            }
        });

        var cancelledTable = $('#cancelledTable').DataTable({
            ajax: "<?php echo e(route('merchants.orders.list','status=cancelled')); ?>",
            columns: [
                { data : 'reference_id' },
                { data : 'name' },
                { data : 'address' },
                { data : 'date_scheduled' },
                { data : 'status' },
                { data : 'action', orderable: false, searchable: false}
            ],
            paging      : true,
            lengthChange: true,
            searching   : true,
            ordering    : false,
            info        : true,
            autoWidth   : false,
            dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                        "<'row'<'col-12'tr>>" +
                        "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
            fnDrawCallback: function () {
                self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                $('#cancelled_count').text(self.QtdOcorrenciasAgendadosHoje);
            }
        });

        $('#updateOrderModal').on('hidden.bs.modal', function (e) {
            var transaction_id = $('#transaction_id').val();
            getOrdersTable(atob(transaction_id));
        });

        var edit_url;
        $('#update_order').submit( function(e){
            e.preventDefault();

            var formData = $(this).serialize();
            swal({
                title: "Are you sure?",
                text: "Once you Continue, it will update order quantity!",
                type: "warning",
                confirmButtonClass: 'btn-info',
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: 'Continue',
                closeOnConfirm: false,
            },
            ()=>{
                $.ajax({
                    type: "POST",
                    url: edit_url,
                    data: formData,
                    success: function (response) {
                        swal({
                            title: "Success",
                            text: 'Order successfully updated!',
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });
                        $('#updateOrderModal').modal('hide');
                        edit_url = null;
                    },
                    error: function (response) {
                        swal('Error!', response, 'danger');
                    }
                });
            });
        });

        //edit modal
        $('body').on('click', '#edit', function(e){
            e.preventDefault();
            edit_url = $(this).attr('href');
            $('#updateOrderModal').modal('show');
            $('#update_order')[0].reset();
        });

        //delete modal
        $('body').on('click', '#delete', function(e){
            e.preventDefault();
            var url = $(this).attr('href');

            swal({
                title: "Are you sure?",
                text: "Once you Remove, it will cancel the item!",
                type: "warning",
                confirmButtonClass: 'btn-danger',
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: 'Cancel Item',
                closeOnConfirm: false,
            },
            ()=>{
                $.ajax({
                    type: "GET",
                    url: url,
                    success: function (response) {
                        swal({
                            title: "Cancelled!",
                            text: 'Item cancelled successfully',
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });
                        
                        var transaction_id = $('#transaction_id').val();
                        getOrdersTable(atob(transaction_id));
                    },
                    error: function (response) {
                        console.log('Error:', response);
                    }
                });
            });
        });

        // view modal
        $('body').on('click', '#view', function(e){
            e.preventDefault();

            var url = $(this).attr('href');
            
            $.ajax({
                type: "GET",
                url: url,
                beforeSend: function(){
                   loadingAjaxPreloader();
                },
                success: function (response) {
                    if(response.message == 'No Orders') {
                        swal({
                            title: "Cancelled!",
                            text: 'Order already cancelled',
                            type: "danger",
                            showConfirmButton: false,
                            timer: 1500
                        });
                        location.reload();
                    }
                    addStatusColor(response.status);
                    getOrdersTable(response.id)
                    
                    $('#transaction_id').val(btoa(response.id));
                    $('#cash_on_hand').text(numberFormat(response.cash_on_hand));
                    $('#delivery_amount').val(response.delivery_amount);
                    $('#reference_no').text('#'+response.reference_id);
                    $('.customer_name').text(response.name);
                    $('.mobile_number').text(response.mobile_number);
                    $('#customer_address').text(response.customer_address);
                    $('#address').text(response.address);
                    $('#payment_method').text(response.payment_method);
                    $('#notes').text(response.notes);
                    $('#date_ordered').text(response.date_ordered);
                    $('#date_scheduled').text(response.date_scheduled);

                    $('#div_driver').hide();
                    $('#div_amount').hide();
                    $('#drivers').removeAttr('required', true);

                    console.log(response);

                    if (response.payment_method != "Pick Up") {
                        select2();
                        $('#div_amount').show();
                        $('#delivery_amount').attr('required', true);
                        $('#delivery_amount').empty();
                        if(response.status == "accepted") {
                            $('#div_driver').show();
                            $('#drivers').attr('required', true);
                            $('#drivers').empty();
                            $('#drivers').append('<option value="" selected disabled>Select Driver</option>');
                            $.each(response.drivers, function(id, data) {
                                $('#drivers').append('<option value="'+ data.id +'" '+ ((response.driver_id == data.id) ? 'selected' : '') +'>'+data.firstname+' '+ data.lastname+'</option>'); 
                            });
                        }
                    }
            
                    $('#actions').html(getStatusButton(response));
                    $('#viewOrderModal').modal('show');
                    successAjaxPreloader();
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });

        // form submit
        $('#order-form').submit( function(e){
            e.preventDefault();
            
            var url = $('#order_status').attr('href');
            var formData = $(this).serialize();

            swal({
                title: "Are you sure?",
                text: "Once you Continue, it will update order status!",
                type: "warning",
                confirmButtonClass: 'btn-info',
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: 'Continue',
                closeOnConfirm: false,
            },
            ()=>{
                $.ajax({
                    type: "POST",
                    url: url,
                    data: formData,
                    success: function (response) {
                        ajaxReloadTable();
                        swal({
                            title: "Success",
                            text: 'Order successfully updated!',
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });
                        $('#viewOrderModal').modal('hide');
                    },
                    error: function (response) {
                        swal('Error!', response, 'danger');
                    }
                });
            });
        });

        // cancelled order
        $('body').on('click', '#cancel', function(e){
            e.preventDefault();
            
            var url = $(this).attr('href');

            swal({
                title: "Are you sure?",
                text: "Once you Cancel, it will cancelled order!",
                type: "warning",
                confirmButtonClass: 'btn-danger',
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: 'Cancel Order',
                closeOnConfirm: false,
            },
            ()=>{
                $.ajax({
                    type: "POST",
                    url: url,
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>",
                        status: 'cancelled'
                    },
                    success: function (response) {
                        ajaxReloadTable();
                        swal({
                            title: "Cancelled!",
                            text: 'Order cancelled successfully',
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });
                        
                        $('#viewOrderModal').modal('hide');
                    },
                    error: function (response) {
                        console.log('Error:', response);
                    }
                });
            });
        });
        
        // reload all table
        function ajaxReloadTable(){
            pendingTable.ajax.reload();
            ongoingTable.ajax.reload();
            completedTable.ajax.reload();
            cancelledTable.ajax.reload();
        }

        // get orders table
        function getOrdersTable(transaction_id) {
            var url = '<?php echo e(route('merchants.orders.view.list', ':id')); ?>';
            $('#orderTable').DataTable({
                ajax: url.replace(':id', transaction_id),
                columns: [
                    { data : 'image' },
                    { data : 'name' },
                    { data : 'price' },
                    { data : 'quantity' },
                    { data : 'total_price' },
                    { data : 'action' },
                ],
                paging      : false,
                lengthChange: false,
                searching   : false,
                ordering    : false,
                info        : false,
                autoWidth   : false,
                destroy     : true,
                fnDrawCallback: function () {
                    self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                    $('#orders_count').text(self.QtdOcorrenciasAgendadosHoje);

                    var amount = this.api().column(4).data().sum();
                    $('#total_amount').text(numberFormat(amount));
                    $('#total_quantity').text(this.api().column(3).data().sum());
                }
            });
        }

        // amount number format
        function numberFormat(num) {
            return '₱ '+parseFloat(num).toFixed(2).replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1,')
        }

        // add status bg-color
        function addStatusColor(status) {
            $('.bg-pending, .bg-ongoing, .bg-completed').removeAttr('style');
            if (status == 'pending') {
                $('.bg-pending').css("background-color", "#8dc83d");
                $('.bg-pending').css("color", "#fff");
            } else if (status == 'accepted' || status == 'prepared' || status == 'otw' || status == 'arrived' || status == 'pending_customer') {
                $('.bg-pending').css("background-color", "#8dc83d");
                $('.bg-ongoing').css("background-color", "#8dc83d");
                $('.bg-pending, .bg-ongoing').css("color", "#fff");
            } else if (status == 'cancelled') {
                $('.bg-pending').css("background-color", "#fa5838");
                $('.bg-ongoing').css("background-color", "#fa5838");
                $('.bg-completed').css("background-color", "#fa5838");
                $('.bg-pending, .bg-ongoing, .bg-completed').css("color", "#fff");
            } else if (status == 'completed') {
                $('.bg-pending').css("background-color", "#8dc83d");
                $('.bg-ongoing').css("background-color", "#8dc83d");
                $('.bg-completed').css("background-color", "#8dc83d");
                $('.bg-pending, .bg-ongoing, .bg-completed').css("color", "#fff");
            }
        }

        function getStatusButton(response) {
            let action = '';
            var url = '<?php echo e(route('merchants.orders.update', ':id')); ?>';
            if (response.status == 'pending') {
                action += '<div class="row">';
                    action += '<div class="col-6 pr-1">';
                        action += '<a href='+url.replace(':id', btoa(response.id))+' id="cancel">';
                            action += '<button type="button" class="btn btn-danger btn-block"> Cancel Order </button>';
                        action += '</a>';
                    action += '</div>';
                    action += '<div class="col-6 pl-1">';
                        action += '<a href='+url.replace(':id', btoa(response.id))+' id="order_status">';
                            action += '<button class="btn btn-info btn-block"> Accept Order </button>';
                        action += '</a>';
                    action += '</div>';
                action += '</div>';
            } else if (response.status == 'accepted') {
                action += '<div class="row">';
                    action += '<div class="col-6 pr-1">';
                        action += '<a href='+url.replace(':id', btoa(response.id))+' id="cancel">';
                            action += '<button type="button" class="btn btn-danger btn-block"> Cancel Order </button>';
                        action += '</a>';
                    action += '</div>';
                    action += '<div class="col-6 pl-1">';
                        action += '<a href='+url.replace(':id', btoa(response.id))+' id="order_status">';
                            action += '<button class="btn btn-info btn-block"> Prepare Order </button>';
                        action += '</a>';
                    action += '</div>';
                action += '</div>';
            } else if (response.status == 'prepared') {
                action += '<div class="row">';
                    if (response.payment_method == "Pick Up") {
                        action += '<div class="col-6 pr-1">';
                            action += '<a href='+url.replace(':id', btoa(response.id))+' id="cancel">';
                                action += '<button type="button" class="btn btn-danger btn-block"> Cancel Order </button>';
                            action += '</a>';
                        action += '</div>';
                        action += '<div class="col-6 pr-1">';
                            action += '<a href='+url.replace(':id', btoa(response.id))+' id="order_status">';
                                action += '<button class="btn btn-info btn-block"> Picked Up </button>';
                            action += '</a>';
                        action += '</div>';
                    } else {
                        action += '<div class="col-12 pr-1">';
                            action += '<a href='+url.replace(':id', btoa(response.id))+' id="cancel">';
                                action += '<button type="button" class="btn btn-danger btn-block"> Cancel Order </button>';
                            action += '</a>';
                        action += '</div>';
                    }
                action += '</div>';
            } else if(response.status == 'pending_customer') {
                action += '<div class="col-12 pr-1">';
                    action += '<a href='+url.replace(':id', btoa(response.id))+' id="cancel">';
                        action += '<button type="button" class="btn btn-danger btn-block"> Cancel Order </button>';
                    action += '</a>';
                action += '</div>';
            }

            return action;
        }

        function select2() {
            $('select.select').select2({
                dropdownParent: $('#viewOrderModal'),
                width: '100%',
            });
        }
   </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/pplus_web/resources/views/dashboard/merchants/orders/index.blade.php ENDPATH**/ ?>