<?php $__env->startSection('title','Merchants'); ?>
<?php $__env->startSection('styles'); ?>
    <style type="text/css">
        tbody tr td:nth-child(2), 
        tbody tr td:nth-child(3), 
        tbody tr td:nth-child(4){
            padding-top: 24px !important;
        }
        tbody tr td:nth-child(5){
            padding-top: 20px !important;
        }
        .form-group{
            margin-bottom: .6rem;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Merchants</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="<?php echo e(route('dashboard')); ?>">Home</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Merchants</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-6 col-12">
                    <h4 class="page-title mt-2">
                        <i class="mdi mdi-cart"></i>
                        List of Merchants (<span id="count">0</span>)
                    </h4>                
                </div>
                <div class="col-lg-6 col-12 text-right">
                    <?php if(auth()->check() && auth()->user()->hasRole('super_admin|admin')): ?>
                        <a href="<?php echo e(route('merchants.add')); ?>">
                            <button class="btn btn-success">
                                <i class="mdi mdi-cart-plus"></i> Add Merchant
                            </button>  			   
                        </a>

			            <a href="<?php echo e(route('merchants.rebates')); ?>" target="_blank">
                            <button class="btn btn-success">
                                <i class="mdi mdi-cart-plus"></i> Manage Rebates
                            </button>  			   
                        </a>

                    <?php endif; ?>     
                </div>
                <div class="col-12 mt-1">
                    <div class="card">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="merchantTable" class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>Email</th>
                                            <th>Contact No.</th>
                                            <th>Industry Type</th>
                                            <th width="10%">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- view merchant modal -->
        <?php echo $__env->make('dashboard.merchants.partials.view-merchant-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php echo $__env->make('dashboard.merchants.partials.view-loyalty-points-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php echo $__env->make('dashboard.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
    </div>
    
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script type="text/javascript">
        
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        var table = $('#merchantTable').DataTable({
            ajax: "<?php echo e(route('merchants.list')); ?>",
            columns: [
                { data : 'name' },
                { data : 'email' },
                { data : 'contact_number' },
                { data : 'merchant_type' },
                { data : 'action', orderable: false, searchable: false}
            ],
            paging      : true,
            lengthChange: true,
            searching   : true,
            ordering    : false,
            info        : true,
            autoWidth   : false,
            dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                        "<'row'<'col-12'tr>>" +
                        "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
            fnDrawCallback: function () {
                self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                $('#count').text(self.QtdOcorrenciasAgendadosHoje);
            }
        });

        // view modal
        $('body').on('click', '#view', function(e){
            e.preventDefault();

            var url = $(this).attr('href');
            
            $.ajax({
                type: "GET",
                url: url,
                success: function (response) {
                    $('#image').attr('src',response.path);
                    $('#merchant_name').text(response.name);
                    $('#email').text(response.email);
                    $('#contact_number').text(response.contact_number);
                    $('#contact_person').text(response.contact_person);
                    $('#website').text(response.website);
                    $('#address').text(response.address);
                    $('#area_name').text(response.area_name);
                    $('#industry_type').text(response.type);
                    $('#date_start').text(response.date_startFormat);
                    $('#date_end').text(response.date_endFormat);
                    $('#rebate').text(response.rebate ? response.rebate+'%' : '0%');
                    $('#system').text(response.system ? response.system+'%' : '0%');
                    $('#accumulated').text(response.accumulated ? response.accumulated+'%' : '0%');
                    $('#advocacy').text(response.advocacy ? response.advocacy+'%' : '0%');
                    $('#member').text(response.member ? response.member+'%' : '0%');
                    $('#upline').text(response.upline ? response.upline+'%' : '0%');
                    $('#upline_number').text(response.upline_number ? response.upline_number : '0');

                    if (response.application_type != null) {
                        $('#application_type').removeClass('text-danger');
                        $('#application_type').text(response.application_type);
                    } else {
                        $('#application_type').addClass('text-danger');
                        $('#application_type').text('No Application Yet');
                    }

                    $('#viewMerchantModal').modal('show');
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });

        // view loyalty point
        $('body').on('click', '#points', function(e){
            e.preventDefault();

            var url = $(this).attr('href');
            
            $.ajax({
                type: "GET",
                url: url,
                success: function (response) {

                    var percentage = [];
                    for (var i = 0; i < 101; i++) {
                        percentage.push(i);
                    }

                    $('#loyalty_rebate').empty();
                    $.each(percentage, function(id, data) {
                        $('#loyalty_rebate').append('<option value="'+ data +'" '+ ((response.rebate == data) ? 'selected' : '') +'>'+ data +'%</option>'); 
                    });
                    $('#loyalty_system').empty();
                    $.each(percentage, function(id, data) {
                        $('#loyalty_system').append('<option value="'+ data +'" '+ ((response.system == data) ? 'selected' : '') +'>'+ data +'%</option>'); 
                    });
                    $('#loyalty_accumulated').empty();
                    $.each(percentage, function(id, data) {
                        $('#loyalty_accumulated').append('<option value="'+ data +'" '+ ((response.accumulated == data) ? 'selected' : '') +'>'+ data +'%</option>'); 
                    });
                    $('#loyalty_advocacy').empty();
                    $.each(percentage, function(id, data) {
                        $('#loyalty_advocacy').append('<option value="'+ data +'" '+ ((response.advocacy == data) ? 'selected' : '') +'>'+ data +'%</option>'); 
                    });
                    $('#loyalty_member').empty();
                    $.each(percentage, function(id, data) {
                        $('#loyalty_member').append('<option value="'+ data +'" '+ ((response.member == data) ? 'selected' : '') +'>'+ data +'%</option>'); 
                    });
                    $('#loyalty_upline').empty();
                    $.each(percentage, function(id, data) {
                        $('#loyalty_upline').append('<option value="'+ data +'" '+ ((response.upline == data) ? 'selected' : '') +'>'+ data +'%</option>'); 
                    });
                    $('#loyalty_merchant_name').text(response.name);
                    $('#loyalty_upline_no').val(response.upline_number);
                    $('#merchant_id').val(response.merchant_id);

                    select2();
                    calculate();

                    $('#viewLoyaltyPointsModal').modal('show');
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });

        // modal select
        function select2() {
            $('select.select').select2({
                dropdownParent: $('#viewLoyaltyPointsModal'),
                width: '100%',
            });
        }

        // form change then calculate
        $('form select').change( function(){
            calculate();
        });

        // amount change then calculate
        $('#amount, #loyalty_upline_no').on('input', function(){
            calculate();
        });

        // calculation
        function calculate() {

            let amount = $('#amount').val();
            let rebate = $('#loyalty_rebate').val();
            let system = $('#loyalty_system').val();
            let accumulated = $('#loyalty_accumulated').val();
            let advocacy = $('#loyalty_advocacy').val();
            let member = $('#loyalty_member').val();
            let upline = $('#loyalty_upline').val();
            let upline_no = $('#loyalty_upline_no').val();

            let total_rebate = amount * (rebate * .01);
            let total_system = total_rebate * (system * .01);
            let total_accumulated = total_rebate * (accumulated * .01);
            let total_advocacy = total_accumulated * (advocacy * .01);
            let total_member = total_accumulated * (member * .01);
            let total_upline = total_accumulated * (upline_no * .01);

            // calculation
            $('#total_rebate').text(total_rebate);
            $('#total_system').text(total_system);
            $('#total_accumulated').text(total_accumulated);
            $('#total_advocacy').text(total_advocacy);
            $('#total_member').text(total_member);
            $('#total_upline').text(total_upline);

            // append text on table
            $('#text_amount').text(amount);
            $('#text_rebate').text(rebate+'%');
            $('#text_system').text(system+'% for ');
            $('#text_accumulated').text(accumulated+'% for ');
            $('#text_advocacy').text(advocacy+'% of ');
            $('#text_member').text(member+'% of ');
            $('#text_upline').text(upline+'% of ');
            $('#text_upline_no').text(upline_no);
        }

        // form submit rebates
        $('form').submit( function(e){
            e.preventDefault();

            var url = '<?php echo e(route('merchants.settings.setuprebate', ':id')); ?>';
            var formData = $(this).serialize();

            swal({
                title: "Are you sure?",
                text: 'Once you continue, it will update merchant loyalty points!',
                type: "warning",
                confirmButtonClass: 'btn-danger',
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: 'Continue',
                closeOnConfirm: false,
            },
            ()=>{
                $.ajax({
                    type: "POST",
                    url: url.replace(':id', btoa($('#merchant_id').val())),
                    data: formData,
                    success: function (response) {
                        swal({
                            title: "Loyalty Points!",
                            text: 'Setup Loyalty Points successfully saved!',
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });
                        $('#viewLoyaltyPointsModal').modal('hide');
                    },
                    error: function (response) {
                        swal('Error!', response, 'danger');
                    }
                });
            });
        });

    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/pplus_web/resources/views/dashboard/merchants/index.blade.php ENDPATH**/ ?>