<header class="topbar">
    <nav class="navbar top-navbar navbar-expand-md navbar-dark">
        <div class="navbar-header">
            <a class="nav-toggler waves-effect waves-light d-block d-md-none" href="javascript:void(0)" style="color: #000;">
                <i class="ti-menu ti-close"></i>
            </a>

            <!-- Logo -->
            <div class="navbar-brand" style="padding: 0 39px;">
                <a href="<?php echo e(route('dashboard')); ?>" class="logo">
                    <span class="logo-text">
                        <img src="<?php echo e(asset('admin_dashboard/img/logo.png')); ?>" class="light-logo" alt="homepage" width="180"/>
                    </span>
                </a>
                <!-- <a class="sidebartoggler d-none d-md-block" href="javascript:void(0)" data-sidebartype="mini-sidebar">
                    <i class="mdi mdi-toggle-switch mdi-toggle-switch-off font-20"></i>
                </a> -->
            </div>
            <!-- End Logo -->

            <!-- Toggle which is visible on mobile only -->
            <a class="topbartoggler d-block d-md-none waves-effect waves-light" href="javascript:void(0)" data-toggle="collapse" data-target="#navbarSupportedContent"
                aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <i class="ti-more text-dark"></i>
            </a>
        </div>

        <div class="navbar-collapse collapse" id="navbarSupportedContent">
            <!-- ============================================================== -->
            <!-- toggle and nav items -->
            <!-- ============================================================== -->
            <ul class="navbar-nav float-left mr-auto">
                <!-- <li class="nav-item d-none d-md-block">
                    <a class="nav-link sidebartoggler waves-effect waves-light" href="javascript:void(0)" data-sidebartype="mini-sidebar">
                        <i class="mdi mdi-menu font-24"></i>
                    </a>
                </li> -->
                <?php if(auth()->check() && auth()->user()->hasRole('merchant_admin')): ?>
                    <li class="nav-item ml-4 text-white rounded" style="padding: 10px; background-color: #8dc83d;">
                        <?php if(getWalletMaintainingBalance() > getWalletBalance()): ?>
                            <span class="badge badge-sm badge-warning" style="width: 20px;height: 20px;border-radius: 50%; margin-right:-10px;z-index:1111;" data-container="body" data-toggle="popover" data-trigger="hover" data-placement="top" data-content="Your Wallet Remaining Balance is now below ₱ <?php echo e(number_format(getWalletMaintainingBalance(),2)); ?> . Please top-up immediately.">
                                <i class="fas fa-exclamation text-white"></i>
                            </span>
                        <?php endif; ?>
                        <span class="ml-2" style="font-weight: 500;">
                            Wallet Balance : ₱ <?php echo e(number_format(getWalletBalance(),2)); ?>

                        </span>
                    </li>
                <?php endif; ?>   
            </ul>
            <!-- Right side toggle and nav items -->
            <ul class="navbar-nav float-right">
                <!-- User profile and search -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle waves-effect waves-dark pro-pic" href="" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <?php if(isset(auth()->user()->images[0]->path)): ?>
                            <img src="<?php echo e(config('app.AWS_BUCKET_URL').auth()->user()->images[0]->path); ?>" alt="user" class="rounded-circle img-fluid profile_image" style="height: 36px !important; width: 36px;">
                        <?php else: ?>
                            <img src="<?php echo e(asset('admin_dashboard/img/default.png')); ?>" alt="user" class="rounded-circle img-fluid" width="40" height="40">
                        <?php endif; ?>
                        <span class="m-l-5 font-medium d-none d-sm-inline-block">
                            <?php if(auth()->check() && auth()->user()->hasRole('doctor')): ?>
                                <?php echo e(optional(auth()->user()->account)->prefix); ?>.
                            <?php endif; ?>
                            <?php echo e(ucwords(\Auth::user()->firstname.' '.\Auth::user()->lastname)); ?>

                            <i class="mdi mdi-chevron-down"></i>
                        </span>
                    </a>
                    <div class="dropdown-menu dropdown-menu-right user-dd animated flipInY">
                        <span class="with-arrow">
                            <span class="bg-primary" style="background-color: #8dc83d !important"></span>
                        </span>
                        <div class="d-flex no-block align-items-center p-15 bg-primary text-white m-b-10" style="background-color: #8dc83d!important;">
                            <?php if(isset(auth()->user()->images[0]->path)): ?>
                                <img src="<?php echo e(config('app.AWS_BUCKET_URL').auth()->user()->images[0]->path); ?>" alt="user" class="rounded-circle" width="60" height="60">
                            <?php else: ?>
                                <img src="<?php echo e(asset('admin_dashboard/img/default.png')); ?>" alt="user" class="rounded-circle" width="60" height="60">
                            <?php endif; ?>
                            <div class="m-l-10">
                                <h4 class="mb-0">
                                    <?php if(auth()->check() && auth()->user()->hasRole('doctor')): ?>
                                        <?php echo e(optional(auth()->user()->account)->prefix); ?>.
                                    <?php endif; ?>
                                    <?php echo e(ucwords(auth()->user()->firstname.' '.auth()->user()->lastname)); ?>

                                </h4>
                                <p class=" mb-0"><?php echo e(auth()->user()->email); ?></p>
                            </div>
                        </div>
                        <a class="dropdown-item" href="<?php echo e(route('profile')); ?>">
                            <i class="ti-user m-r-5 m-l-5"></i> My Profile
                        </a>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item" href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                            <i class="fa fa-power-off m-r-5 m-l-5"></i> Logout
                        </a>
                        <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                            <?php echo e(csrf_field()); ?>

                        </form>
                    </div>
                </li>
            </ul>
        </div>
    </nav>
</header><?php /**PATH /var/www/html/pplus_web/resources/views/dashboard/partials/nav.blade.php ENDPATH**/ ?>