<?php $__env->startSection('title','Members'); ?>
<?php $__env->startSection('styles'); ?>
    <style type="text/css">
        tbody tr td:nth-child(2), 
        tbody tr td:nth-child(3), 
        tbody tr td:nth-child(4), 
        tbody tr td:nth-child(5), 
        #memberQualifiedTable tbody tr td:nth-child(6){
            padding-top: 24px !important;
        }
        #memberTable tbody tr td:nth-child(6){
            padding-top: 20px !important;
        }
        .form-group{
            margin-bottom: .3rem;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Members</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="<?php echo e(route('dashboard')); ?>">Home</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Members</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
     
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-3 col-12">
                    <h4 class="page-title mt-2">
                        <i class="mdi mdi-account-multiple"></i>
                        List of Members
                    </h4>                
                </div>
                <div class="col-lg-9 col-12 text-right">
                    <?php if(auth()->check() && auth()->user()->hasRole('super_admin|admin')): ?>
                        <a href="<?php echo e(route('members.add')); ?>">
                            <button class="btn btn-success">
                                <i class="mdi mdi-account-plus"></i> Add Member
                            </button> 
                        </a>
                    <?php endif; ?>        
                </div>
                <div class="col-12 mt-1">
                    <div class="card">
                        <div class="card-body">
                            <ul class="nav nav-tabs" role="tablist">
                                <li class="nav-item"> 
                                    <a class="nav-link active" data-toggle="tab" href="#home" role="tab">
                                        <span class="hidden-sm-up">
                                            <i class="mdi mdi-account-multiple"></i>
                                        </span> 
                                        <span class="hidden-xs-down"> 
                                            Members
                                        </span>
                                    </a>
                                </li>
                                <li class="nav-item"> 
                                    <a class="nav-link" data-toggle="tab" href="#profile" role="tab">
                                        <span class="hidden-sm-up">
                                            <i class="mdi mdi-account-multiple"></i>
                                        </span> 
                                        <span class="hidden-xs-down"> 
                                            Qualified for PPLUS Membership Upgrade (<span id="qualified_count"></span>)
                                        </span>
                                    </a> 
                                </li>
                            </ul>
                            <!-- Tab panes -->
                            <div class="tab-content tabcontent-border">
                                <div class="tab-pane active" id="home" role="tabpanel">
                                    <form method="get" id="members">
                                        <div class="row mt-4">
                                            <div class="col-lg-3 col-12">
                                                <select class="form-control filter_by" name="type" id="filterBy">
                                                    <option value="" disabled selected>Select Member Category</option>
                                                    <option value="All">All</option>
                                                    <?php $__currentLoopData = $member_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($type->name); ?>">
                                                            <?php echo e($type->name); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                             <div class="col-lg-3 col-12">
                                                <select class="form-control filter_by" name="category" id="filterByType">
                                                    <option value="" disabled selected>Select Member Type</option>
                                                    <option value="Premium">Premium</option>
                                                    <option value="Regular">Regular</option>
                                                </select>
                                            </div>
                                            <div class="col-lg-3 col-12">
                                                <div class="input-group mb-3">
                                                    <input type="text" class="form-control" name="filter" placeholder="Search" aria-label="" aria-describedby="basic-addon1">
                                                    <div class="input-group-append">
                                                        <button class="btn btn-info" type="submit">
                                                            <i class="ti-search"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </form>
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="table-responsive mt-2">
                                                <table id="memberTable" class="table table-hover">
                                                    <thead>
                                                        <tr>
                                                            <th width="24%">Name</th>
                                                            <th>Card No.</th>
                                                            <th>Referral Code</th>
                                                            <th>Member Category</th>
                                                            <th>Member Type</th>
                                                            <th width="10%">Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                            
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane" id="profile" role="tabpanel">
                                    <form method="get" id="qualified_members">
                                        <div class="row mt-4">
                                            <div class="col-lg-3 col-12">
                                                <select class="form-control filter_by" name="type" id="filterByQualified">
                                                    <option value="" disabled selected>Select Member Type</option>
                                                    <option value="All">All</option>
                                                    <?php $__currentLoopData = $member_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($type->name); ?>">
                                                            <?php echo e($type->name); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                            <div class="col-lg-3 col-12">
                                                <div class="input-group mb-3">
                                                    <input type="text" class="form-control" name="filter" placeholder="Search" aria-label="" aria-describedby="basic-addon1">
                                                    <div class="input-group-append">
                                                        <button class="btn btn-info" type="submit">
                                                            <i class="ti-search"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="table-responsive mt-2">
                                                <table id="memberQualifiedTable" class="table table-hover">
                                                    <thead>
                                                        <tr>
                                                            <th>Name</th>
                                                            <th>Email</th>
                                                            <th>Current Points</th>
                                                            <th>Member Category</th>
                                                            <th>Member Type</th>
                                                            <th width="10%">Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                    
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal Add-->
        <div id="verifyMemberModal" class="modal" tabindex="-1" role="dialog" aria-labelledby="vcenter" aria-hidden="true" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <form method="POST" id="verify_form">
                        <?php echo csrf_field(); ?>
                        <div class="modal-header">
                            <h4 class="modal-title" id="vcenter">
                                Verify Member
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                        </div>
                        <div class="modal-body">
                            <div class="form-group">
                                <label class="control-label">OR number*</label>
                                <input type="hidden" name="user_id" id="user_id">
                                <input type="text" class="form-control" name="or_number" id="or_number" placeholder="Enter OR number" required>
                                <div class="invalid-feedback or_number"></div>
                            </div>
                            <div class="form-group">
                                <label class="control-label">Area Code*</label>
                                <select class="form-control select <?php $__errorArgs = ['area_code_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="area_code_id" id="area_code_id" required>
                                    <option value="" disabled selected> Select Area Code</option>
                                    <?php $__currentLoopData = $area_codes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($area->id); ?>" <?php echo e(old('area_code_id') == $area->id ? 'selected' : ''); ?> >
                                            <?php echo e($area->area_name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger waves-effect" data-dismiss="modal">Cancel</button>
                            <button type="submit" id="verify" class="btn btn-info waves-effect">
                                <i class="mdi mdi-check-circle"></i> Verify
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div id="referralLinkModal" class="modal" tabindex="-1" role="dialog" aria-labelledby="vcenter" aria-hidden="true"  data-keyboard="false">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-body pt-5 pr-4 pl-4">
                        <form id="send_referral">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-12 form-group">
                                    <h5 class="text-center" style="font-weight: 500;">
                                        Enter email to send referral code link :
                                    </h5>
                                    <div class="alert alert-info text-center p-2" id="referral_code" role="alert"></div>
                                    <input type="hidden" name="referral_code" class="referral_code">
                                    <input type="email" class="form-control text-center" name="email" id="referral-email" placeholder="Enter email" required>
                                    <div class="invalid-feedback email"></div>
                                </div>
                                <div class="col-12 form-group text-right mt-3">
                                    <button type="button" class="btn btn-secondary waves-effect" data-dismiss="modal">Cancel</button>
                                    <button type="submit" id="send" class="btn btn-info waves-effect">
                                        Send <i class="mdi mdi-send"></i> 
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        
        <!-- view member modal -->
        <?php echo $__env->make('dashboard.members.partials.view-member-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php echo $__env->make('dashboard.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
    </div>
    
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
   <script type="text/javascript">
        
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        initialize();
        initializeQualified();

        function initialize(formData){
            var url = "<?php echo e(route('members.list')); ?>";
            url = (formData != null) ? url + "?" + formData : url;
            $('#memberTable').DataTable({
                ajax: url,
                columns: [
                    { data : 'name' },
                    { data : 'card_number' },
                    { data : 'referral_code' },
                    { data : 'member_type' },
                    { data : 'status' },
                    { data : 'action', orderable: false, searchable: false}
                ],
                serverSide  : true,
                processing  : true,
                paging      : true,
                pagingType  : 'simple',
                lengthChange: true,
                searching   : true,
                ordering    : false,
                info        : true,
                autoWidth   : false,
                destroy     : true,
                deferRender : true,
                dom         : "<'row'<'col-12'tr>>" +
                            "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
            });
        }

       function initializeQualified(formData){
            var url = "<?php echo e(route('members.qualified.list')); ?>";
            url = (formData != null) ? url + "?" + formData : url;
            $('#memberQualifiedTable').DataTable({
                ajax: url,
                columns: [
                    { data : 'name' },
                    { data : 'email' },
                    { data : 'current_points' },
                    { data : 'member_type' },
                    { data : 'status' },
                    { data : 'action'},
                ],
                serverSide  : true,
                processing  : true,
                paging      : true,
                pagingType  : 'simple',
                lengthChange: true,
                searching   : true,
                ordering    : false,
                info        : true,
                autoWidth   : false,
                destroy     : true,
                deferRender : true,
                dom         : "<'row'<'col-12'tr>>" +
                            "<'row'<'col-lg-2 col-12'l><'col-lg-5 col-12'p><'col-lg-5 col-12 text-right pt-0'i>>",
                fnDrawCallback: function () {
                    self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                    $('#qualified_count').text(self.QtdOcorrenciasAgendadosHoje);
                }
            });
        }

        // Filter By Member Type 
        $('#filterBy').on('change', function(){

            var type = $(this).serialize();
            initialize(type);
        })

        // Form Get Submit
        $('form#members').submit( function(e){
            e.preventDefault();

            var formData = $(this).serialize();
            initialize(formData);
        });

         // Filter By Member Type 
        $('#filterByQualified').on('change', function(){

            var type = $(this).serialize();
            initializeQualified(type);
        })
        
        // Form Get Submit
        $('form#qualified_members').submit( function(e){
            e.preventDefault();

            var formData = $(this).serialize();
            initializeQualified(formData);
        });

        // view modal
        $('body').on('click', '#view', function(e){
            e.preventDefault();

            var url = $(this).attr('href');
            
            $.ajax({
                type: "GET",
                url: url,
                success: function (response) {
                    $('#image').attr('src',response.path);
                    $('#name').text(response.name);
                    $('#email').text(response.email);
                    $('#mobile_number').text(response.mobile_number);
                    $('#landline_number').text(response.landline_number);
                    $('#address').text(response.address);
                    $('#birthdate').text(response.birth_date);
                    $('#gender').text(response.gender);
                    $('#marital_status').text(response.marital_status);
                    $('#citizenship').text(response.citizenship);
                    $('#tin_number').text(response.tin_number);
                    $('#occupation').text(response.occupation);
                    $('#card_number').text(response.card_number);
                    $('#area_code').text(response.area_name);
                    $('#member_type').text(response.member_type);
                    $('#homeownership').text(response.homeownership);
                    $('#total_points').text(response.total_points);
                    $('#redeemed').text(response.redeemed);
                    $('#current_points').text(response.current_points);
                    $('#verification_date').text(response.verification_dateformat);
                    $('#expiration_date').text(response.expiration_dateformat);
                    $('#pending_points').text(response.pending_points);
                    $('#viewMemberModal').modal('show');
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });

        // view referral link modal
        $('body').on('click', '#referral-link', function(e){
            e.preventDefault();
            var url = $(this).attr('href');
            $('#referral-email').val('');
            $('#referral_code').text(url);
            $('.referral_code').val(url);
            $('#referralLinkModal').modal('show');
        });

        //send referral code link
        $('form#send_referral').submit( function(e){
            e.preventDefault();

            $('#send').attr('disabled',true);
            var formData = $(this).serialize();

            $.ajax({
                type: "POST",
                url: '<?php echo e(route('members.send.referral')); ?>',
                data: formData,
                success: function (response) {
                    $('#send').removeAttr('disabled',true);
                    $('#referralLinkModal').modal('hide');
                    swal({
                        title: "Success",
                        text: response.message,
                        type: "success",
                        showConfirmButton: false,
                        timer: 1500
                    });
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });


        function verifyModal(value) {
            select2();
            $('#user_id').val($(value).data('id'));
            $('#or_number').val('');
            $("#area_code_id").val('');
            $('#area_code_id').trigger('change');

            $('#or_number').removeClass('is-invalid');
            $('.or_number').removeClass('invalid-feedback');
            $('.or_number').text('');
            $('#verify').removeAttr('disabled',true);

            $('#verifyMemberModal').modal('show');
        }

        $('form#verify_form').submit( function(e){
            e.preventDefault();

            $('#verify').attr('disabled',true);
            var formData = $(this).serialize();

            $.ajax({
                type: "POST",
                url: '<?php echo e(route('members.verify')); ?>',
                data: formData,
                beforeSend: function(){
                   loadingAjaxPreloader();
                },
                success: function (response) {
                    if (response.error) {
                        successAjaxPreloader();
                        $('#or_number').addClass('is-invalid');
                        $('.or_number').addClass('invalid-feedback');
                        $('.or_number').text(response.error.or_number);
                        $('#verify').removeAttr('disabled',true);

                    } else {
                        $('#verify').removeAttr('disabled',true);
                        $('#verifyMemberModal').modal('hide');

                        initialize();
                        initializeQualified();
                        successAjaxPreloader();
                        swal({
                            title: "Success",
                            text: response.message,
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });                 
                    }
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });

        function select2() {
            $('select.select').select2({
                dropdownParent: $('#verifyMemberModal'),
                width: '100%',
            });
        }

        $('.filter_by').select2({
            width: '100%'
        }); 

   </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/pplus_web/resources/views/dashboard/members/index.blade.php ENDPATH**/ ?>