<?php $__env->startSection('title','Products'); ?>
<?php $__env->startSection('styles'); ?>
    <style type="text/css">
        table.dataTable.select tbody tr,
        table.dataTable thead th:first-child {
          cursor: pointer;
        }
        <?php if(!auth()->user()->isSuperAdmin()): ?>
            tbody tr td:nth-child(2), 
        <?php endif; ?>
        tbody tr td:nth-child(3), 
        tbody tr td:nth-child(4), 
        tbody tr td:nth-child(5), 
        tbody tr td:nth-child(6),
        tbody tr td:nth-child(7),
        tbody tr td:nth-child(8){
            padding-top: 24px !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Products</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="<?php echo e(route('dashboard')); ?>">Home</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Products</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-6 col-12">
                    <h4 class="page-title mt-2">
                        <i class="mdi mdi-dropbox"></i>
                        List of Products (<span class="product-count">0</span>)
                    </h4>                
                </div>
                <div class="col-lg-6 col-12 text-right">
                    <?php if(auth()->check() && auth()->user()->hasRole('merchant_admin')): ?>
                        <button class="btn btn-success" onclick="addProduct()">
                            <i class="fa fa-plus"></i> Add Product
                        </button>
                    <?php endif; ?>   
                </div>
                
                <div class="col-12 mt-1">
                    <div class="card">
                        <div class="card-body">
                            <form method="POST" id="form-product">
                                <?php echo csrf_field(); ?>
                                <div class="table-responsive">
                                    <table id="productTable" class="table table-hover">
                                        <thead>
                                            <tr>
                                                <?php if(auth()->check() && auth()->user()->hasRole('super_admin|admin|accounting')): ?>
                                                    <th><input name="select_all" value="1" type="checkbox"></th>
                                                <?php endif; ?>
                                                <th>Product Name</th>
                                                <th>Price</th>
                                                <th>Category</th>
                                                <th>Description</th>
                                                <th>Status</th>
                                                <th>Date/Time</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                           
                                        </tbody>
                                    </table>
                                </div>
                                <div class="text-right mt-4" id="show-button"></div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- modal -->
        <div id="addProductModal" class="modal" tabindex="-1" role="dialog" aria-labelledby="vcenter" aria-hidden="true" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <form id="add-establishment" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="modal-header">
                            <h4 class="modal-title" id="vcenter">
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                        </div>
                        <div class="modal-body">
                            <div class="row pr-1 pl-1">
                                <div class="col-12 form-group">
                                    <label class="control-label">Image*</label>
                                    <input type="file" class="form-control" name="image" id="image" required>
                                </div>
                                <div class="col-12 form-group">
                                    <label class="control-label">Item name*</label>
                                    <input type="text" class="form-control" name="name" id="name" placeholder="Enter item name" required>
                                    <input type="hidden" name="product_id" id="product_id">
                                    <div class="invalid-feedback name"></div>
                                </div>
                                <div class="col-12 form-group">
                                    <label class="control-label">Price*</label>
                                    <input type="text" class="form-control number" name="price" id="price" placeholder="Enter price" required>
                                </div>
                                <div class="col-12 form-group">
                                    <label class="control-label">Description*</label>
                                    <input type="text" class="form-control" name="description" id="description" placeholder="Enter description" required>
                                </div>
                                <div class="col-12 form-group">
                                    <label class="control-label">Product Category*</label>
                                    <select class="form-control select" name="product_category_id" id="product_category_id" required>
                                        <option value="" selected disabled>Select Product Category</option>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-12 form-group">
                                    <label class="control-label">Establishments*</label>
                                    <select class="form-control select" name="establishment_id" id="establishment_id" required>
                                        <option value="" selected disabled>Select Establishment</option>
                                        <?php $__currentLoopData = $establishments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $establishment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($establishment->id); ?>"><?php echo e($establishment->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger waves-effect" data-dismiss="modal">Cancel</button>
                            <button type="submit" id="save" class="btn btn-info waves-effect">
                                <i class="fa fa-save"></i> Save
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <?php echo $__env->make('dashboard.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
    </div>
    
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
   <script type="text/javascript">
        
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        var rows_selected = [];
        var table = $('#productTable').DataTable({
            ajax: "<?php echo e(route('merchants.products.list')); ?>",
            columns: [
                <?php if(auth()->check() && auth()->user()->hasRole('super_admin|admin|accounting')): ?>
                    { data : 'checkbox' },
                <?php endif; ?>
                { data : 'name' },
                { data : 'price' },
                { data : 'category_name' },
                { data : 'description' },
                { data : 'status' },
                { data : 'created_at' },
            ],
            paging      : true,
            lengthChange: true,
            searching   : true,
            ordering    : false,
            info        : true,
            autoWidth   : false,
            dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                        "<'row'<'col-12'tr>>" +
                        "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
            fnDrawCallback: function () {
                self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                $('.product-count').text(self.QtdOcorrenciasAgendadosHoje);
            }
        });

        // Modal Add
        function addProduct() {
            $('#addProductModal').modal('show');
            $('#save').removeAttr('disabled',true);
            $('#image').attr('required',true);
            $('#name').removeClass('is-invalid');
            $('.name').removeClass('invalid-feedback');
            $('.name').text('');

            const token = $('input[name="_token"]').val();
            $('#addProductModal :input').val('');
            $('#addProductModal select').select2('');
            $('input[name="_token"]').val(token);

            select2();
            var content = "<i class='mdi mdi-plus'></i> Add Product";
            $('#vcenter').html(content);
        }

        // Form Add & Update Product
        $('form').submit( function(e){
            e.preventDefault();

            $('#save').attr('disabled',true);

            const product_id = $('#product_id').val();

            var url = product_id == '' ? '<?php echo e(route('merchants.products')); ?>' : 
                                    '<?php echo e(route('settings.merchant.establishments.update')); ?>';

            let form = new FormData(this);

            $.ajax({
                url: url,
                type: 'POST',
                data: form,
                cache: false,
                contentType: false,
                processData: false,
                beforeSend: function(){
                   loadingAjaxPreloader();
                },
                success: function (response) {

                    if (response.message == 'success') {
                        
                        $('#save').removeAttr('disabled',true);
                        $('#addProductModal').modal('hide');
                        $('#name').removeClass('is-invalid');
                        $('.name').removeClass('invalid-feedback');
                        $('.name').text('');

                        successAjaxPreloader();
                        table.ajax.reload();
                        swal({
                            title: "Success",
                            text: 'Product successfully saved!',
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });
                        
                    } else {
                        successAjaxPreloader();
                        $('#save').removeAttr('disabled',true);
                        $('#name').addClass('is-invalid');
                        $('.name').addClass('invalid-feedback');
                        $('.name').text(response.message.name);
                    }
                },
                error: function(error){
                  console.log(error);
                },
            });
        });

        <?php if(auth()->check() && auth()->user()->hasRole('super_admin|admin|accounting')): ?>
            function updateDataTableSelectAllCtrl(table){
                var $table             = table.table().node();
                var $chkbox_all        = $('tbody input[type="checkbox"]', $table);
                var $chkbox_checked    = $('tbody input[type="checkbox"]:checked', $table);
                var chkbox_select_all  = $('thead input[name="select_all"]', $table).get(0);

                // If none of the checkboxes are checked
                if($chkbox_checked.length === 0){
                    showButton('not-selected');
                    chkbox_select_all.checked = false;
                    if('indeterminate' in chkbox_select_all){
                        chkbox_select_all.indeterminate = false;
                    }

                // If all of the checkboxes are checked
                } else if ($chkbox_checked.length === $chkbox_all.length){
                    chkbox_select_all.checked = true;
                    if('indeterminate' in chkbox_select_all){

                        chkbox_select_all.indeterminate = false;
                    }

                // If some of the checkboxes are checked
                } else {
                    chkbox_select_all.checked = true;
                    if('indeterminate' in chkbox_select_all){
                        chkbox_select_all.indeterminate = true;
                    }
                }
            }
            // Handle click on checkbox
            $('#productTable tbody').on('click', 'input[type="checkbox"]', function(e){
                var $row = $(this).closest('tr');

                // Get row data
                var data = table.row($row).data();

                // Get row ID
                var rowId = data[0];

                // Determine whether row ID is in the list of selected row IDs
                var index = $.inArray(rowId, rows_selected);

                // If checkbox is checked and row ID is not in list of selected row IDs
                if(this.checked && index === -1){
                    rows_selected.push(rowId);

                // Otherwise, if checkbox is not checked and row ID is in list of selected row IDs
                } else if (!this.checked && index !== -1){
                    rows_selected.splice(index, 1);
                }

                if(this.checked){
                    $row.addClass('selected');
                    $row.css('background-color','#8dc83d');
                    $row.css('color','#fff');
                    showButton('selected');
                } else {
                    $row.removeClass('selected');
                    $row.removeAttr('style');
                }

                // Update state of "Select all" control
                updateDataTableSelectAllCtrl(table);

                // Prevent click event from propagating to parent
                e.stopPropagation();
            });

           // Handle click on table cells with checkboxes
            $('#productTable').on('click', 'tbody td, thead th:first-child', function(e){
                $(this).parent().find('input[type="checkbox"]').trigger('click');
            });

           // Handle click on "Select all" control
            $('thead input[name="select_all"]', table.table().container()).on('click', function(e){
                if(this.checked){
                    $('#productTable tbody input[type="checkbox"]:not(:checked)').trigger('click');
                } else {
                    $('#productTable tbody input[type="checkbox"]:checked').trigger('click');
                }
                // Prevent click event from propagating to parent
                e.stopPropagation();
            });

            // Handle table draw event
            table.on('draw', function(){

                // Update state of "Select all" control
                updateDataTableSelectAllCtrl(table);
            });

           // Handle rejected promos and offers
            $('body').on('click', '#reject',function(e){
                e.preventDefault();

                swal({
                    title: "Are you sure?",
                    text: "Once you Reject, it will reject product!",
                    type: "warning",
                    confirmButtonClass: 'btn-danger',
                    showCancelButton: true,
                    showLoaderOnConfirm: true,
                    confirmButtonText: 'Reject',
                    closeOnConfirm: false,
                },
                ()=>{
                    var code = "<?php echo e(base64_encode(-1)); ?>";
                    submit(code);

                    swal({
                        title: "Success",
                        text: 'Product rejected successfully',
                        type: "success",
                        showConfirmButton: false,
                        timer: 1500
                    });
                });
            });

            // Handle approved promos and offers
           $('body').on('click', '#approved', function(e){
                e.preventDefault();
                
                swal({
                    title: "Are you sure?",
                    text: "Once you Approved, it will approved products!",
                    type: "warning",
                    confirmButtonClass: 'btn-info',
                    showCancelButton: true,
                    showLoaderOnConfirm: true,
                    confirmButtonText: 'Approved',
                    closeOnConfirm: false,
                },
                ()=>{
                    var code = "<?php echo e(base64_encode(1)); ?>";
                    submit(code);

                    swal({
                        title: "Success",
                        text: 'Product approved successfully',
                        type: "success",
                        showConfirmButton: false,
                        timer: 1500
                    });
                });
            });

            // update promo and offer status
            function submit(code) {
                var formData = $('#form-product').serialize();
                formData+='&code='+code;
                $.ajax({
                    type: "POST",
                    url: '<?php echo e(route("merchants.products.update")); ?>',
                    data: formData,
                    success: function (response) {
                        table.ajax.reload();
                        $('#productTable tbody input[type="checkbox"]:checked').trigger('click');
                    },
                    error: function (response) {
                        console.log('Error:', response);
                    }
                });
            }

            // show button if checked/selected
            function showButton(value) {
                var content = '';
                if (value == 'selected') {
                    content+='<button class="btn btn-danger mr-1" id="reject" type="submit">';
                        content+='<i class="mdi mdi-close-circle"></i> Reject';
                    content+='</button>';
                    content+='<button class="btn btn-info" id="approved" type="submit">';
                        content+='<i class="mdi mdi-checkbox-multiple-marked-circle"></i> Approve';
                    content+='</button>';
                }
                $('#show-button').html(content);
            }
        <?php endif; ?>

        function select2() {
            $('select.select').select2({
                dropdownParent: $('#addProductModal'),
                width: '100%',
            });
        }
   </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/pplus_web/resources/views/dashboard/merchants/products/index.blade.php ENDPATH**/ ?>