<?php $__env->startSection('title','Merchants Transaction Report'); ?>
<?php $__env->startSection('styles'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('admin_dashboard/assets/libs/daterangepicker/daterangepicker.css')); ?>">
    <style type="text/css">
        #merchantTransactionTable tbody tr td:nth-child(1), 
        #merchantTransactionTable tbody tr td:nth-child(4), 
        #merchantTransactionTable tbody tr td:nth-child(5), 
        #merchantTransactionTable tbody tr td:nth-child(6), 
        #merchantTransactionTable tbody tr td:nth-child(7){
            padding-top: 24px !important;
        }
        #merchantTransactionTable tbody tr td:nth-child(8){
            padding-top: 20px !important;
        }
        h6.text-uppercase{
            font-weight: 500
        }
        h4.font-light{
            font-weight: 500 !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Merchants Transaction Report</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="<?php echo e(route('dashboard')); ?>">Home</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Merchants Transaction Report</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-4 col-12">
                    <div class="card">
                        <div class="card-body shadow">
                            <div class="row">
                                <div class="col p-r-0 mt-2">
                                    <h6 class="text-muted text-uppercase">Merchant Transactions</h6>
                                    <h4 class="font-light" id="totalTransactions">0</h4>
                                    <h6 class="text-muted">Total</h6>
                                </div>
                                <div class="col-5 text-right align-self-center">
                                    <div class="round align-self-center round-success">
                                        <i class="mdi mdi-cart mdi-24px"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-12">
                    <div class="card">
                        <div class="card-body shadow">
                            <div class="row">
                                <div class="col p-r-0 mt-2">
                                    <h6 class="text-muted text-uppercase">Total Rebate Amount</h6>
                                    <h4 class="font-light" id="totalRebates">0</h4>
                                    <h6 class="text-muted">Total</h6>
                                </div>
                                <div class="col-5 text-right align-self-center">
                                    <div class="round align-self-center round-success">
                                        <i class="mdi mdi-cart mdi-24px"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-10 col-12">
                    <h4 class="page-title mt-2">
                        <i class="mdi mdi-cart"></i>
                        List of Merchants Transaction Report (<span id="count">0</span>)
                    </h4>                
                </div>
                
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <?php if(auth()->check() && auth()->user()->hasRole('super_admin|accounting|admin')): ?>
                                    <div class="col-12">
                                        <form method="get">
                                            <div class="row">
                                                <div class="col-lg-3 col-12 form-group">
                                                    <h6 class="text-uppercase">Date Range :</h6>
                                                    <input type="text" name="date" class="form-control" id="daterangepicker">
                                                </div>
                                                <div class="col-lg-3 col-12 form-group">
                                                    <h6 class="text-uppercase">Merchants :</h6>
                                                    <select class="form-control" name="merchant_id" id="merchant_id">
                                                    </select>
                                                </div>
                                                <div class="col-lg-4 col-12 form-group">
                                                    <button class="btn btn-info mt-4 mr-1" type="submit">
                                                        <i class="mdi mdi-filter"></i> Filter
                                                    </button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                <?php endif; ?>
                                <div class="col-12 <?php if(auth()->check() && auth()->user()->hasRole('super_admin|accounting')): ?> mt-4 <?php endif; ?>">
                                    <div class="table-responsive">
                                        <table id="merchantTransactionTable" class="table table-hover">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>Merchant</th>
                                                    <th>Member</th>
                                                    <th>Reference</th>
                                                    <th>Cashier ID</th>
                                                    <th>Amount</th>
                                                    <th>Rebate</th>
                                                    <th>Members Points</th>
                                                    <th>Date</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- view transaction modal -->
        <div id="viewTrasactionModal" class="modal" tabindex="-1" role="dialog" aria-labelledby="vcenter" aria-hidden="true" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div>
                        <button type="button" class="close pt-3 pr-3 pb-0 pl-3" data-dismiss="modal" aria-hidden="true">×</button>
                    </div>

                    <div class="modal-body">
                        <div class="row pb-4">
                            <div class="col-12">
                                <div id="carouselExampleControls" class="carousel slide" data-ride="carousel">
                                    <div class="carousel-inner">
                                        <div class="carousel-div"></div>
                                    </div>
                                    <a class="carousel-control-prev" href="#carouselExampleControls" role="button" data-slide="prev">
                                        <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                        <span class="sr-only">Previous</span>
                                    </a>
                                    <a class="carousel-control-next" href="#carouselExampleControls" role="button" data-slide="next">
                                        <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                        <span class="sr-only">Next</span>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php echo $__env->make('dashboard.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
    </div>
    
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <!-- start - This is for export functionality only -->
    <script src="https://cdn.datatables.net/buttons/1.5.1/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.5.1/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.5.1/js/buttons.print.min.js"></script>
    
    <script src="<?php echo e(asset('admin_dashboard/assets/libs/moment/moment.js')); ?>"></script>
    <script src="<?php echo e(asset('admin_dashboard/assets/libs/daterangepicker/daterangepicker.js')); ?>"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/plug-ins/1.10.21/api/sum().js"></script>
    <script type="text/javascript">
        $(document).ready( function(){
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            initialize();

            function initialize(formData){
                var url = "<?php echo e(route('reports.merchants.transactions.list')); ?>";
                url = (formData != null) ? url + "?" + formData : url;
                $('#merchantTransactionTable').DataTable({
                    ajax: url,
                    columns: [
                        { data : 'DT_RowIndex' },
                        { data : 'merchant_name' },
                        { data : 'member_name' },
                        { data : 'reference' },
                        { data : 'cashier' },
                        { data : 'amount' },
                        { data : 'rebate' },
                        { data : 'points' },
                        { data : 'created_at' },
                        { data : 'action', orderable: false, searchable: false}
                    ],
                    paging      : true,
                    lengthChange: true,
                    searching   : true,
                    ordering    : false,
                    info        : true,
                    autoWidth   : false,
                    destroy     : true,
                    buttons     : [
                        {
                            extend: 'csv',
                            exportOptions: {
                                columns: [ 0, 1, 2, 3, 4, 5, 6]
                            }
                        },
                        {
                            extend: 'excel',
                            exportOptions: {
                                columns: [ 0, 1, 2, 3, 4, 5, 6]
                            }
                        },
                        {
                            extend: 'print',
                            exportOptions: {
                                columns: [ 0, 1, 2, 3, 4, 5, 6]
                            }
                        },
                    ],
                    dom         : "<'row'<'col-lg-6 col-12' <?php if(auth()->check() && auth()->user()->hasRole('super_admin|accounting|merchant_admin')): ?> B <?php endif; ?>><'col-lg-6 col-12'f>>" +
                            "<'row'<'col-12'tr>>" +
                            "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
                    fnDrawCallback: function () {
                        self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                        $('#count').text(self.QtdOcorrenciasAgendadosHoje);

                        var amount = this.api().column(5).data().sum();
                        $('#totalTransactions').text(numberFormat(amount));

                        var totrebates = this.api().column(6).data().sum();
                        $('#totalRebates').text(numberFormat(totrebates));

                        if (self.QtdOcorrenciasAgendadosHoje < 1)  {
                            $('.dt-buttons').addClass('d-none');
                        } else {
                            $('.dt-buttons').removeClass('d-none');
                        }
                    }
                });

                $('.buttons-csv, .buttons-print, .buttons-excel').addClass('btn btn-success mr-1');
            }

            // Form Get Submit
            $('form').submit( function(e){
                e.preventDefault();
                var formData = $(this).serialize();

                initialize(formData);
            });

            // Custom Date Range
            var date = $('#daterangepicker').daterangepicker({
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                },
                alwaysShowCalendars: true,
                drops: "down",
                buttonClasses: "btn",
                applyClass: "btn-info",
                cancelClass: "btn-danger",
            });

            getAllMerchants();

            // get All Merchants
            function getAllMerchants() {
                $.ajax({
                    type: "GET",
                    url: "<?php echo e(route('administration.merchants')); ?>",
                    success: function (response) {
                        $('#merchant_id').append('<option value="all">Select Merchant</option>');
                        for (i = 0; i < response.length; i++) {
                            $('#merchant_id').append('<option value='+response[i].id+' "<?php echo e(old("merchant_id") == 'response[i].id' ? "selected" : ''); ?>">'+response[i].name.toUpperCase()+'</option>');
                        }
                    },
                    error: function (response) {
                        console.log('Error:', response);
                    }
                });
            }

            // amount number format
            function numberFormat(num) {
              return '₱ '+num.toFixed(2).replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1,')
            }

            $('#merchant_id').select2({
                width  : '100%',
            });
        });

        // view transaction modal
        $('body').on('click', '#view', function(e){
            e.preventDefault();

            var url = $(this).attr('href');
            
            $.ajax({
                type: "GET",
                url: url,
                success: function (response) {
                    $('.carousel-div').empty();
                    if (response.length > 0) {
                        for (var i = 0; i < response.length; i++) {
                            if (response[i].id == 0) {
                                $('.carousel-div').append('<div class="carousel-item active"><img src='+response[i].path+' class="d-block w-100" alt="..."></div>');
                            } else {
                                $('.carousel-div').append('<div class="carousel-item"><img src='+response[i].path+' class="d-block w-100" alt="..."></div>');
                            }
                        }
                    } else {
                        $('.carousel-div').append('<div class="carousel-item active"><img src="<?php echo e(asset("admin_dashboard/img/no-image.png")); ?>" class="d-block w-100" alt="..."></div>');
                    }
                    $('#viewTrasactionModal').modal('show');
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });

    </script> 
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/pplus_web/resources/views/dashboard/reports/merchants-transaction/index.blade.php ENDPATH**/ ?>