<?php $__env->startSection('title','Transactions'); ?>
<?php $__env->startSection('styles'); ?>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('admin_dashboard/assets/libs/daterangepicker/daterangepicker.css')); ?>">
    <style type="text/css">
        tbody tr td:nth-child(2), 
        tbody tr td:nth-child(3), 
        tbody tr td:nth-child(4), 
        tbody tr td:nth-child(5), 
        #memberQualifiedTable tbody tr td:nth-child(6){
            padding-top: 24px !important;
        }
        #memberTable tbody tr td:nth-child(6){
            padding-top: 20px !important;
        }
        .form-group{
            margin-bottom: .3rem;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Transaction History</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="<?php echo e(route('members')); ?>">Members</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Transaction History</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
      
        <div class="container-fluid">
            <div class="row">
                  <div class="col-lg-3 col-12">
                    <h4 class="page-title mt-2">
                        <i class="mdi mdi-clipboard"></i>
                        Member Details
                    </h4>                
                </div>
                <div class="col-12 mt-1">
                    <div class="card">
                        <div class="card-body">
                           
                            <table id="" class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Card No.</th>
                                        <th>Member Category</th>
                                        <th>Lifetime Earnings</th>
                                        <th>Redeemable Points</th>
                                        <th>Pending Points</th>              
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><?php echo e($user_data->firstname); ?> <?php echo e($user_data->lastname); ?> </td>
                                        <td><?php echo e($member_data->card_number); ?> </td>
                                        <td><?php echo e($member_data->registration_status); ?> </td>
                                        <td><?php echo e($member_data->total_points); ?>  </td>
                                        <td><?php echo e($member_data->current_points); ?>  </td>
                                        <td><?php echo e($pending_points); ?>  </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>
                <div class="col-lg-3 col-12">
                    <h4 class="page-title mt-2">
                        <i class="mdi mdi-clipboard-check"></i>
                        Transactions 
                    </h4>                
                </div>
                   
              
                
                <div class="col-12 mt-4">
                    <div class="card">

                        <div class="card-body">

                        <div class="col-12">
                            <form method="get">
                                <div class="row">
                                    <div class="col-lg-3 col-12">
                                        <h6 class="text-uppercase">Select Date Range :</h6>
                                        <input type="text" name="date" class="form-control" id="daterangepicker">
                                    </div>
                                    <div class="col-lg-4 col-12">
                                        <button class="btn btn-info mt-4 mr-1" type="submit">
                                        <i class="mdi mdi-filter"></i> Filter
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-12 mt-4">
                            <div class="table-responsive mt-1">
                                                <table id="memberTransactionTable" class="table table-hover">
                                                    <thead>
                                                        <tr>
                                                            <th>Reference ID</th>
                                                            <th>Date</th>
                                                            <th>Description</th>
                                                            <th>Member</th>
                                                            <th>Amount/Points</th>
                                                            <th>Status</th>
                                                            
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                    </tbody>
                                                </table>
                            </div> 
                        </div>
                            <!-- Tab panes -->
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal Add-->
       

        

        

        

        <?php echo $__env->make('dashboard.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
    </div>
    
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>

<script src="https://cdn.datatables.net/buttons/2.0.1/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.html5.min.js"></script>
<script src="<?php echo e(asset('admin_dashboard/assets/libs/moment/moment.js')); ?>"></script>
<script src="<?php echo e(asset('admin_dashboard/assets/libs/daterangepicker/daterangepicker.js')); ?>"></script>
<script type="text/javascript">
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });


        initialize();
        function initialize(formData){
            var id  = "<?php echo $user_id ?>";
            var url = "<?php echo e(route('members.transactionlist')); ?>";
            url = (formData != null) ? url + "?user_id="+id+"&&" + formData : url+ "?user_id="+id;
            $('#memberTransactionTable').DataTable({
                "order": [[ 1, "desc" ]],
                ajax: url,
                columns: [
                    { data : 'reference_id' },
                    { data : 'date' },
                    { data : 'address' },
                    { data : 'member' },
                    { data : 'delivery_amount' },
                    { data : 'status' },
                ],
                serverSide  : true,
                processing  : true,
                paging      : true,
                pagingType  : 'simple',
                lengthChange: true,
                searching   : true,
                info        : true,
                autoWidth   : false,
                destroy     : true,
                deferRender : true,
                 dom: 'Bfrtip',
                buttons: ['csv']
            });
            
            $('.buttons-csv').addClass('btn btn-success mr-1');
        }


      

        // Custom Date Range
            var date = $('#daterangepicker').daterangepicker({
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                },
                alwaysShowCalendars: true,
                drops: "down",
                buttonClasses: "btn",
                applyClass: "btn-info",
                cancelClass: "btn-danger",
            });

            $('form').submit( function(e){
                e.preventDefault();
                var formData = $(this).serialize();

                initialize(formData);
  
            });

   </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/pplus_web/resources/views/dashboard/members/transactions.blade.php ENDPATH**/ ?>