<?php $__env->startSection('title','Edit Merchant'); ?>

<?php $__env->startSection('content'); ?>

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Edit Merchant</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="<?php echo e(route('dashboard')); ?>">Home</a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="<?php echo e(route('merchants')); ?>">Merchants</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Edit Merchant</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <form method="POST" action="<?php echo e(route('merchants.update', base64_encode($merchant->id))); ?>" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                   <div class="col-lg-3 col-12">
                                        <label>PHOTO</label>
                                        <input type="file" id="input-file-now-custom-2" name="image" value="<?php echo e(old('image')); ?>" data-default-file="<?php echo e($merchant->path); ?>" class="dropify" data-height="300" data-allowed-file-extensions="jpeg png jpg"/>
                                        <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <p class="mt-2 text-center">Image must be square and at least 500x500 pixels</p>
                                    </div>
                                    <div class="col-lg-9 col-12">
                                        <h4 class="card-title mb-4">Personal Information</h4>
                                        <div class="row">
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Merchant Name*</label>
                                                <input type="text" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="name" value="<?php echo e(old('name', $merchant->name)); ?>" placeholder="Enter merchant name" required>
                                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Industry Type*</label>
                                                <select class="form-control <?php $__errorArgs = ['merchant_type_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="merchant_type_id" required>
                                                    <option value="" disabled selected> Select Merchant Type</option>
                                                    <?php $__currentLoopData = $merchant_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($type->id); ?>" <?php echo e(old('merchant_type_id', $merchant->merchant_type_id) == $type->id ? 'selected' : ''); ?> >
                                                            <?php echo e($type->name); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <?php $__errorArgs = ['merchant_type_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Website*</label>
                                                <input type="text" class="form-control <?php $__errorArgs = ['website'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="website" value="<?php echo e(old('website', $merchant->website)); ?>" placeholder="Enter website" required>
                                                <?php $__errorArgs = ['website'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Email Address*</label>
                                                <input type="text" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="email" value="<?php echo e(old('email', $merchant->email)); ?>" placeholder="Enter email address" required>
                                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Contact Person*</label>
                                                <input type="text" class="form-control <?php $__errorArgs = ['contact_person'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="contact_person" value="<?php echo e(old('contact_person', $merchant->contact_person)); ?>" placeholder="Enter contact person" required>
                                                <?php $__errorArgs = ['contact_person'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Contact No.*</label>
                                                <input type="text" class="form-control <?php $__errorArgs = ['contact_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="contact_number" value="<?php echo e(old('contact_number', $merchant->contact_number)); ?>" placeholder="Enter contact number" maxlength="13" required>
                                                <?php $__errorArgs = ['contact_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Address*</label>
                                                <textarea class="form-control <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" rows="4" name="address" id="address" placeholder="Enter address" required><?php echo e(old('address', $merchant->address)); ?></textarea>
                                                <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Area code*</label>
                                                <select class="form-control <?php $__errorArgs = ['merchant_area_code_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="merchant_area_code_id" required>
                                                    <option value="" disabled selected> Select Area Code</option>
                                                    <?php $__currentLoopData = $area_codes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($area->id); ?>" <?php echo e(old('merchant_area_code_id', $merchant->merchant_area_code_id) == $area->id ? 'selected' : ''); ?> >
                                                            <?php echo e($area->area_name); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <?php $__errorArgs = ['merchant_area_code_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Date of Start*</label>
                                                <input type="text" class="form-control <?php $__errorArgs = ['date_start'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="date_start" id="date_start" value="<?php echo e(old('date_start', $merchant->date_start->format('m/d/Y') )); ?>" required>
                                                <?php $__errorArgs = ['date_start'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>End of Contract*</label>
                                                 <input type="text" class="form-control <?php $__errorArgs = ['date_end'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="date_end" id="date_end" value="<?php echo e(old('date_end', $merchant->date_end->format('m/d/Y') )); ?>" required>
                                                <?php $__errorArgs = ['date_end'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="col-12 form-group">
                                                <div class="custom-control custom-checkbox">
                                                    <input type="checkbox" class="custom-control-input" name="is_mobile" id="is_mobile" value="1" autocomplete="off" <?php echo e(old('is_mobile', $merchant->is_mobile) == '1' ? 'checked' : ''); ?>>
                                                    <label class="custom-control-label" for="is_mobile">Mobile App</label>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="row d-none" id="agreement">
                                            <div class="col-12">
                                                <h4 class="card-title mb-4 mt-2">Account & Agreement</h4>
                                            </div>
                                            <?php if($establishments->count() < 1): ?>
                                                <div class="col-12">
                                                    <div class="alert alert-warning alert-dismissible fade show text-white" role="alert" style="background-color: #f9c23f;">
                                                        No Establishment Yet. Go to this link to 
                                                        <a href="<?php echo e(route('merchants.establishments', base64_encode($merchant->id))); ?>">
                                                            <u>Add Establishment</u>
                                                        </a>
                                                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Establishment*</label>
                                                <select class="form-control <?php $__errorArgs = ['establishment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="establishment_id" id="establishment_id" required>
                                                    <option value="" disabled selected> Select Establishment</option>
                                                    <?php $__currentLoopData = $establishments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $establishment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($establishment->id); ?>" data-image="<?php echo e(isset($establishment->path) ? config('app.AWS_BUCKET_URL').$establishment->path : ''); ?>" <?php echo e(old('establishment_id', $merchant->establishment_id) == $establishment->id ? 'selected' : ''); ?> >
                                                            <?php echo e(ucwords($establishment->name)); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <?php $__errorArgs = ['establishment_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Payment Method*</label>
                                                <select class="form-control multiple" name="payment_method[]" id="payment_method" multiple="multiple" required>
                                                    <?php if(is_array(old('payment_method'))): ?>
                                                        <option value="cash" <?php echo e(in_array('cash', old('payment_method')) ? 'selected' : ''); ?>>Cash</option>
                                                        <option value="hmo" <?php echo e(in_array('hmo', old('payment_method')) ? 'selected' : ''); ?>>HMO</option>
                                                        <option value="points" <?php echo e(in_array('points', old('payment_method')) ? 'selected' : ''); ?>>POINTS</option>
                                                        <option value="bank-to-bank" <?php echo e(in_array('bank-to-bank', old('payment_method')) ? 'selected' : ''); ?>>BANK-TO-BANK</option>
                                                    <?php else: ?>
                                                        <option value="cash" <?php echo e(in_array('cash', $merchant->payment_methods) ? 'selected' : ''); ?>>Cash</option>
                                                        <option value="hmo" <?php echo e(in_array('hmo', $merchant->payment_methods) ? 'selected' : ''); ?>>HMO</option>
                                                        <option value="points" <?php echo e(in_array('points', $merchant->payment_methods) ? 'selected' : ''); ?>>POINTS</option>
                                                        <option value="bank-to-bank" <?php echo e(in_array('bank-to-bank', $merchant->payment_methods) ? 'selected' : ''); ?>>BANK-TO-BANK</option>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Application*</label>
                                                <select class="form-control" name="application_type" required>
                                                    <option value="" disabled selected> Select Application</option>
                                                    <option value="getta" <?php echo e(old('application_type', $merchant->application_type) == 'getta' ? 'selected' : ''); ?>>Getta</option>
                                                    <option value="kol-a" <?php echo e(old('application_type', $merchant->application_type) == 'kol-a' ? 'selected' : ''); ?>>Kol-A</option>
                                                </select>
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Account Type*</label>
                                                <select class="form-control" name="account_type" required>
                                                    <option value="" disabled selected> Select Account Type</option>
                                                    <option value="group" <?php echo e(old('account_type',$merchant->account_type) == 'group' ? 'selected' : ''); ?>>Group</option>
                                                    <option value="individual" <?php echo e(old('account_type',$merchant->account_type) == 'individual' ? 'selected' : ''); ?>>Individual</option>
                                                </select>
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Service Fee(%)*</label>
                                                <select class="form-control" name="service_fee" required>
                                                    <?php for($i = 0; $i < 101; $i++): ?>
                                                        <option value="<?php echo e($i); ?>" <?php echo e(old('service_fee',$merchant->service_fee) == $i ? 'selected' : ''); ?>><?php echo e($i.'%'); ?>

                                                        </option>
                                                    <?php endfor; ?>
                                                </select>
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Other Fee(%)*</label>
                                                <select class="form-control" name="other_fee" required>
                                                    <?php for($i = 0; $i < 101; $i++): ?>
                                                        <option value="<?php echo e($i); ?>" <?php echo e(old('other_fee',$merchant->other_fee) == $i ? 'selected' : ''); ?>><?php echo e($i.'%'); ?>

                                                        </option>
                                                    <?php endfor; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-lg-12 col-12 form-group text-right">
                                                <a href="<?php echo e(route('merchants')); ?>">
                                                    <button type="button" class="btn btn-danger">
                                                        <i class="mdi mdi-close-circle"></i> Cancel
                                                    </button>
                                                </a>
                                                <button type="submit" class="btn btn-info">
                                                    <i class="fa fa-save"></i> Update
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php echo $__env->make('dashboard.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
    </div>
    
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
   <script type="text/javascript">

       // All select option
        $('select').select2({
            width : '100%'
        });

        $('#establishment_id').select2({
            templateResult: formatState,
            templateSelection: formatState,
            width : '100%'
        });

        function formatState(opt) {
            if (!opt.id) {
                return opt.text;
            } 
            var optimage = $(opt.element).attr('data-image'); 
            if(!optimage){
               return opt.text;
            } else {                    
                return $('<span><img src="' + optimage + '" class="rounded-circle mr-1" width="30px" height="30px" /> ' + opt.text + '</span>');
            }
        };

         // Date start
        $('#date_start').datepicker({
            autoclose: true,
            todayHighlight: true
        });

        // Date end Set + 1year
        $('#date_end').datepicker({
            autoclose: true,
            todayHighlight: true
        });

        function initialize() {
            var complete_address = document.getElementById('address');
            var autocomplete = new google.maps.places.Autocomplete(complete_address);
        }
        google.maps.event.addDomListener(window, 'load', initialize); 

        isMobileAppChecked();

        $('#is_mobile').click( function(){
            isMobileAppChecked();
        });

        // is mobile app checked
        function isMobileAppChecked() {
            if ($('#is_mobile').is(":checked")){
                $('#agreement').removeClass('d-none');
                $('#agreement :input').removeAttr('disabled', true);
                $('#agreement select').removeAttr('disabled', true);
            } else {
                $('#agreement').addClass('d-none');
                $('#agreement :input').attr('disabled', true);
                $('#agreement select').attr('disabled', true);
            }
        }

   </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/pplus_web/resources/views/dashboard/merchants/edit.blade.php ENDPATH**/ ?>