<?php $__env->startSection('title','Registered Users'); ?>
<?php $__env->startSection('styles'); ?>
    <style type="text/css">
        tbody tr td:nth-child(2), 
        tbody tr td:nth-child(3), 
        tbody tr td:nth-child(4){
            padding-top: 24px !important;
        }
        tbody tr td:nth-child(5){
            padding-top: 20px !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Registered Users</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="<?php echo e(route('dashboard')); ?>">Home</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Registered Users</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-6 col-12">
                    <h4 class="page-title mt-2">
                        <i class="mdi mdi-account-multiple"></i>
                        List of Registered Users (<span id="count">0</span>)
                    </h4>                
                </div>
                <div class="col-lg-6 col-12 text-right">
                    <?php if(auth()->check() && auth()->user()->hasRole('super_admin|admin')): ?>
                        <a href="<?php echo e(route('administration.users.add')); ?>">
                            <button class="btn btn-success">
                                <i class="mdi mdi-account-plus"></i> Add User
                            </button>  
                        </a>  
                    <?php endif; ?>   
                </div>
                
                <div class="col-12 mt-1">
                    <div class="card">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="userTable" class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>Company</th>
                                            <th>User Type</th>
                                            <th>Cashier ID</th>
                                            <th>Status</th>
                                            <th width="10%">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- view merchant modal -->
        <?php echo $__env->make('dashboard.administration.users.partials.view-user-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php echo $__env->make('dashboard.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
    </div>
    
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
   <script type="text/javascript">
        
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        var table = $('#userTable').DataTable({
            ajax: "<?php echo e(route('administration.users.list')); ?>",
            columns: [
                { data : 'name' },
                { data : 'company' },
                { data : 'usertype' },
                { data : 'cashierid' },
                { data : 'status' },
                { data : 'action', orderable: false, searchable: false}
            ],
            paging      : true,
            lengthChange: true,
            searching   : true,
            ordering    : false,
            info        : true,
            autoWidth   : false,
            dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                        "<'row'<'col-12'tr>>" +
                        "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
            fnDrawCallback: function () {
                self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                $('#count').text(self.QtdOcorrenciasAgendadosHoje);
            }
        });

        // view modal
        $('body').on('click', '#view', function(e){
            e.preventDefault();

            var url = $(this).attr('href');
            
            $.ajax({
                type: "GET",
                url: url,
                success: function (response) {
                    $('#image').attr('src',response.path);
                    $('#name').text(response.name);
                    $('#email').text(response.email);
                    $('#username').text(response.username);
                    $('#contact_number').text(response.contact_number);
                    $('#employee_number').text(response.employee_number);
                    $('#department').text(response.department);
                    $('#company').text(response.company);
                    $('#usertype').text(response.usertype);
                    
                    $('#user_status').empty();
                    if (response.status == 1) {
                        $('#user_status').append('<i class="mdi mdi-checkbox-blank-circle text-success mr-2"></i> Active');
                    } else {
                        $('#user_status').append('<i class="mdi mdi-checkbox-blank-circle text-danger mr-2"></i> Not Active');
                    }
                    $('#created_at').text(response.date_registered);
                    $('#viewUserModal').modal('show');
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });

        // Status Activate or Deactivate
        $('body').on('click','#status', function(e){
            e.preventDefault();

            var url = $(this).attr('href');
            var status = $(this).data('status');

            swal({
                title: "Are you sure?",
                text: "Once you "+ status +", it will "+ status+" user!",
                type: "warning",
                confirmButtonClass: status == 'Deactivate' ? 'btn-danger' : 'btn-success',
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: status,
                closeOnConfirm: false,
            },
            ()=>{
                $.ajax({
                    type: "POST",
                    url: url,
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>"
                    },
                    success: function (response) {
                        table.ajax.reload();
                        swal({
                            title: status+"d!",
                            text: response.message,
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });
                    },
                    error: function (response) {
                        swal('Error!', response, 'danger');
                    }
                });
            });
        });

        // User Reset Password
        $('body').on('click','#resetPassword', function(e){
            e.preventDefault();

            var url = $(this).attr('href');

            swal({
                title: "Are you sure?",
                text: 'Once you Reset Password, it will reset the user password to "pplus2020"',
                type: "warning",
                confirmButtonClass: 'btn-danger',
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: 'Reset',
                closeOnConfirm: false,
            },
            ()=>{
                $.ajax({
                    type: "POST",
                    url: url,
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>"
                    },
                    success: function (response) {
                        table.ajax.reload();
                        swal({
                            title: "Reset Password!",
                            text: response.message,
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });
                    },
                    error: function (response) {
                        swal('Error!', response, 'danger');
                    }
                });
            });
        });

   </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/pplus_web/resources/views/dashboard/administration/users/index.blade.php ENDPATH**/ ?>