<?php $__env->startSection('title','Merchant Establishments'); ?>
<?php $__env->startSection('styles'); ?>
    <style type="text/css">
        #establishmentTable tbody tr td:nth-child(2), 
        #establishmentTable tbody tr td:nth-child(3), 
        #establishmentTable tbody tr td:nth-child(4){
            padding-top: 24px !important;
        }
        #establishmentTable tbody tr td:nth-child(5){
            padding-top: 20px !important;
        }
        /*Fix Autocomplete address in modal*/
        .pac-container {
            z-index: 1051 !important;
        }
        .form-group{
            margin-bottom: .6rem;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Establishments</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="<?php echo e(route('dashboard')); ?>">Home</a>
                                </li>
                                <li class="breadcrumb-item">Merchant Settings</li>
                                <li class="breadcrumb-item active" aria-current="page">Establishments</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-6 col-12">
                    <h4 class="page-title mt-2">
                        <i class="mdi mdi-account-settings-variant"></i>
                        List of Establishments (<span id="count">0</span>)
                    </h4>                
                </div>
                <div class="col-lg-6 col-12 text-right">
                    <button class="btn btn-success" onclick="addEstablishment()">
                        <i class="fa fa-plus"></i> Add Establishment
                    </button>       
                </div>
                <div class="col-12 mt-1">
                    <div class="card">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="establishmentTable" class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th width="20%">Establishment Name</th>
                                            <th>Address</th>
                                            <th width="10%">Type</th>
                                            <th width="10%">Status</th>
                                            <th width="10%">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- modal -->
        <div id="addEstablishmentModal" class="modal" tabindex="-1" role="dialog" aria-labelledby="vcenter" aria-hidden="true" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <form id="add-establishment" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="modal-header">
                            <h4 class="modal-title" id="vcenter">
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                        </div>
                        <div class="modal-body">
                            <div class="row pr-1 pl-1">
                                <div class="col-12 form-group">
                                    <label class="control-label">Image*</label>
                                    <input type="file" class="form-control" name="image" id="image" required>
                                </div>
                                <div class="col-12 form-group">
                                    <label class="control-label">Name*</label>
                                    <input type="text" class="form-control" name="name" id="name" placeholder="Enter establishment name" required>
                                    <input type="hidden" name="establishment_id" id="establishment_id">
                                    <div class="invalid-feedback name"></div>
                                </div>
                                <div class="col-12 form-group">
                                    <label class="control-label">Address*</label>
                                    <input type="text" class="form-control" name="address" id="address" placeholder="Enter Address" required>
                                </div>
                                <div class="col-lg-6 col-12 form-group">
                                    <label class="control-label">Latitude</label>
                                    <input type="text" class="form-control" name="latitude" id="latitude" placeholder="Enter Latitude">
                                </div>
                                <div class="col-lg-6 col-12 form-group">
                                    <label class="control-label">Longitude</label>
                                    <input type="text" class="form-control" name="longitude" id="longitude" placeholder="Enter Longitude">
                                </div>
                                <div class="col-12 form-group">
                                    <label class="control-label">Description*</label>
                                    <input type="text" class="form-control" name="description" id="description" placeholder="Enter description" required>
                                </div>
                                <div class="col-12 form-group">
                                    <label class="control-label">Industry Type*</label>
                                    <select class="form-control select" name="merchant_type_id" id="merchant_type_id" required>
                                        <option value="" selected disabled>Select Industry Type</option>
                                        <?php $__currentLoopData = $merchant_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($type->id); ?>"><?php echo e(ucwords($type->name)); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-12 form-group">
                                    <label class="control-label">Merchant*</label>
                                    <select class="form-control select" name="merchant_id" id="merchant_id" required>    
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger waves-effect" data-dismiss="modal">Cancel</button>
                            <button type="submit" id="save" class="btn btn-info waves-effect">
                                <i class="fa fa-save"></i> Save
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <?php echo $__env->make('dashboard.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
    </div>
    
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script type="text/javascript">
       
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        var table = $('#establishmentTable').DataTable({
            ajax: "<?php echo e(route('settings.merchant.establishments.list')); ?>",
            columns: [
                { data : 'name' },
                { data : 'address' },
                { data : 'merchant_type' },
                { data : 'status' },
                { data : 'action', orderable: false, searchable: false}
            ],
            paging      : true,
            lengthChange: true,
            searching   : true,
            ordering    : false,
            info        : true,
            autoWidth   : false,
            dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                        "<'row'<'col-12'tr>>" +
                        "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
            fnDrawCallback: function () {
                self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                $('#count').text(self.QtdOcorrenciasAgendadosHoje);
            }
        });

        // Modal Add
        function addEstablishment() {
            $('#addEstablishmentModal').modal('show');
            $('#save').removeAttr('disabled',true);
            $('#image').attr('required',true);
            $('#name').removeClass('is-invalid');
            $('.name').removeClass('invalid-feedback');
            $('.name').text('');

            const token = $('input[name="_token"]').val();
            $('#addEstablishmentModal :input').val('');
            $('#addEstablishmentModal select').select2('');
            $('input[name="_token"]').val(token);
            select2();
            getMerchants();

            var content = "<i class='mdi mdi-plus'></i> Add Establishment";
            $('#vcenter').html(content);
        }

        // Modal Edit
        $('body').on('click','#edit', function(e){
            e.preventDefault();

            $('#save').removeAttr('disabled',true);
            $('#name').removeClass('is-invalid');
            $('.name').removeClass('invalid-feedback');
            $('.name').text('');
            $('#image').val('');
            $('#image').removeAttr('required',true);
            select2();

            var content = "<i class='mdi mdi-table-edit'></i> Edit Establishment";
            $('#vcenter').html(content);

            var url = $(this).attr('href');

            $.ajax({
                type: "GET",
                url: url,
                success: function (response) {
                    $('#name').val(response.name);
                    $('#address').val(response.address);
                    $('#latitude').val(response.latitude);
                    $('#longitude').val(response.longitude);
                    $('#description').val(response.description);
                    $('#establishment_id').val(response.id);

                    $('#merchant_type_id').empty();
                    $('#merchant_type_id').append('<option value="" selected disabled>Select Industry Type</option>');
                    $.each(response.merchant_types, function(id, data) {
                        $('#merchant_type_id').append('<option value="'+ data.id +'" '+ ((response.merchant_type_id == data.id) ? 'selected' : '') +'>'+ data.name +'</option>'); 
                    });

                    // get merchants
                    getMerchants(response, null);

                    $('#addEstablishmentModal').modal('show');
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });

        // Form Add & Update
        $('form').submit( function(e){
            e.preventDefault();

            $('#save').attr('disabled',true);

            const establishment_id = $('#establishment_id').val();

            var url = establishment_id == '' ? '<?php echo e(route('settings.merchant.establishments')); ?>' : 
                                    '<?php echo e(route('settings.merchant.establishments.update')); ?>';

            let form = new FormData(this);

            $.ajax({
                url: url,
                type: 'POST',
                data: form,
                cache: false,
                contentType: false,
                processData: false,
                beforeSend: function(){
                   loadingAjaxPreloader();
                },
                success: function (response) {

                    if (response.message == 'success') {
                        
                        $('#save').removeAttr('disabled',true);
                        $('#addEstablishmentModal').modal('hide');
                        $('#name').removeClass('is-invalid');
                        $('.name').removeClass('invalid-feedback');
                        $('.name').text('');

                        successAjaxPreloader();
                        table.ajax.reload();
                        swal({
                            title: "Success",
                            text: 'Establishment successfully',
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });
                        
                    } else {
                        successAjaxPreloader();
                        console.log(response);
                    }
                },
                error: function(error){
                  console.log(error);
                },
            });
        });

        // Status Activate or Deactivate
        $('body').on('click','#status', function(e){
            e.preventDefault();

            var url = $(this).attr('href');
            var status = $(this).data('status');

            swal({
                title: "Are you sure?",
                text: "Once you "+ status +", it will "+ status+" establishment!",
                type: "warning",
                confirmButtonClass: status == 'Deactivate' ? 'btn-danger' : 'btn-success',
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: status,
                closeOnConfirm: false,
            },
            ()=>{
                $.ajax({
                    type: "POST",
                    url: url,
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>"
                    },
                    success: function (response) {
                        table.ajax.reload();
                        swal({
                            title: status+"d!",
                            text: response.message,
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });
                    },
                    error: function (response) {
                        swal({
                            title: "Cannot be deactivated!",
                            text: response.responseJSON.message,
                            type: "error"
                        });
                    }
                });
            });
        });

        // select merchant type
        $('#merchant_type_id').change( function(){
            $('#merchant_id').empty();
            getMerchants(null, $(this).val());
        });

        function select2() {
            $('select.select').select2({
                dropdownParent: $('#addEstablishmentModal'),
                width: '100%',
            });
        }

        // get members
        function getMerchants(data, type) {
            var url = '<?php echo e(route('settings.merchant.establishments.get_merchants')); ?>?type='+ type +'&filter=';
            $("#merchant_id").select2({
                ajax: {
                    url: function (params) {
                        return url + params.term;
                    },
                    dataType: 'json',
                    delay: 250,
                    cache: true,
                    multiple: true,
                    minimumInputLength: 1,
                    processResults: function(data, params) {
                        return {
                            results: $.map(data, function(item) {
                                return {
                                    text: item.name,
                                    id: item.id
                                }
                            })
                        };
                    },
                },
                dropdownParent: $('#addEstablishmentModal'),
                width: '100%',
            });

            $('#merchant_id').empty();
            $('#merchant_id').append('<option value="" selected disabled>Search Merchant</option>');
            if (data != null) {
                $('#merchant_id').append('<option value="'+ data.merchant_id +'" selected="selected">'+ data.merchant_name +'</option>');
                $('#merchant_id').trigger('change');
            }
        }

        function initialize() {
            var complete_address = document.getElementById('address');
            var autocomplete = new google.maps.places.Autocomplete(complete_address);
            google.maps.event.addListener(autocomplete, 'place_changed', function () {
                var place = autocomplete.getPlace();
                document.getElementById('latitude').value = place.geometry.location.lat();
                document.getElementById('longitude').value = place.geometry.location.lng();
            });
        }
        google.maps.event.addDomListener(window, 'load', initialize); 
   </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/pplus_web/resources/views/dashboard/settings/merchant-establishments/index.blade.php ENDPATH**/ ?>