<?php $__env->startSection('title','Vehicles'); ?>

<?php $__env->startSection('content'); ?>

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Vehicles</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="<?php echo e(route('dashboard')); ?>">Home</a>
                                </li>
                                <li class="breadcrumb-item">Merchant Settings</li>
                                <li class="breadcrumb-item active" aria-current="page">Vehicles</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-6 col-12">
                    <h4 class="page-title mt-2">
                        <i class="mdi mdi-account-settings-variant"></i> 
                        List of Vehicles (<span id="count">0</span>)
                    </h4>                
                </div>
                <div class="col-lg-6 col-12 text-right">
                    <?php if(auth()->check() && auth()->user()->hasRole('super_admin')): ?>
                        <button class="btn btn-success" onclick="addVehicle()">
                            <i class="fa fa-plus"></i> Add Vehicle
                        </button>
                    <?php endif; ?>       
                </div>
                <div class="col-12 mt-1">
                    <div class="card">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="vehicleTable" class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Name</th>
                                            <th>Model</th>
                                            <th>Plate Number</th>
                                            <th>Status</th>
                                            <th>Date/Time Created</th>
                                            <?php if(auth()->check() && auth()->user()->hasRole('super_admin')): ?>
                                                <th width="10%">Action</th>
                                            <?php endif; ?>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- modal -->
        <div id="addVehicleModal" class="modal" tabindex="-1" role="dialog" aria-labelledby="vcenter" aria-hidden="true" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <form method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="modal-header">
                            <h4 class="modal-title" id="vcenter">
                                <i class="mdi mdi-cart-plus"></i> Add Vehicle
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                        </div>
                        <div class="modal-body">
                            <div class="form-group">
                                <label class="control-label">Name*</label>                                
                                <input type="text" class="form-control" name="name" id="name" placeholder="Enter vehicle name" required>
                                <input type="hidden" name="vehicle_id" id="vehicle_id">
                                <div class="invalid-feedback name"></div>
                            </div>
                            <div class="form-group">
                                <label class="control-label">Model*</label>                                
                                <input type="text" class="form-control" name="model" id="model" placeholder="Enter model" required>
                            </div>
                            <div class="form-group">
                                <label class="control-label">Plate No.*</label>                                
                                <input type="text" class="form-control" name="plate_number" id="plate_number" placeholder="Enter plate no." required>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger waves-effect" data-dismiss="modal">Cancel</button>
                            <button type="submit" id="save" class="btn btn-info waves-effect">
                                <i class="fa fa-save"></i> Save
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <?php echo $__env->make('dashboard.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
    </div>
    
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
   <script type="text/javascript">
       
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        var table = $('#vehicleTable').DataTable({
            ajax: "<?php echo e(route('merchants.vehicles.list')); ?>",
            columns: [
                { data : 'DT_RowIndex' },
                { data : 'name' },
                { data : 'model' },
                { data : 'plate_number' },
                { data : 'status' },
                { data : 'created_at' },
                <?php if(auth()->check() && auth()->user()->hasRole('super_admin')): ?>
                    { data : 'action', orderable: false, searchable: false}
                <?php endif; ?>
            ],
            paging      : true,
            lengthChange: true,
            searching   : true,
            ordering    : false,
            info        : true,
            autoWidth   : false,
            dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                        "<'row'<'col-12'tr>>" +
                        "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
            fnDrawCallback: function () {
                self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                $('#count').text(self.QtdOcorrenciasAgendadosHoje);
            }
        });

        // Modal Add
        function addVehicle() {
            $('#addVehicleModal').modal('show');
            $('#save').removeAttr('disabled',true);
            $('#name').removeClass('is-invalid');
            $('.name').removeClass('invalid-feedback');
            $('.name').text('');
            $('#name').val('');

            const token = $('input[name="_token"]').val();
            $('#addVehicleModal :input').val('');
            $('#addVehicleModal select').select2('');
            $('input[name="_token"]').val(token);

            var content = "<i class='mdi mdi-plus'></i> Add Vehicle";
            $('#vcenter').html(content);
        }

        // Modal Edit
        $('body').on('click','#edit', function(e){
            e.preventDefault();

            $('#save').removeAttr('disabled',true);
            $('#name').removeClass('is-invalid');
            $('.name').removeClass('invalid-feedback');
            $('.name').text('');
            
            var content = "<i class='mdi mdi-table-edit'></i> Edit Vehicle";
            $('#vcenter').html(content);

            var url = $(this).attr('href');

            $.ajax({
                type: "GET",
                url: url,
                success: function (response) {
                    $('#name').val(response.name);
                    $('#model').val(response.model);
                    $('#plate_number').val(response.plate_number);
                    $('#vehicle_id').val(response.id);
                    $('#addVehicleModal').modal('show');
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });

        // Form Add & Update
        $('form').submit( function(e){
            e.preventDefault();

            $('#save').attr('disabled',true);

            const vehicle_id = $('#vehicle_id').val();

            var url = vehicle_id == '' ? '<?php echo e(route('merchants.vehicles')); ?>' : 
                                    '<?php echo e(route('merchants.vehicles.update')); ?>';

            var formData = $(this).serialize();

            $.ajax({
                type: "POST",
                url: url,
                data: formData,
                success: function (response) {
                    if (response.message == 'success') {
                        $('#save').removeAttr('disabled',true);
                        $('#addVehicleModal').modal('hide');
                        $('#name').removeClass('is-invalid');
                        $('.name').removeClass('invalid-feedback');
                        $('.name').text('');
                        $('#name').val('');
        
                        table.ajax.reload();
                        swal({
                            title: "Success",
                            text: 'Vehicle successfully',
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });
                        
                    } else {

                        $('#save').removeAttr('disabled',true);
                        $('#name').addClass('is-invalid');
                        $('.name').addClass('invalid-feedback');
                        $('.name').text(response.message.name);
                    }
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });

        // Status Activate or Deactivate
        $('body').on('click','#status', function(e){
            e.preventDefault();

            var url = $(this).attr('href');
            var status = $(this).data('status');

            swal({
                title: "Are you sure?",
                text: "Once you "+ status +", it will "+ status+" Vehicle and Driver!",
                type: "warning",
                confirmButtonClass: status == 'Deactivate' ? 'btn-danger' : 'btn-success',
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: status,
                closeOnConfirm: false,
            },
            ()=>{
                $.ajax({
                    type: "POST",
                    url: url,
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>"
                    },
                    success: function (response) {
                        table.ajax.reload();
                        swal({
                            title: status+"d!",
                            text: response.message,
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });
                    },
                    error: function (response) {
                        swal('Error!', response, 'danger');
                    }
                });
            });
        });

   </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/pplus_web/resources/views/dashboard/settings/merchant-vehicles/index.blade.php ENDPATH**/ ?>