<?php $__env->startSection('title','Merchants Redemption Report'); ?>
<?php $__env->startSection('styles'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('admin_dashboard/assets/libs/daterangepicker/daterangepicker.css')); ?>">
    <style type="text/css">
        #merchantRedemtionTable tbody tr td:nth-child(1), 
        #merchantRedemtionTable tbody tr td:nth-child(3), 
        #merchantRedemtionTable tbody tr td:nth-child(5), 
        #merchantRedemtionTable tbody tr td:nth-child(6), 
        #merchantRedemtionTable tbody tr td:nth-child(7){
            padding-top: 24px !important;
        }
        h6.text-uppercase{
            font-weight: 500
        }
        h4.font-light{
            font-weight: 500 !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Merchants Redemption Report</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="<?php echo e(route('dashboard')); ?>">Home</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Merchants Redemption Report</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-4 col-12">
                    <div class="card">
                        <div class="card-body shadow">
                            <div class="row">
                                <div class="col p-r-0 mt-2">
                                    <h6 class="text-muted text-uppercase">Merchant Points Paid</h6>
                                    <h4 class="font-light" id="totalPointsPaid">0</h4>
                                    <h6 class="text-muted">Total</h6>
                                </div>
                                <div class="col-5 text-right align-self-center">
                                    <div class="round align-self-center round-success">
                                        <i class="mdi mdi-file-document-box mdi-24px"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-10 col-12">
                    <h4 class="page-title mt-2">
                        <i class="mdi mdi-cart"></i>
                        List of Merchants Redemption Report (<span id="count">0</span>)
                    </h4>                
                </div>
                
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <?php if(auth()->check() && auth()->user()->hasRole('super_admin|admin')): ?>
                                    <div class="col-12">
                                        <form method="get">
                                            <div class="row">
                                                <div class="col-lg-3 col-12">
                                                    <h6 class="text-uppercase">Date Range :</h6>
                                                    <input type="text" name="date" class="form-control" id="daterangepicker">
                                                </div>
                                                <div class="col-lg-3 col-12">
                                                    <h6 class="text-uppercase">Merchants :</h6>
                                                    <select class="form-control" name="merchant_id" id="merchant_id">
                                                    </select>
                                                </div>
                                                <div class="col-lg-4 col-12">
                                                    <button class="btn btn-info mt-4 mr-1" type="submit">
                                                        <i class="mdi mdi-filter"></i> Filter
                                                    </button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                <?php endif; ?>
                                <div class="col-12 <?php if(auth()->check() && auth()->user()->hasRole('super_admin')): ?> mt-4 <?php endif; ?>">
                                    <div class="table-responsive">
                                        <table id="merchantRedemtionTable" class="table table-hover display nowrap">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>Merchant</th>
                                                    <th>Voucher Code</th>
                                                    <th>Member</th>
                                                    <th>Allocation Amount Before</th>
                                                    <th>Allocation Amount Offer</th>
                                                    <th>Pts. Paid</th>
                                                    <th>Cashier</th>
                                                    <th>Date</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php echo $__env->make('dashboard.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
    </div>
    
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <!-- start - This is for export functionality only -->
    <script src="https://cdn.datatables.net/buttons/1.5.1/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.5.1/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.5.1/js/buttons.print.min.js"></script>

    <script src="<?php echo e(asset('admin_dashboard/assets/libs/moment/moment.js')); ?>"></script>
    <script src="<?php echo e(asset('admin_dashboard/assets/libs/daterangepicker/daterangepicker.js')); ?>"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/plug-ins/1.10.21/api/sum().js"></script>
    <script type="text/javascript">
        $(document).ready( function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            initialize();

            function initialize(formData){
                var url = "<?php echo e(route('reports.merchants.redemption.list')); ?>";
                url = (formData != null) ? url + "?" + formData : url;
                $('#merchantRedemtionTable').DataTable({
                    ajax: url,
                    columns: [
                        { data : 'DT_RowIndex' },
                        { data : 'merchant_name' },
                        { data : 'voucher_code' },
                        { data : 'member_name' },
                        { data : 'allocation_amount_before' },
                        { data : 'allocation_amount_after' },
                        { data : 'points_amount' },
                        { data : 'cashier' },
                        { data : 'created_at' },
                    ],
                    paging      : true,
                    lengthChange: true,
                    searching   : true,
                    ordering    : false,
                    info        : true,
                    autoWidth   : false,
                    destroy     : true,
                    buttons     : ['csv', 'excel', 'print'],
                    dom         : "<'row'<'col-lg-6 col-12' <?php if(auth()->check() && auth()->user()->hasRole('super_admin|merchant_admin')): ?> B <?php endif; ?>><'col-lg-6 col-12'f>>" +
                            "<'row'<'col-12'tr>>" +
                            "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
                    fnDrawCallback: function () {
                        self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                        $('#count').text(self.QtdOcorrenciasAgendadosHoje);

                        var amount = this.api().column(6).data().sum();
                        $('#totalPointsPaid').text(numberFormat(amount));

                        if (self.QtdOcorrenciasAgendadosHoje < 1)  {
                            $('.dt-buttons').addClass('d-none');
                        } else {
                            $('.dt-buttons').removeClass('d-none');
                        }
                    }
                });

                $('.buttons-csv, .buttons-print, .buttons-excel').addClass('btn btn-success mr-1');
            }

            // Form Get Submit
            $('form').submit( function(e){
                e.preventDefault();
                var formData = $(this).serialize();

                initialize(formData);
            });

            // Custom Date Range
            var date = $('#daterangepicker').daterangepicker({
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                },
                alwaysShowCalendars: true,
                drops: "down",
                buttonClasses: "btn",
                applyClass: "btn-info",
                cancelClass: "btn-danger",
            });

            getAllMerchants();

            // get All Merchants
            function getAllMerchants() {
                $.ajax({
                    type: "GET",
                    url: "<?php echo e(route('administration.merchants')); ?>",
                    success: function (response) {
                        $('#merchant_id').append('<option value="all">All</option>');
                        for (i = 0; i < response.length; i++) {
                            $('#merchant_id').append('<option value='+response[i].id+' "<?php echo e(old("merchant_id") == 'response[i].id' ? "selected" : ''); ?>">'+response[i].name.toUpperCase()+'</option>');
                        }
                    },
                    error: function (response) {
                        console.log('Error:', response);
                    }
                });
            }

            // amount number format
            function numberFormat(num) {
              return '₱ '+num.toFixed(2).replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1,')
            }

            $('#merchant_id').select2({
                width  : '100%',
            }); 
        });
    </script> 
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/pplus_web/resources/views/dashboard/reports/merchants-redemption/index.blade.php ENDPATH**/ ?>