<!DOCTYPE html>
<html>
  <head>
    <title>Membership Upgrade</title>
    <style type="text/css">
      body {
        background-color: #eee
      }

      .card {
        border: none;
        width: 400px
      }

      .dots {
        position: absolute;
        height: 17px;
        width: 17px;
        background-color: red;
        border-radius: 50%;
        bottom: 16px;
        right: 143px;
        font-size: 10px;
        color: #fff;
        display: flex;
        justify-content: center;
        align-items: center
      }

      .earn-text {
        font-size: 13px
      }

      .form-control {
        height: 40px;
        font-size: 14px
      }

      .btn {
        font-size: 14px
      }

      .form-control:focus {
        box-shadow: none;
        border: 1px solid #dc3545
      }

      .email-text {
        font-size: 12px
      }

      a {
        color: #dc3545
      }

      a:hover {
        color: #dc3545
      }
    </style>
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0-beta1/dist/css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
  </head>
  <body>
    <div class="container mt-5 mb-5 d-flex justify-content-center">
      <div class="card p-3 text-center">
        <div class="position-relative">
          <img src="../../admin_dashboard/img/default.png" class="rounded-circle mr-2" width="100px" height="100px">
          <span class="dots">
            <i class="fa fa-check"></i>
          </span>
        </div>
        <div>
          <h5>Membership Upgrade</h5>
          <span class="earn-text">
            <strong> <?php echo e($full_name); ?> </strong> reaches the target amount of points for membership upgrade. <br>
            <hr />
          </span>
        </div>
        <div class="mt-3 px-3 d-flex justify-content-between align-items-center">
          <div class="d-flex flex-column">
            <div class="d-flex justify-content-start">
              <h6 class="mb-0">Redeemable Points</h6>
            </div>
            <span class="email-text">used to pay for membership upgrade.</span>
          </div>
          <span>
            <strong><?php echo e((int) $current_points); ?></strong>
            <small>points</small>
          </span>
        </div>
        <div class="mt-3 px-3 d-flex justify-content-between align-items-center">
          <div class="d-flex flex-column">
            <div class="d-flex justify-content-start">
              <h6 class="mb-0">Membership Upgrade Fee</h6>
            </div>
          </div>
          <span>
            <strong>200</strong>
            <small>points</small>
          </span>
        </div>
        <br />
        <hr />
        <div class="mt-4">
          <a href="<?php echo e(route('members.upgradeMembership',$user_id)); ?>" class="btn btn-success text-decoration-none">Upgrade Membership</a>
        </div>
      </div>
    </div>
  </body>
</html>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0-beta1/dist/js/bootstrap.bundle.min.js"></script>
<?php /**PATH /var/www/html/pplus_web/resources/views/dashboard/members/upgrade.blade.php ENDPATH**/ ?>