<?php $__env->startSection('title','Product Sales Report'); ?>
<?php $__env->startSection('styles'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('admin_dashboard/assets/libs/daterangepicker/daterangepicker.css')); ?>">
    <style type="text/css">
        #productReportTable tbody tr td:nth-child(1), 
        #productReportTable tbody tr td:nth-child(3), 
        #productReportTable tbody tr td:nth-child(4), 
        #productReportTable tbody tr td:nth-child(5), 
        #productReportTable tbody tr td:nth-child(6),
        #productReportTable tbody tr td:nth-child(7){
            padding-top: 24px !important;
        }
        h6.text-uppercase{
            font-weight: 500
        }
        h4.font-light{
            font-weight: 400 !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Product Sales Report</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="<?php echo e(route('dashboard')); ?>">Home</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Product Sales Report</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-4 col-12">
                    <div class="card">
                        <div class="card-body shadow">
                            <div class="row">
                                <div class="col p-r-0 mt-2">
                                    <h6 class="text-muted text-uppercase">Quantity</h6>
                                    <h4 class="font-light" id="total_quantity">0</h4>
                                    <h6 class="text-muted">Total</h6>
                                </div>
                                <div class="col-5 text-right align-self-center">
                                    <div class="round align-self-center round-success">
                                        <i class="mdi mdi-dropbox mdi-24px"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-12">
                    <div class="card">
                        <div class="card-body shadow">
                            <div class="row">
                                <div class="col p-r-0 mt-2">
                                    <h6 class="text-muted text-uppercase">Amount</h6>
                                    <h4 class="font-light" id="total_amount">0</h4>
                                    <h6 class="text-muted">Total</h6>
                                </div>
                                <div class="col-5 text-right align-self-center">
                                    <div class="round align-self-center round-success">
                                        <i class="mdi mdi-dropbox mdi-24px"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-6 col-12">
                    <h4 class="page-title mt-2">
                        <i class="mdi mdi-dropbox"></i>
                        List of Product Sales Report (<span id="count">0</span>)
                    </h4>                  
                </div>
                <div class="col-lg-6 col-12 text-right">
                    <button class="btn btn-info" id="filter">
                        <i class="mdi mdi-filter"></i> Filter
                    </button> 
                </div>
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="productReportTable" class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Product Code</th>
                                            <th>Product Name</th>
                                            <th>Category</th>
                                            <th>Price</th>
                                            <th>Quantity</th>
                                            <th>Total Amount</th>
                                            <th>Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal Add-->
        <div id="filterProductModal" class="modal" tabindex="-1" role="dialog" aria-labelledby="vcenter" aria-hidden="true" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <form method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="modal-header">
                            <h4 class="modal-title" id="vcenter">
                                Filter Options
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                        </div>
                        <div class="modal-body">
                            <div class="form-group">
                                <h6 class="text-uppercase">Date Range :</h6>
                                <input type="text" name="date" class="form-control" id="daterangepicker">
                            </div>
                            <div class="form-group">
                                <h6 class="text-uppercase">Select Status :</h6>
                                <select class="form-control select multiple" name="status[]" id="status" multiple="multiple" required>
                                    <option value="all">All</option>
                                    <option value="completed">Completed</option>
                                    <option value="delivered">Delivered</option>
                                    <option value="pending">Pending</option>
                                    <option value="cancelled">Cancelled</option>
                                    <option value="ongoing">Ongoing</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <h6 class="text-uppercase">Select Category :</h6>
                                <select class="form-control select multiple" name="categories[]" id="categories" multiple="multiple" required>
                                    <option value="all">All</option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <h6 class="text-uppercase">Select Items :</h6>
                                <select class="form-control select multiple" name="items[]" id="items" multiple="multiple" required>
                                    <option value="all" id="">All</option>
                                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($product->id); ?>"><?php echo e($product->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger waves-effect" onclick="resetSelect()">
                                <i class="mdi mdi-refresh"></i> Reset
                            </button>
                            <button type="submit" id="save" class="btn btn-info waves-effect">
                                <i class="mdi mdi-filter"></i> Filter
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <?php echo $__env->make('dashboard.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
    </div>
    
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <!-- start - This is for export functionality only -->
    <script src="https://cdn.datatables.net/buttons/1.5.1/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.5.1/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.5.1/js/buttons.print.min.js"></script>

    <script src="<?php echo e(asset('admin_dashboard/assets/libs/moment/moment.js')); ?>"></script>
    <script src="<?php echo e(asset('admin_dashboard/assets/libs/daterangepicker/daterangepicker.js')); ?>"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/plug-ins/1.10.21/api/sum().js"></script>
    <script type="text/javascript">
    $(document).ready( function(){

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        initialize();

        function initialize(formData){
            var url = "<?php echo e(route('reports.merchant.products.list')); ?>";
            url = (formData != null) ? url + "?" + formData : url;
            $('#productReportTable').DataTable({
                ajax: url,
                columns: [
                    { data : 'item_code' },
                    { data : 'name' },
                    { data : 'category' },
                    { data : 'price' },
                    { data : 'quantity' },
                    { data : 'total_amount'},
                    { data : 'status'}
                ],
                paging      : true,
                lengthChange: true,
                searching   : true,
                ordering    : false,
                info        : true,
                autoWidth   : false,
                destroy     : true,
                buttons     : ['csv', 'excel', 'print'],
                dom         : "<'row'<'col-lg-6 col-12' B><'col-lg-6 col-12'f>>" +
                            "<'row'<'col-12'tr>>" +
                            "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
                fnDrawCallback: function () {
                    self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                    $('#count').text(self.QtdOcorrenciasAgendadosHoje);


                    var quantity = this.api().column(4).data().sum();
                    var amount = this.api().column(5).data().sum();

                    $('#total_quantity').text(quantity);
                    $('#total_amount').text(numberFormat(amount));

                    if (self.QtdOcorrenciasAgendadosHoje < 1)  {
                        $('.dt-buttons').addClass('d-none');
                    } else {
                        $('.dt-buttons').removeClass('d-none');
                    }
                }
            });

            $('.buttons-csv, .buttons-print, .buttons-excel').addClass('btn btn-success mr-1');
        }

        // Form Get Submit
        $('form').submit( function(e){
            e.preventDefault();
            var formData = $(this).serialize();

            initialize(formData);
            $('#filterProductModal').modal('hide');
        });

        // Filter Report
        $('#filter').click( function(){
            $('#filterProductModal').modal('show');
        });

        // Custom Date Range
        var date = $('#daterangepicker').daterangepicker({
            ranges: {
                'Today': [moment(), moment()],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
            },
            alwaysShowCalendars: true,
            drops: "down",
            buttonClasses: "btn",
            applyClass: "btn-info",
            cancelClass: "btn-danger",
        });

        $('.select').select2({
            width  : '100%',
        });

        // status
        $("#status").change( function(){
            var val = $(this).val();

            if (val == 'all') {
                $("#status > option").prop("selected", "selected");
                $("#status").trigger("change");
            }
        });

        // categories
        $("#categories").change( function(){
            var val = $(this).val();

            if (val == 'all') {
                $("#categories > option").prop("selected", "selected");
                $("#categories").trigger("change");
            }
        });

        // items
        $("#items").change( function(){
            var val = $(this).val();

            if (val == 'all') {
                $("#items > option").prop("selected", "selected");
                $("#items").trigger("change");
            }
        });
    });

    // resel select
    function resetSelect() {
        $("#filterProductModal select").val(null).trigger("change"); 
    }

    // amount number format
    function numberFormat(num) {
      return '₱ '+num.toFixed(2).replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1,')
    }
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/pplus_web/resources/views/dashboard/reports/merchant-product-sales/index.blade.php ENDPATH**/ ?>