<?php $__env->startSection('title','Patients'); ?>
<?php $__env->startSection('styles'); ?>
    <style type="text/css">
        tbody tr td:nth-child(2), 
        tbody tr td:nth-child(3), 
        tbody tr td:nth-child(4), 
        tbody tr td:nth-child(5){
            padding-top: 24px !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Patients</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="<?php echo e(route('dashboard')); ?>">Home</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Patients</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-6 col-12">
                    <h4 class="page-title mt-2">
                        <i class="mdi mdi-nature-people"></i>
                        List of Patients (<span id="count">0</span>)
                    </h4>                
                </div>
                
                <div class="col-12 mt-1">
                    <div class="card">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="patientTable" class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>Referrence #</th>
                                            <th>Email</th>
                                            <th>Mobile No.</th>
                                            <th>Date/Time</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php echo $__env->make('dashboard.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
    </div>
    
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script type="text/javascript">
        $(document).ready( function(){
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            var table = $('#patientTable').DataTable({
                ajax: "<?php echo e(route('doctors.patients.list')); ?>",
                columns: [
                    { data : 'name' },
                    { data : 'reference_id' },
                    { data : 'email' },
                    { data : 'mobile_number' },
                    { data : 'created_at' },
                ],
                paging      : true,
                lengthChange: true,
                searching   : true,
                ordering    : false,
                info        : true,
                autoWidth   : false,
                dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                            "<'row'<'col-12'tr>>" +
                            "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
                fnDrawCallback: function () {
                    self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                    $('#count').text(self.QtdOcorrenciasAgendadosHoje);
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/pplus_web/resources/views/dashboard/merchants/doctors/patients/index.blade.php ENDPATH**/ ?>