<?php $__env->startSection('title','Bayanihan'); ?>
<?php $__env->startSection('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('bayanihan-hierarchy/css/jquery.orgchart.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('bayanihan-hierarchy/css/style.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="page-wrapper" style="padding-top: 60px !important">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg col-12">
                    <div class="card">
                        <div class="card-body shadow">
                            <div class="row">
                                <div class="col p-r-0">
                                    <div class="round align-self-center round-success mt-1">
                                        <i class="mdi mdi-account-multiple mdi-24px"></i>
                                    </div>
                                </div>
                                <div class="col text-right align-self-center">
                                    <h3 class="font-light first_level_count">0</h3>
                                    <h6 class="text-muted">1st Level</h6>
                                </div>
                            </div>
                        </div>
                    </div>                         
                </div>
                <div class="col-lg col-12">
                    <div class="card">
                        <div class="card-body shadow">
                            <div class="row">
                                <div class="col p-r-0">
                                    <div class="round align-self-center round-success mt-1">
                                        <i class="mdi mdi-account-multiple mdi-24px"></i>
                                    </div>
                                </div>
                                <div class="col text-right align-self-center">
                                    <h3 class="font-light second_level_count">0</h3>
                                    <h6 class="text-muted">2nd Level</h6>
                                </div>
                            </div>
                        </div>
                    </div>                         
                </div>
                <div class="col-lg col-12">
                    <div class="card">
                        <div class="card-body shadow">
                            <div class="row">
                                <div class="col p-r-0">
                                    <div class="round align-self-center round-success mt-1">
                                        <i class="mdi mdi-account-multiple mdi-24px"></i>
                                    </div>
                                </div>
                                <div class="col text-right align-self-center">
                                    <h3 class="font-light third_level_count">0</h3>
                                    <h6 class="text-muted">3rd Level</h6>
                                </div>
                            </div>
                        </div>
                    </div>                         
                </div>
                <div class="col-lg col-12">
                    <div class="card">
                        <div class="card-body shadow">
                            <div class="row">
                                <div class="col p-r-0">
                                    <div class="round align-self-center round-success mt-1">
                                        <i class="mdi mdi-account-multiple mdi-24px"></i>
                                    </div>
                                </div>
                                <div class="col text-right align-self-center">
                                    <h3 class="font-light fourth_level_count">0</h3>
                                    <h6 class="text-muted">4th Level</h6>
                                </div>
                            </div>
                        </div>
                    </div>                         
                </div>
                <div class="col-lg col-12">
                    <div class="card">
                        <div class="card-body shadow">
                            <div class="row">
                                <div class="col p-r-0">
                                    <div class="round align-self-center round-success mt-1">
                                        <i class="mdi mdi-account-multiple mdi-24px"></i>
                                    </div>
                                </div>
                                <div class="col text-right align-self-center">
                                    <h3 class="font-light fifth_level_count">0</h3>
                                    <h6 class="text-muted">5th Level</h6>
                                </div>
                            </div>
                        </div>
                    </div>                         
                </div>
                <div class="col-md-12">
                    <div class="card p-2">
                        <div id="chart-container"></div>
                    </div>
                </div>
            </div>
        </div>

        <?php echo $__env->make('dashboard.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
    </div>
    
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery-mockjax/1.6.2/jquery.mockjax.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('bayanihan-hierarchy/js/jquery.orgchart.js')); ?>"></script>
    <script type="text/javascript">
        $(document).ready( function(){
            jQuery.ajax({
                url : '<?php echo e(route('bayanihan.members.list')); ?>/'+"<?php echo e($id); ?>",
                type: "GET",
                success: function(data){
                    $('#chart-container').orgchart({
                        'data': data.downlines,
                        'nodeContent': 'title',
                        'pan': true,
                        'zoom': true,
                        'initCompleted': function ($chart) {
                            var $container = $('#chart-container');
                            $container.scrollLeft(($container[0].scrollWidth - $container.width())/2);
                        },
                        'createNode': function($node, data) {
                            $node.children('.title').html('<img class="mr-1 rounded-circle" src="' + data.photo + '" widht="90%" height="90%">'+ data.name +'');
                        }
                    });

                   $('.first_level_count').text(data.first_level_count);
                   $('.second_level_count').text(data.second_level_count);
                   $('.third_level_count').text(data.third_level_count);
                   $('.fourth_level_count').text(data.fourth_level_count);
                   $('.fifth_level_count').text(data.fifth_level_count);
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.bayanihan', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/pplus_web/resources/views/bayanihan/main/index.blade.php ENDPATH**/ ?>