<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::get('/success', 'SuccessVerificationController@index')->name('success');

Auth::routes();
Route::get(
    "email/verify/{id}/{hash}",
    "Auth\VerificationController@verify"
)->name("verification.verify");
// Homepage
Route::get('/')
	->uses('Homepage\ViewController@index')
	->name('homepage');
	
Route::get('/registrationsuccess')
	->uses('Homepage\ViewController@successRegistration')
	->name('registrationsuccess');
// Bayanihan Referral Link
Route::get('/bayanihan/referrals/{code}')
	->uses('Bayanihan\Referral\ViewController@index')
	->name('bayanihan.referrals');

Route::get('/account/register')
	->uses('Bayanihan\Referral\ViewController@register')
	->name('bayanihan.register');

Route::prefix('/')->middleware(['auth','check.active'])->namespace('Dashboard')->group( function(){

	// Dashboard
	Route::get('/dashboard')
		->uses('Main\ViewController@index')
		->name('dashboard')
		->middleware('role:super_admin|admin|human_resource|merchant_admin|accounting|human_resource|admin_cashier|merchant_cashier|doctor|member');
	Route::get('/profile')
		->uses('Main\ViewController@profile')
		->name('profile');
	Route::post('/profile')
		->uses('Main\UpdateController@index')
		->name('profile');
	Route::post('/profile/password')
		->uses('Main\UpdateController@changePassword')
		->name('profile.password');
	Route::post('/profile/schedules')
		->uses('Main\UpdateController@changeSchedules')
		->name('profile.schedules');

	// Administration Registered Users
	Route::get('/administration/users')
		->uses('Administration\ViewController@index')
		->name('administration.users')
		->middleware('role:super_admin|admin|accounting|human_resource');
	Route::get('/administration/users/list')
		->uses('Administration\ViewController@userList')
		->name('administration.users.list')
		->middleware('role:super_admin|admin|accounting|human_resource');
	Route::get('/administration/merchants')
		->uses('Administration\ViewController@getAllMerchant')
		->name('administration.merchants');

	Route::get('/administration/users/add')
		->uses('Administration\ViewController@add')
		->name('administration.users.add')
		->middleware('role:super_admin|admin');
	Route::get('/administration/users/edit/{id}')
		->uses('Administration\ViewController@edit')
		->name('administration.users.edit')
		->middleware('role:super_admin|admin');

	Route::get('/administration/users/view/{id}')
		->uses('Administration\ViewController@view')
		->name('administration.users.view')
		->middleware('role:super_admin|admin|accounting|human_resource');

	Route::post('/administration/users/add')
		->uses('Administration\CreateController@index')
		->name('administration.users.add')
		->middleware('role:super_admin|admin');

	Route::post('/administration/users/update/{id}')
		->uses('Administration\UpdateController@index')
		->name('administration.users.update')
		->middleware('role:super_admin|admin');
	Route::post('/administration/users/status/{id}')
		->uses('Administration\UpdateController@status')
		->name('administration.users.status')
		->middleware('role:super_admin|admin');
	Route::post('/administration/users/reset/{id}')
		->uses('Administration\UpdateController@resetPassword')
		->name('administration.users.reset')
		->middleware('role:super_admin|admin');
	
	// Administration Transaction Logs
	Route::get('/administration/transactions')
		->uses('Administration\ViewController@transactionLogs')
		->name('administration.transactions')
		->middleware('role:super_admin|admin');
	Route::get('/administration/transactions/list')
		->uses('Administration\ViewController@transactionLogsList')
		->name('administration.transactions.list')
		->middleware('role:super_admin|admin');

	// Merchants
	Route::get('/merchants')
		->uses('Merchant\ViewController@index')
		->name('merchants')
		->middleware('role:super_admin|admin|accounting');
	Route::get('/merchants/list')
		->uses('Merchant\ViewController@merchantList')
		->name('merchants.list')
		->middleware('role:super_admin|admin|accounting');
	Route::get('/merchants/add')
		->uses('Merchant\ViewController@add')
		->name('merchants.add')
		->middleware('role:super_admin|admin');
	Route::get('/merchants/rebates')
		->uses('Merchant\ViewController@rebates')
		->name('merchants.rebates')
		->middleware('role:super_admin|admin');
	Route::get('/merchants/edit/{id}')
		->uses('Merchant\ViewController@edit')
		->name('merchants.edit')
		->middleware('role:super_admin|admin');
	Route::get('/merchants/view/{id}')
		->uses('Merchant\ViewController@view')
		->name('merchants.view')
		->middleware('role:super_admin|admin|accounting');
	Route::get('/merchants/view/pointsetting/{id}')
		->uses('Merchant\ViewController@getActivePointSetting')
		->name('merchants.view.pointsetting')
		->middleware('role:super_admin|admin|accounting');

	Route::post('/merchants/add')
		->uses('Merchant\CreateController@index')
		->name('merchants.add')
		->middleware('role:super_admin|admin');

	Route::post('/merchants/update/{id}')
		->uses('Merchant\UpdateController@index')
		->name('merchants.update')
		->middleware('role:super_admin|admin');

	// Merchant Cashier
	Route::get('/merchants/cashiers')
		->uses('Merchant\Cashier\ViewController@index')
		->name('merchants.cashiers')
		->middleware('role:merchant_admin');
	Route::get('/merchants/cashiers/list')
		->uses('Merchant\Cashier\ViewController@merchantCashierList')
		->name('merchants.cashiers.list')
		->middleware('role:merchant_admin');
	Route::get('/merchants/cashiers/add')
		->uses('Merchant\Cashier\ViewController@add')
		->name('merchants.cashiers.add')
		->middleware('role:merchant_admin');
	Route::get('/merchants/cashiers/edit/{id}')
		->uses('Merchant\Cashier\ViewController@edit')
		->name('merchants.cashiers.edit')
		->middleware('role:merchant_admin');
	Route::get('/merchants/cashiers/view/{id}')
		->uses('Merchant\Cashier\ViewController@view')
		->name('merchants.cashiers.view')
		->middleware('role:merchant_admin');

	Route::post('/merchants/cashiers/add')
		->uses('Merchant\Cashier\CreateController@index')
		->name('merchants.cashiers.add')
		->middleware('role:merchant_admin');

	Route::post('/merchants/cashiers/update/{id}')
		->uses('Merchant\Cashier\UpdateController@index')
		->name('merchants.cashiers.update')
		->middleware('role:merchant_admin');
	Route::post('/merchants/cashiers/status/{id}')
		->uses('Merchant\Cashier\UpdateController@status')
		->name('merchants.cashiers.status')
		->middleware('role:merchant_admin');
	Route::post('/merchants/cashiers/reset/{id}')
		->uses('Merchant\Cashier\UpdateController@resetPassword')
		->name('merchants.cashiers.reset')
		->middleware('role:merchant_admin');

	Route::middleware(['merchant.admin.kola'])->group( function(){
		// Doctors
		Route::get('/merchants/doctors')
			->uses('Merchant\Doctor\ViewController@index')
			->name('merchants.doctors')
			->middleware('role:merchant_admin');
		Route::get('/merchants/doctors/list')
			->uses('Merchant\Doctor\ViewController@merchantDoctorList')
			->name('merchants.doctors.list')
			->middleware('role:merchant_admin');
		Route::get('/merchants/doctors/add')
			->uses('Merchant\Doctor\ViewController@add')
			->name('merchants.doctors.add');
		Route::get('/merchants/doctors/edit/{id}')
			->uses('Merchant\Doctor\ViewController@edit')
			->name('merchants.doctors.edit')
			->middleware('role:merchant_admin');
		Route::get('/merchants/doctors/view/{id}')
			->uses('Merchant\Doctor\ViewController@view')
			->name('merchants.doctors.view')
			->middleware('role:super_admin|merchant_admin');

		Route::post('/merchants/doctors/add')
			->uses('Merchant\Doctor\CreateController@index')
			->name('merchants.doctors.add')
			->middleware('role:merchant_admin');

		Route::post('/merchants/doctors/update/{id}')
			->uses('Merchant\Doctor\UpdateController@index')
			->name('merchants.doctors.update')
			->middleware('role:merchant_admin');
		Route::post('/merchants/doctors/status/{id}')
			->uses('Merchant\Doctor\UpdateController@status')
			->name('merchants.doctors.status')
			->middleware('role:merchant_admin');

		// Doctor Schedule
		Route::get('/merchants/doctors/schedules/add/{id}')
			->uses('Merchant\Doctor\Schedule\ViewController@index')
			->name('merchants.doctors.schedules.add')
			->middleware('role:merchant_admin');
		Route::get('/merchants/doctors/schedules/edit/{id}')
			->uses('Merchant\Doctor\Schedule\ViewController@edit')
			->name('merchants.doctors.schedules.edit')
			->middleware('role:merchant_admin');

		Route::post('/merchants/doctors/schedules/add/{id}')
			->uses('Merchant\Doctor\Schedule\CreateController@index')
			->name('merchants.doctors.schedules.add')
			->middleware('role:merchant_admin');

		Route::post('/merchants/doctors/schedules/update/{id}')
			->uses('Merchant\Doctor\Schedule\UpdateController@index')
			->name('merchants.doctors.schedules.update')
			->middleware('role:merchant_admin');

		// Merchant Patients
		Route::get('/merchants/patients')
			->uses('Merchant\Patient\ViewController@index')
			->name('merchants.patients')
			->middleware('role:merchant_admin');
		Route::get('/merchants/patients/list')
			->uses('Merchant\Patient\ViewController@patientList')
			->name('merchants.patients.list')
			->middleware('role:merchant_admin');
		Route::get('/merchants/patients/view/{id}')
			->uses('Merchant\Patient\ViewController@view')
			->name('merchants.patients.view')
			->middleware('role:merchant_admin');
		Route::get('/merchants/patients/appointments/{id}')
			->uses('Merchant\Patient\ViewController@getPatientAppointments')
			->name('merchants.patients.appointments')
			->middleware('role:merchant_admin');
	});

	Route::middleware(['merchant.admin.getta'])->group( function(){
		// Merchant Orders
		Route::get('/merchants/orders')
			->uses('Merchant\Order\ViewController@index')
			->name('merchants.orders')
			->middleware('role:merchant_admin');
		Route::get('/merchants/orders/list')
			->uses('Merchant\Order\ViewController@orderList')
			->name('merchants.orders.list')
			->middleware('role:merchant_admin');
		Route::get('/merchants/orders/view/{id}')
			->uses('Merchant\Order\ViewController@view')
			->name('merchants.orders.view')
			->middleware('role:merchant_admin');
		Route::get('/merchants/orders/view/list/{id}')
			->uses('Merchant\Order\ViewController@getCustomerOrders')
			->name('merchants.orders.view.list')
			->middleware('role:merchant_admin');

		Route::post('/merchants/orders/update/{id}')
			->uses('Merchant\Order\UpdateController@index')
			->name('merchants.orders.update')
			->middleware('role:merchant_admin');

		//update quantity
		Route::post('/merchants/order/update/qty/{id}')
			->uses('Merchant\Order\UpdateController@updateQuantity')
			->name('merchants.order.update.qty')
			->middleware('role:merchant_admin');
		//update status
		Route::get('/merchants/order/update/status/{id}')
			->uses('Merchant\Order\UpdateController@updateStatus')
			->name('merchants.order.update.status')
			->middleware('role:merchant_admin');

		// Merchant Customers
		Route::get('/merchants/customers')
			->uses('Merchant\Customer\ViewController@index')
			->name('merchants.customers')
			->middleware('role:merchant_admin');
		Route::get('/merchants/customers/list')
			->uses('Merchant\Customer\ViewController@customerList')
			->name('merchants.customers.list')
			->middleware('role:merchant_admin');
		Route::get('/merchants/customers/view/{id}')
			->uses('Merchant\Customer\ViewController@view')
			->name('merchants.customers.view')
			->middleware('role:merchant_admin');
		Route::get('/merchants/customers/transactions/{id}')
			->uses('Merchant\Customer\ViewController@transactions')
			->name('merchants.customers.transactions')
			->middleware('role:merchant_admin');

		// Merchant Products
		Route::get('/merchants/products')
			->uses('Merchant\Product\ViewController@index')
			->name('merchants.products')
			->middleware('role:super_admin|admin|accounting|merchant_admin');
		Route::get('/merchants/products/list')
			->uses('Merchant\Product\ViewController@productList')
			->name('merchants.products.list')
			->middleware('role:super_admin|admin|accounting|merchant_admin');

		Route::post('/merchants/products')
			->uses('Merchant\Product\CreateController@index')
			->name('merchants.products')
			->middleware('role:merchant_admin');

		Route::post('/merchants/products/update')
			->uses('Merchant\Product\UpdateController@index')
			->name('merchants.products.update')
			->middleware('role:super_admin');

		// Merchant Drivers
		Route::get('/merchants/drivers')
			->uses('Merchant\Driver\ViewController@index')
			->name('merchants.drivers')
			->middleware('role:super_admin|admin|merchant_admin');
		Route::get('/merchants/drivers/list')
			->uses('Merchant\Driver\ViewController@driverList')
			->name('merchants.drivers.list')
			->middleware('role:super_admin|admin|merchant_admin');
		Route::get('/merchants/drivers/add')
			->uses('Merchant\Driver\ViewController@add')
			->name('merchants.drivers.add')
			->middleware('role:super_admin|admin');
		Route::get('/merchants/drivers/edit/{id}')
			->uses('Merchant\Driver\ViewController@edit')
			->name('merchants.drivers.edit')
			->middleware('role:super_admin|admin');
		Route::get('/merchants/drivers/view/{id}')
			->uses('Merchant\Driver\ViewController@view')
			->name('merchants.drivers.view')
			->middleware('role:super_admin|admin');

		Route::post('/merchants/drivers/add')
			->uses('Merchant\Driver\CreateController@index')
			->name('merchants.drivers.add')
			->middleware('role:super_admin|admin');

		Route::post('/merchants/drivers/update/{id}')
			->uses('Merchant\Driver\UpdateController@index')
			->name('merchants.drivers.update')
			->middleware('role:super_admin|admin');
		Route::post('/merchants/drivers/status/{id}')
			->uses('Merchant\Driver\UpdateController@status')
			->name('merchants.drivers.status')
			->middleware('role:super_admin|admin');
		Route::post('/merchants/drivers/reset/{id}')
			->uses('Merchant\Driver\UpdateController@resetPassword')
			->name('merchants.drivers.reset')
			->middleware('role:super_admin|admin');

		// Merchant Vehicles Settings
		Route::get('/merchants/vehicles')
			->uses('Settings\MerchantVehicle\ViewController@index')
			->name('merchants.vehicles')
			->middleware('role:super_admin|merchant_admin');
		Route::get('/merchants/vehicles/list')
			->uses('Settings\MerchantVehicle\ViewController@merchantVehicleList')
			->name('merchants.vehicles.list')
			->middleware('role:super_admin|merchant_admin');
		Route::get('/merchants/vehicles/edit/{id}')
			->uses('Settings\MerchantVehicle\ViewController@edit')
			->name('merchants.vehicles.edit')
			->middleware('role:super_admin');

		Route::post('/merchants/vehicles')
			->uses('Settings\MerchantVehicle\CreateController@index')
			->name('merchants.vehicles')
			->middleware('role:super_admin');

		Route::post('/merchants/vehicles/update')
			->uses('Settings\MerchantVehicle\UpdateController@index')
			->name('merchants.vehicles.update')
			->middleware('role:super_admin');
		Route::post('/merchants/vehicles/status/{id}')
			->uses('Settings\MerchantVehicle\UpdateController@status')
			->name('merchants.vehicles.status')
			->middleware('role:super_admin');
		
		// Settings Product Category
		Route::get('/merchants/categories')
			->uses('Settings\MerchantProductCategory\ViewController@index')
			->name('merchants.categories')
			->middleware('role:merchant_admin');
		Route::get('/merchants/categories/list')
			->uses('Settings\MerchantProductCategory\ViewController@merchantCategoryList')
			->name('merchants.categories.list')
			->middleware('role:merchant_admin');
		Route::get('/merchants/categories/edit/{id}')
			->uses('Settings\MerchantProductCategory\ViewController@edit')
			->name('merchants.categories.edit')
			->middleware('role:merchant_admin');

		Route::post('/merchants/categories')
			->uses('Settings\MerchantProductCategory\CreateController@index')
			->name('merchants.categories')
			->middleware('role:merchant_admin');

		Route::post('/merchants/categories/update')
			->uses('Settings\MerchantProductCategory\UpdateController@index')
			->name('merchants.categories.update')
			->middleware('role:merchant_admin');
		Route::post('/merchants/categories/status/{id}')
			->uses('Settings\MerchantProductCategory\UpdateController@status')
			->name('merchants.categories.status')
			->middleware('role:merchant_admin');

		// Reports Merchant Product Sales
		Route::get('/reports/merchant/products')
			->uses('Report\MerchantProductSales\ViewController@index')
			->name('reports.merchant.products')
			->middleware('role:merchant_admin');
		Route::get('/reports/merchant/products/list')
			->uses('Report\MerchantProductSales\ViewController@productSaleList')
			->name('reports.merchant.products.list')
			->middleware('role:merchant_admin');
	});

	// Settings Merchant Establishment Schedule
	Route::get('/merchants/schedules')
		->uses('Settings\MerchantEstablishmentSchedule\ViewController@index')
		->name('merchants.schedules')
		->middleware('role:merchant_admin');
	Route::get('/merchants/schedules/list')
		->uses('Settings\MerchantEstablishmentSchedule\ViewController@merchantScheduleList')
		->name('merchants.schedules.list')
		->middleware('role:merchant_admin');
	Route::get('/merchants/schedules/add/{id}')
		->uses('Settings\MerchantEstablishmentSchedule\ViewController@add')
		->name('merchants.schedules.add')
		->middleware('role:merchant_admin');
	Route::get('/merchants/schedules/edit/{id}')
		->uses('Settings\MerchantEstablishmentSchedule\ViewController@edit')
		->name('merchants.schedules.edit')
		->middleware('role:merchant_admin');
	Route::get('/merchants/schedules/view/{id}')
		->uses('Settings\MerchantEstablishmentSchedule\ViewController@view')
		->name('merchants.schedules.view')
		->middleware('role:merchant_admin');

	Route::post('/merchants/schedules/add/{id}')
		->uses('Settings\MerchantEstablishmentSchedule\CreateController@index')
		->name('merchants.schedules.add')
		->middleware('role:merchant_admin');

	Route::post('/merchants/schedules/update/{id}')
		->uses('Settings\MerchantEstablishmentSchedule\UpdateController@index')
		->name('merchants.schedules.update')
		->middleware('role:merchant_admin');

	// Merchant Reviews
	Route::get('/merchants/reviews')
		->uses('Merchant\Review\ViewController@index')
		->name('merchants.reviews')
		->middleware('role:merchant_admin');
	Route::get('/merchants/reviews/list')
		->uses('Merchant\Review\ViewController@reviewList')
		->name('merchants.reviews.list')
		->middleware('role:merchant_admin');

	// Doctors Appointments
	Route::get('/doctors/appointments')
		->uses('Merchant\Doctor\Appointment\ViewController@index')
		->name('doctors.appointments')
		->middleware('role:doctor');
	Route::get('/doctors/appointments/list')
		->uses('Merchant\Doctor\Appointment\ViewController@doctorAppointmentList')
		->name('doctors.appointments.list')
		->middleware('role:doctor');
	Route::get('/doctors/appointments/view/{id}')
		->uses('Merchant\Doctor\Appointment\ViewController@view')
		->name('doctors.appointments.view')
		->middleware('role:doctor');

	Route::post('/doctors/appointments/update/{id}')
		->uses('Merchant\Doctor\Appointment\UpdateController@index')
		->name('doctors.appointments.update')
		->middleware('role:doctor');

	// Doctors Reviews
	Route::get('/doctors/patients')
		->uses('Merchant\Doctor\Patient\ViewController@index')
		->name('doctors.patients')
		->middleware('role:doctor');
	Route::get('/doctors/patients/list')
		->uses('Merchant\Doctor\Patient\ViewController@patientList')
		->name('doctors.patients.list')
		->middleware('role:doctor');

	// Doctors Reviews
	Route::get('/doctors/reviews')
		->uses('Merchant\Doctor\Review\ViewController@index')
		->name('doctors.reviews')
		->middleware('role:doctor');
	Route::get('/doctors/reviews/list')
		->uses('Merchant\Doctor\Review\ViewController@doctorReviewList')
		->name('doctors.reviews.list')
		->middleware('role:doctor');

	// Doctors Reports
	Route::get('/doctors/reports')
		->uses('Merchant\Doctor\Report\ViewController@index')
		->name('doctors.reports')
		->middleware('role:doctor');
	Route::get('/doctors/reports/list')
		->uses('Merchant\Doctor\Report\ViewController@doctorReportList')
		->name('doctors.reports.list')
		->middleware('role:doctor');

	// Merchant Settings
	Route::get('/merchants/settings/{id}')
		->uses('Merchant\Settings\ViewController@index')
		->name('merchants.settings')
		->middleware('role:super_admin|admin|merchant_admin');
	Route::get('/merchants/settings/list/{id}/{type?}')
		->uses('Merchant\Settings\ViewController@settingList')
		->name('merchants.settings.list')
		->middleware('role:super_admin|admin|merchant_admin');
	Route::get('/merchants/settings/view/{id}')
		->uses('Merchant\Settings\ViewController@view')
		->name('merchants.settings.view')
		->middleware('role:super_admin|admin|merchant_admin');
	Route::get('/merchants/settings/edit/{id}')
		->uses('Merchant\Settings\ViewController@edit')
		->name('merchants.settings.edit')
		->middleware('role:|merchant_admin');

	Route::get('/merchants/settings/points/{id}')
		->uses('Merchant\Settings\ViewController@getPointSettings')
		->name('merchants.settings.points')
		->middleware('role:super_admin|admin');

	Route::post('/merchants/settings/add/{id}')
		->uses('Merchant\Settings\CreateController@index')
		->name('merchants.settings.add')
		->middleware('role:super_admin|merchant_admin');
	Route::post('/merchants/settings/setuprebate/{id}')
		->uses('Merchant\Settings\CreateController@setupRebate')
		->name('merchants.settings.setuprebate')
		->middleware('role:super_admin');

	Route::post('/merchants/settings/update/{id}')
		->uses('Merchant\Settings\UpdateController@index')
		->name('merchants.settings.update')
		->middleware('role:merchant_admin');

	// Merchant Establishments
	Route::get('/merchants/establishments/{id}')
		->uses('Merchant\Establishment\ViewController@index')
		->name('merchants.establishments')
		->middleware('role:super_admin|admin|merchant_admin');
	Route::get('/merchants/establishments/list/{id}')
		->uses('Merchant\Establishment\ViewController@getMerchantEstablishments')
		->name('merchants.establishments.list')
		->middleware('role:super_admin|admin|merchant_admin');
	Route::get('/merchants/establishments/edit/{id}')
		->uses('Merchant\Establishment\ViewController@edit')
		->name('merchants.establishments.edit')
		->middleware('role:super_admin|admin|merchant_admin');

	Route::post('/merchants/establishments/{id}')
		->uses('Merchant\Establishment\CreateController@index')
		->name('merchants.establishments')
		->middleware('role:super_admin|admin|merchant_admin');

	Route::post('/merchants/establishments/update/{id}')
		->uses('Merchant\Establishment\UpdateController@index')
		->name('merchants.establishments.update')
		->middleware('role:super_admin|admin|merchant_admin');
		
	Route::post('/merchant/establishments/status/{id}')
			->uses('Merchant\Establishment\UpdateController@status')
			->name('merchant.establishments.status');

	// Members
	Route::get('/members')
		->uses('Member\ViewController@index')
		->name('members')
		->middleware('role:super_admin|admin|accounting|admin_cashier');
	Route::get('/members/list')
		->uses('Member\ViewController@memberList')
		->name('members.list')
		->middleware('role:super_admin|admin|accounting|admin_cashier');
	Route::get('/members/upgrade/{id}')
		->uses('Member\ViewController@upgradeMember')
		->name('members.upgrade')
		->middleware('role:super_admin|admin|accounting|admin_cashier|member');
	Route::get('/members/upgrademembership/{id}')
		->uses('Member\ViewController@upgradeMembership')
		->name('members.upgradeMembership')
		->middleware('role:super_admin|admin|accounting|admin_cashier|member');
	Route::get('/members/transactionlist')
		->uses('Member\ViewController@transactionList')
		->name('members.transactionlist')
		->middleware('role:super_admin|admin|accounting|admin_cashier');
	Route::get('/members/transactions/{id}')
		->uses('Member\ViewController@transactions')
		->name('members.transactions')
		->middleware('role:super_admin|admin|accounting|admin_cashier');
	Route::get('/members/qualified/list')
		->uses('Member\ViewController@memberQualifiedList')
		->name('members.qualified.list')
		->middleware('role:super_admin|admin|accounting|admin_cashier');
	Route::get('/members/add')
		->uses('Member\ViewController@add')
		->name('members.add')
		->middleware('role:super_admin|admin');
	Route::get('/members/edit/{id}')
		->uses('Member\ViewController@edit')
		->name('members.edit')
		->middleware('role:super_admin|admin');
	Route::get('/members/view/{id}')
		->uses('Member\ViewController@view')
		->name('members.view')
		->middleware('role:super_admin|admin|accounting|admin_cashier');

	Route::post('/members/add')
		->uses('Member\CreateController@index')
		->name('members.add')
		->middleware('role:super_admin|admin');
	Route::post('/members/send/referral')
		->uses('Member\CreateController@sendReferral')
		->name('members.send.referral')
		->middleware('role:super_admin|admin');

	Route::post('/members/update/{id}')
		->uses('Member\UpdateController@index')
		->name('members.update')
		->middleware('role:super_admin|admin');

	Route::post('/members/verify')
		->uses('Member\UpdateController@verify')
		->name('members.verify')
		->middleware('role:super_admin|admin|admin_cashier');

	// Affiliates
	Route::get('/affiliates')
		->uses('Affiliate\ViewController@index')
		->name('affiliates')
		->middleware('role:super_admin|admin');
	Route::get('/affiliates/group/list')
		->uses('Affiliate\ViewController@affiliateGroupList')
		->name('affiliates.group.list')
		->middleware('role:super_admin|admin');
	Route::get('/affiliates/individual/list')
		->uses('Affiliate\ViewController@affiliateIndividualList')
		->name('affiliates.individual.list')
		->middleware('role:super_admin|admin');
	Route::get('/affiliates/view/{id}')
		->uses('Affiliate\ViewController@view')
		->name('affiliates.view')
		->middleware('role:super_admin|admin');

	// Promos & Offers
	Route::get('/promos')
		->uses('Promo\ViewController@index')
		->name('promos')
		->middleware('role:super_admin|admin|accounting|merchant_admin');
	Route::get('/promos/list')
		->uses('Promo\ViewController@promoList')
		->name('promos.list')
		->middleware('role:super_admin|admin|accounting|merchant_admin');
	Route::get('/promos/members')
		->uses('Promo\ViewController@getMembers')
		->name('promos.members')
		->middleware('role:super_admin|admin|accounting|merchant_admin');
	Route::get('/promos/members/types')
		->uses('Promo\ViewController@getActiveMemberTypes')
		->name('promos.members.types')
		->middleware('role:super_admin|admin|accounting|merchant_admin');
		
	Route::post('/promos/update')
		->uses('Promo\UpdateController@index')
		->name('promos.update')
		->middleware('role:super_admin|admin');

	// Merchant Wallets
	Route::get('merchants/wallets')
		->uses('Merchant\Wallet\ViewController@index')
		->name('merchants.wallets')
		->middleware('role:super_admin|admin|accounting');
	Route::get('merchants/wallets/list')
		->uses('Merchant\Wallet\ViewController@walletList')
		->name('merchants.wallets.list')
		->middleware('role:super_admin|admin|accounting');
	Route::get('/wallets/settings/{id}')
		->uses('Merchant\Wallet\ViewController@settings')
		->name('merchants.wallets.settings')
		->middleware('role:super_admin|admin|accounting');
	Route::get('merchants/wallets/transactions/{id}')
		->uses('Merchant\Wallet\ViewController@walletTransactions')
		->name('merchants.wallets.transactions')
		->middleware('role:super_admin|admin|accounting');
	Route::get('merchants/wallets/transactions/list/{id}')
		->uses('Merchant\Wallet\ViewController@walletTransactionList')
		->name('merchants.wallets.transactions.list')
		->middleware('role:super_admin|admin|accounting');

	Route::post('merchants/wallets/settings/topUp/{id}')
		->uses('Merchant\Wallet\CreateController@index')
		->name('merchants.wallets.settings.topUp')
		->middleware('role:super_admin|admin|accounting');

	Route::post('merchants/wallets/settings/update')
		->uses('Merchant\Wallet\UpdateController@index')
		->name('merchants.wallets.settings.update')
		->middleware('role:super_admin|admin|accounting');

	// Reports Member Registration
	Route::get('/reports/members/registration')
		->uses('Report\MemberRegistration\ViewController@index')
		->name('reports.members.registration')
		->middleware('role:super_admin|admin|accounting');
	Route::get('/reports/members/registration/list')
		->uses('Report\MemberRegistration\ViewController@memberReportList')
		->name('reports.members.registration.list')
		->middleware('role:super_admin|admin|accounting');

	//Report Member Transaction
	Route::get('/reports/members/transaction')
		->uses('Report\MemberTransaction\ViewController@index')
		->name('reports.members.transaction')
		->middleware('role:super_admin|admin|accounting');
	Route::get('/reports/members/transaction/list')
		->uses('Report\MemberTransaction\ViewController@memberReportList')
		->name('reports.members.transaction.list')
		->middleware('role:super_admin|admin|accounting');
	Route::get('/reports/members/transaction/report')
		->uses('Report\MemberTransaction\ViewController@transactionReportList')
		->name('reports.members.transaction.report')
		->middleware('role:super_admin|admin|accounting');

	// Reports Merchant Transaction
	Route::get('/reports/merchants/transactions')
		->uses('Report\MerchantTransaction\ViewController@index')
		->name('reports.merchants.transactions')
		->middleware('role:super_admin|admin|accounting|merchant_admin');
	Route::get('/reports/merchants/transactions/list')
		->uses('Report\MerchantTransaction\ViewController@merchantTransactionList')
		->name('reports.merchants.transactions.list')
		->middleware('role:super_admin|admin|accounting|merchant_admin');
	Route::get('/reports/merchants/transactions/view/{id}')
		->uses('Report\MerchantTransaction\ViewController@view')
		->name('reports.merchants.transactions.view')
		->middleware('role:super_admin|admin|accounting|merchant_admin');

	// Reports Merchant Redemption
	Route::get('/reports/merchants/redemption')
		->uses('Report\MerchantRedemption\ViewController@index')
		->name('reports.merchants.redemption')
		->middleware('role:super_admin|admin|accounting|merchant_admin');
	Route::get('/reports/merchants/redemption/list')
		->uses('Report\MerchantRedemption\ViewController@merchantRedemptionList')
		->name('reports.merchants.redemption.list')
		->middleware('role:super_admin|admin|accounting|merchant_admin');

	// Reports Overall Transaction
	Route::get('/reports/overall/transactions')
		->uses('Report\OverallTransaction\ViewController@index')
		->name('reports.overall.transactions')
		->middleware('role:super_admin|admin|accounting');
	Route::get('/reports/overall/transactions/list')
		->uses('Report\OverallTransaction\ViewController@overallTransactionList')
		->name('reports.overall.transactions.list')
		->middleware('role:super_admin|admin|accounting');

	// All Settings
	Route::middleware(['role:super_admin|admin'])->group( function(){

		// Merchant AreaCodes Settings
		Route::get('/settings/merchant/areacodes')
			->uses('Settings\MerchantAreaCode\ViewController@index')
			->name('settings.merchant.areacodes');
		Route::get('/settings/merchant/areacodes/list')
			->uses('Settings\MerchantAreaCode\ViewController@areaCodeList')
			->name('settings.merchant.areacodes.list');
		Route::get('/settings/merchant/areacodes/edit/{id}')
			->uses('Settings\MerchantAreaCode\ViewController@edit')
			->name('settings.merchant.areacodes.edit');

		Route::post('/settings/merchant/areacodes')
			->uses('Settings\MerchantAreaCode\CreateController@index')
			->name('settings.merchant.areacodes');

		Route::post('/settings/merchant/areacodes/update')
			->uses('Settings\MerchantAreaCode\UpdateController@index')
			->name('settings.merchant.areacodes.update');
		Route::post('/settings/merchant/areacodes/status/{id}')
			->uses('Settings\MerchantAreaCode\UpdateController@status')
			->name('settings.merchant.areacodes.status');

		// Merchant Industry Types Settings
		Route::get('/settings/merchant/types')
			->uses('Settings\MerchantType\ViewController@index')
			->name('settings.merchant.types');
		Route::get('/settings/merchant/types/list')
			->uses('Settings\MerchantType\ViewController@merchantTypeList')
			->name('settings.merchant.types.list');
		Route::get('/settings/merchant/types/edit/{id}')
			->uses('Settings\MerchantType\ViewController@edit')
			->name('settings.merchant.types.edit');

		Route::post('/settings/merchant/types')
			->uses('Settings\MerchantType\CreateController@index')
			->name('settings.merchant.types');

		Route::post('/settings/merchant/types/update')
			->uses('Settings\MerchantType\UpdateController@index')
			->name('settings.merchant.types.update');
		Route::post('/settings/merchant/types/status/{id}')
			->uses('Settings\MerchantType\UpdateController@status')
			->name('settings.merchant.types.status');

		// Merchant Speciality Type Settings
		Route::get('/settings/merchant/specialities/types')
			->uses('Settings\MerchantSpecialityType\ViewController@index')
			->name('settings.merchant.specialities.types');
		Route::get('/settings/merchant/specialities/types/list')
			->uses('Settings\MerchantSpecialityType\ViewController@specialityTypeList')
			->name('settings.merchant.specialities.types.list');
		Route::get('/settings/merchant/specialities/types/edit/{id}')
			->uses('Settings\MerchantSpecialityType\ViewController@edit')
			->name('settings.merchant.specialities.types.edit');

		Route::post('/settings/merchant/specialities/types')
			->uses('Settings\MerchantSpecialityType\CreateController@index')
			->name('settings.merchant.specialities.types');

		Route::post('/settings/merchant/specialities/types/update')
			->uses('Settings\MerchantSpecialityType\UpdateController@index')
			->name('settings.merchant.specialities.types.update');
		Route::post('/settings/merchant/specialities/types/status/{id}')
			->uses('Settings\MerchantSpecialityType\UpdateController@status')
			->name('settings.merchant.specialities.types.status');
			
		// Merchant Speciality Settings
		Route::get('/settings/merchant/specialities')
			->uses('Settings\MerchantSpeciality\ViewController@index')
			->name('settings.merchant.specialities');
		Route::get('/settings/merchant/specialities/list')
			->uses('Settings\MerchantSpeciality\ViewController@specialityList')
			->name('settings.merchant.specialities.list');
		Route::get('/settings/merchant/specialities/edit/{id}')
			->uses('Settings\MerchantSpeciality\ViewController@edit')
			->name('settings.merchant.specialities.edit');

		Route::post('/settings/merchant/specialities')
			->uses('Settings\MerchantSpeciality\CreateController@index')
			->name('settings.merchant.specialities');

		Route::post('/settings/merchant/specialities/update')
			->uses('Settings\MerchantSpeciality\UpdateController@index')
			->name('settings.merchant.specialities.update');
		Route::post('/settings/merchant/specialities/status/{id}')
			->uses('Settings\MerchantSpeciality\UpdateController@status')
			->name('settings.merchant.specialities.status');

		// Merchant Establishment Settings
		Route::get('/settings/merchant/establishments')
			->uses('Settings\MerchantEstablishment\ViewController@index')
			->name('settings.merchant.establishments');
		Route::get('/settings/merchant/establishments/list')
			->uses('Settings\MerchantEstablishment\ViewController@establishmentList')
			->name('settings.merchant.establishments.list');
		Route::get('/settings/merchant/establishments/edit/{id}')
			->uses('Settings\MerchantEstablishment\ViewController@edit')
			->name('settings.merchant.establishments.edit');
		Route::get('/settings/merchant/establishments/get_merchants')
			->uses('Settings\MerchantEstablishment\ViewController@getMerchants')
			->name('settings.merchant.establishments.get_merchants');

		Route::post('/settings/merchant/establishments')
			->uses('Settings\MerchantEstablishment\CreateController@index')
			->name('settings.merchant.establishments');

		Route::post('/settings/merchant/establishments/update')
			->uses('Settings\MerchantEstablishment\UpdateController@index')
			->name('settings.merchant.establishments.update');
		Route::post('/settings/merchant/establishments/status/{id}')
			->uses('Settings\MerchantEstablishment\UpdateController@status')
			->name('settings.merchant.establishments.status');

		// Member AreaCodes Settings
		Route::get('/settings/member/areacodes')
			->uses('Settings\MemberAreaCode\ViewController@index')
			->name('settings.member.areacodes');
		Route::get('/settings/member/areacodes/list')
			->uses('Settings\MemberAreaCode\ViewController@areaCodeList')
			->name('settings.member.areacodes.list');
		Route::get('/settings/member/areacodes/edit/{id}')
			->uses('Settings\MemberAreaCode\ViewController@edit')
			->name('settings.member.areacodes.edit');

		Route::post('/settings/member/areacodes')
			->uses('Settings\MemberAreaCode\CreateController@index')
			->name('settings.member.areacodes');

		Route::post('/settings/member/areacodes/update')
			->uses('Settings\MemberAreaCode\UpdateController@index')
			->name('settings.member.areacodes.update');
		Route::post('/settings/member/areacodes/status/{id}')
			->uses('Settings\MemberAreaCode\UpdateController@status')
			->name('settings.member.areacodes.status');

		// Member Types Settings 
		Route::get('/settings/member/types')
			->uses('Settings\MemberType\ViewController@index')
			->name('settings.member.types');
		Route::get('/settings/member/types/list')
			->uses('Settings\MemberType\ViewController@memberTypeList')
			->name('settings.member.types.list');
		Route::get('/settings/member/types/edit/{id}')
			->uses('Settings\MemberType\ViewController@edit')
			->name('settings.member.types.edit');

		Route::post('/settings/member/types')
			->uses('Settings\MemberType\CreateController@index')
			->name('settings.member.types');

		Route::post('/settings/member/types/update')
			->uses('Settings\MemberType\UpdateController@index')
			->name('settings.member.types.update');
		Route::post('/settings/member/types/status/{id}')
			->uses('Settings\MemberType\UpdateController@status')
			->name('settings.member.types.status');

		// Admin Point Settings 
		Route::get('/admin/pointsettings')
			->uses('Settings\AdminPointSetting\ViewController@index')
			->name('admin.pointsettings');
		Route::get('/admin/pointsettings/list')
			->uses('Settings\AdminPointSetting\ViewController@adminPointList')
			->name('admin.pointsettings.list');
		Route::get('/admin/pointsettings/edit/{id}')
			->uses('Settings\AdminPointSetting\ViewController@edit')
			->name('admin.pointsettings.edit');

		Route::post('/admin/pointsettings')
			->uses('Settings\AdminPointSetting\CreateController@index')
			->name('admin.pointsettings');

		Route::post('/admin/pointsettings/update')
			->uses('Settings\AdminPointSetting\UpdateController@index')
			->name('admin.pointsettings.update');
		Route::post('/admin/pointsettings/status/{id}')
			->uses('Settings\AdminPointSetting\UpdateController@status')
			->name('admin.pointsettings.status');

		// Bayanihan Point Settings 
		Route::get('/bayanihan/pointsettings')
			->uses('Settings\BayanihanPointSetting\ViewController@index')
			->name('bayanihan.pointsettings');
		Route::get('/bayanihan/pointsettings/list')
			->uses('Settings\BayanihanPointSetting\ViewController@getBayanihanPoints')
			->name('bayanihan.pointsettings.list');
		Route::get('/bayanihan/pointsettings/edit/{id}')
			->uses('Settings\BayanihanPointSetting\ViewController@edit')
			->name('bayanihan.pointsettings.edit');

		Route::post('/bayanihan/pointsettings')
			->uses('Settings\BayanihanPointSetting\CreateController@index')
			->name('bayanihan.pointsettings');

		Route::post('/bayanihan/pointsettings/update')
			->uses('Settings\BayanihanPointSetting\UpdateController@index')
			->name('bayanihan.pointsettings.update');
		Route::post('/bayanihan/pointsettings/status/{id}')
			->uses('Settings\BayanihanPointSetting\UpdateController@status')
			->name('bayanihan.pointsettings.status');
	});
});

Route::prefix('/')->middleware(['auth','check.active'])->namespace('Bayanihan')->group( function(){
	
	Route::middleware(['auth.member'])->group( function(){
		// Bayanihan
		Route::get('/bayanihan/{id?}')
			->uses('Main\ViewController@index')
			->name('bayanihan');
		Route::get('/bayanihan/members/list/{id?}')
			->uses('Main\ViewController@getReferralList')
			->name('bayanihan.members.list');
		Route::get('/bayanihan/profile/view/{id?}')
			->uses('Main\ViewController@profile')
			->name('bayanihan.profile');
			
		Route::post('/bayanihan/profile/update')
			->uses('Main\UpdateController@index')
			->name('bayanihan.profile.update');
		Route::post('/bayanihan/profile/update/password')
			->uses('Main\UpdateController@changePassword')
			->name('bayanihan.profile.update.password');
	});

	Route::get('/bayanihan/complete/profile')
		->uses('Referral\ViewController@completeProfile')
		->name('bayanihan.complete.profile');

	Route::post('/bayanihan/complete/profile')
		->uses('Referral\CreateController@index')
		->name('bayanihan.complete.profile');
});


// Route::get('/import')
// 	->uses('ImportController@index')
// 	->name('import');

// Route::post('/import')
// 	->uses('ImportController@create')
// 	->name('import.start');

// Route::post('/import')
// 	->uses('ImportController@referral')
// 	->name('import.referral');
