<!DOCTYPE html>
<html dir="ltr" lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">
    <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests">

    <!-- Favicon icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="{{ asset('admin_dashboard/img/favicon.png')}}">
    <title>P-PLUS | @yield('title')</title>

    <link href="{{ asset('admin_dashboard/dist/css/style.min.css') }}" rel="stylesheet">
    <link href="{{ asset('admin_dashboard/assets/extra-libs/c3/c3.min.css') }}" rel="stylesheet">
    <link href="{{ asset('admin_dashboard/assets/extra-libs/jvector/jquery-jvectormap-2.0.2.css') }}" rel="stylesheet" />
    <link href="{{ asset('admin_dashboard/assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.css') }}" rel="stylesheet">
    <link href="{{ asset('admin_dashboard/assets/libs/select2/dist/css/select2.min.css') }}" rel="stylesheet">
    <link href="{{ asset('admin_dashboard/assets/libs/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css') }}" rel="stylesheet">
    <link href="{{ asset('admin_dashboard/assets/extra-libs/css-chart/css-chart.css') }}" rel="stylesheet">
    <link href="{{ asset('admin_dashboard/assets/libs/bootstrap-sweetalert/dist/sweetalert.min.css') }}" rel="stylesheet">
    <link href="{{ asset('admin_dashboard/assets/libs/dropify/dist/css/dropify.min.css') }}" rel="stylesheet">
    <link href="{{ asset('admin_dashboard/assets/libs/parsley/src/parsley.css') }}" rel="stylesheet" />
    <link href="{{ asset('admin_dashboard/style.css') }}" rel="stylesheet"> 

    <!-- <link href="{{ asset('admin_dashboard/assets/libs/bootstrap-material-datetimepicker/css/bootstrap-material-datetimepicker.css') }}" rel="stylesheet"> -->

    @yield('styles')

</head>

<body>
    
    <!-- Preloader - style you can find in spinners.css -->
    <div class="preloader">
        <div class="lds-ripple">
            <div class="lds-pos"></div>
            <div class="lds-pos"></div>
        </div>
    </div>
   
    <div id="main-wrapper">
        
        @include('dashboard.partials.nav')
        @include('dashboard.partials.sidebar')
        
        @yield('content')
        
    </div>
    
    <script src="{{ asset('admin_dashboard/assets/libs/jquery/dist/jquery.min.js') }}"></script>
    <!-- Bootstrap tether Core JavaScript -->
    <script src="{{ asset('admin_dashboard/assets/libs/popper.js/dist/umd/popper.min.js') }}"></script>
    <script src="{{ asset('admin_dashboard/assets/libs/bootstrap/dist/js/bootstrap.min.js') }}"></script>
    <!-- apps -->
    <script src="{{ asset('admin_dashboard/dist/js/app.min.js') }}"></script>
    <script src="{{ asset('admin_dashboard/dist/js/app.init.js') }}"></script>
    <script src="{{ asset('admin_dashboard/dist/js/app-style-switcher.js') }}"></script>
    <!-- slimscrollbar scrollbar JavaScript -->
    <script src="{{ asset('admin_dashboard/assets/libs/perfect-scrollbar/dist/perfect-scrollbar.jquery.min.js') }}"></script>
    <script src="{{ asset('admin_dashboard/assets/extra-libs/sparkline/sparkline.js') }}"></script>
    <!--Wave Effects -->
    <script src="{{ asset('admin_dashboard/dist/js/waves.js') }}"></script>
    <!--Menu sidebar -->
    <script src="{{ asset('admin_dashboard/dist/js/sidebarmenu.js') }}"></script>
    <!--Custom JavaScript -->
    <script src="{{ asset('admin_dashboard/dist/js/custom.js') }}"></script>
   <!-- Dropify -->
    <script  src="{{ asset('admin_dashboard/assets/libs/dropify/dist/js/dropify.min.js') }}"></script>
    <!-- Datatables -->
    <script src="{{ asset('admin_dashboard/assets/extra-libs/DataTables/datatables.min.js') }}"></script>
    <script src="{{ asset('admin_dashboard/dist/js/pages/datatable/datatable-basic.init.js') }} "></script>
    <!-- Select2 -->
    <script src="{{ asset('admin_dashboard/assets/libs/select2/dist/js/select2.full.min.js') }}"></script>
    <script src="{{ asset('admin_dashboard/assets/libs/select2/dist/js/select2.min.js') }}"></script>
    <script src="{{ asset('admin_dashboard/dist/js/pages/forms/select2/select2.init.js') }}"></script>
    <!-- Bootstrap Datepicker -->
    <script src="{{ asset('admin_dashboard/assets/libs/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js')}}"></script>
    <!-- Bootstrap Sweetalert -->
    <script src="{{ asset('admin_dashboard/assets/libs/bootstrap-sweetalert/dist/sweetalert.min.js') }}"></script>
    <!-- Parsley -->
    <script src="{{ asset('admin_dashboard/assets/libs/parsley/dist/parsley.min.js') }}"></script>
    <!-- Custom Validation -->
    <script src="{{ asset('admin_dashboard/dist/js/validation.js') }}"></script>
    <script src="{{ asset('admin_dashboard/custom.js') }}"></script>

    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBKmCY9-diuULK1hyHnDkElDSPT6mbfB7w&libraries=places" ></script>

    <!-- Bootstrap Material Datetimepicker -->
    <!-- <script src="{{ asset('admin_dashboard/assets/libs/moment/moment.js') }}"></script> -->
    <!-- <script src="{{ asset('admin_dashboard/assets/libs/bootstrap-material-datetimepicker/js/bootstrap-material-datetimepicker-custom.js') }}"></script> -->

    @if(session()->has('success'))
        <script>
            swal({
                title: "Good job!",
                text: "{!! session('success') !!}",
                type: "success",
                showConfirmButton: false,
                timer: 1500
            });
        </script>            
    @endif

    <?php Session::forget('sweet_alert'); ?>

    @stack('scripts')
    
</body>
</html>