@extends('layouts.admin')
@section('title','Industry Types')

@section('content')

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Industry Types</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('dashboard') }}">Home</a>
                                </li>
                                <li class="breadcrumb-item">Merchant Settings</li>
                                <li class="breadcrumb-item active" aria-current="page">Industry Types</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-6 col-12">
                    <h4 class="page-title mt-2">
                        <i class="mdi mdi-cart-plus"></i> 
                        List of Industry Types (<span id="count">0</span>)
                    </h4>                
                </div>
                <div class="col-lg-6 col-12 text-right">
                    <button class="btn btn-success" onclick="addMerchantType()">
                        <i class="fa fa-plus"></i> Add Industry Type
                    </button>       
                </div>
                <div class="col-12 mt-1">
                    <div class="card">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="merchantTypeTable" class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Industry Name</th>
                                            <th>Status</th>
                                            <th>Date/Time Created</th>
                                            <th width="10%">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- modal -->
        <div id="addMerchantTypeModal" class="modal" tabindex="-1" role="dialog" aria-labelledby="vcenter" aria-hidden="true" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <form method="POST">
                        @csrf
                        <div class="modal-header">
                            <h4 class="modal-title" id="vcenter">
                                <i class="mdi mdi-cart-plus"></i> Add Industry Type
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                        </div>
                        <div class="modal-body">
                            <div class="form-group">
                                <label class="control-label">Industry Name*</label>                                
                                <input type="text" class="form-control" name="name" id="name" placeholder="Enter industry name" required>
                                <input type="hidden" name="merchant_id" id="merchant_id">
                                <div class="invalid-feedback name"></div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger waves-effect" data-dismiss="modal">Cancel</button>
                            <button type="submit" id="save" class="btn btn-info waves-effect">
                                <i class="fa fa-save"></i> Save
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        @include('dashboard.partials.footer')
        
    </div>
    
@endsection

@push('scripts')
   <script type="text/javascript">
       
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        var table = $('#merchantTypeTable').DataTable({
            ajax: "{{ route('settings.merchant.types.list') }}",
            columns: [
                { data : 'DT_RowIndex' },
                { data : 'name' },
                { data : 'status' },
                { data : 'created_at' },
                { data : 'action', orderable: false, searchable: false}
            ],
            paging      : true,
            lengthChange: true,
            searching   : true,
            ordering    : false,
            info        : true,
            autoWidth   : false,
            dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                        "<'row'<'col-12'tr>>" +
                        "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
            fnDrawCallback: function () {
                self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                $('#count').text(self.QtdOcorrenciasAgendadosHoje);
            }
        });

          // Modal Add
        function addMerchantType() {
            $('#addMerchantTypeModal').modal('show');
            $('#save').removeAttr('disabled',true);
            $('#name').removeClass('is-invalid');
            $('.name').removeClass('invalid-feedback');
            $('.name').text('');
            $('#name').val('');

            $('#merchant_id').val('');

            var content = "<i class='mdi mdi-plus'></i> Add Merchant Type";
            $('#vcenter').html(content);
        }

        // Modal Edit
        $('body').on('click','#edit', function(e){
            e.preventDefault();

            $('#save').removeAttr('disabled',true);
            $('#name').removeClass('is-invalid');
            $('.name').removeClass('invalid-feedback');
            $('.name').text('');
            
            var content = "<i class='mdi mdi-table-edit'></i> Edit Merchant Type";
            $('#vcenter').html(content);

            var url = $(this).attr('href');

            $.ajax({
                type: "GET",
                url: url,
                success: function (response) {
                    $('#name').val(response.name);
                    $('#merchant_id').val(response.id);
                    $('#addMerchantTypeModal').modal('show');
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });

        // Form Add & Update
        $('form').submit( function(e){
            e.preventDefault();

            $('#save').attr('disabled',true);

            const merchant_id = $('#merchant_id').val();

            var url = merchant_id == '' ? '{{ route('settings.merchant.types') }}' : 
                                    '{{ route('settings.merchant.types.update') }}';

            var formData = $(this).serialize();

            $.ajax({
                type: "POST",
                url: url,
                data: formData,
                success: function (response) {
                    if (response.message == 'success') {
                        $('#save').removeAttr('disabled',true);
                        $('#addMerchantTypeModal').modal('hide');
                        $('#name').removeClass('is-invalid');
                        $('.name').removeClass('invalid-feedback');
                        $('.name').text('');
                        $('#name').val('');
        
                        table.ajax.reload();
                        swal({
                            title: "Success",
                            text: 'Merchant Type successfully',
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });
                        
                    } else {

                        $('#save').removeAttr('disabled',true);
                        $('#name').addClass('is-invalid');
                        $('.name').addClass('invalid-feedback');
                        $('.name').text(response.message.name);
                    }
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });

        // Status Activate or Deactivate
        $('body').on('click','#status', function(e){
            e.preventDefault();

            var url = $(this).attr('href');
            var status = $(this).data('status');

            swal({
                title: "Are you sure?",
                text: "Once you "+ status +", it will "+ status+" merchant type!",
                type: "warning",
                confirmButtonClass: status == 'Deactivate' ? 'btn-danger' : 'btn-success',
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: status,
                closeOnConfirm: false,
            },
            ()=>{
                $.ajax({
                    type: "POST",
                    url: url,
                    data: {
                        _token: "{{ csrf_token() }}"
                    },
                    success: function (response) {
                        table.ajax.reload();
                        swal({
                            title: status+"d!",
                            text: response.message,
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });
                    },
                    error: function (response) {
                        swal('Error!', response, 'danger');
                    }
                });
            });
        });

   </script>
@endpush