@extends('layouts.admin')
@section('title','Merchant Specialities')
@section('styles')
    <style type="text/css">
        #specialityTable tbody tr td:nth-child(1), 
        #specialityTable tbody tr td:nth-child(3), 
        #specialityTable tbody tr td:nth-child(4), 
        #specialityTable tbody tr td:nth-child(5){
            padding-top: 24px !important;
        }
        #specialityTable tbody tr td:nth-child(6){
            padding-top: 20px !important;
        }
    </style>
@endsection

@section('content')

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Specialities</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('dashboard') }}">Home</a>
                                </li>
                                <li class="breadcrumb-item">Merchant Settings</li>
                                <li class="breadcrumb-item active" aria-current="page">Specialities</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-6 col-12">
                    <h4 class="page-title mt-2">
                        <i class="mdi mdi-account-settings-variant"></i>
                        List of Specialities (<span id="count">0</span>)
                    </h4>                
                </div>
                <div class="col-lg-6 col-12 text-right">
                    <button class="btn btn-success" onclick="addSpeciality()">
                        <i class="fa fa-plus"></i> Add Speciality
                    </button>       
                </div>
                <div class="col-12 mt-1">
                    <div class="card">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="specialityTable" class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Name</th>
                                            <th>Descripion</th>
                                            <th>Type</th>
                                            <th>Status</th>
                                            <th width="10%">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- modal -->
        <div id="addSpecialityModal" class="modal" tabindex="-1" role="dialog" aria-labelledby="vcenter" aria-hidden="true" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <form id="add-speciality" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="modal-header">
                            <h4 class="modal-title" id="vcenter">
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                        </div>
                        <div class="modal-body">
                            <div class="form-group">
                                <label class="control-label">Image*</label>
                                <input type="file" class="form-control" name="image" id="image" required>
                            </div>
                            <div class="form-group">
                                <label class="control-label">Name*</label>
                                <input type="text" class="form-control" name="name" id="name" placeholder="Enter speciality name" required>
                                <input type="hidden" name="speciality_id" id="speciality_id">
                                <div class="invalid-feedback name"></div>
                            </div>
                            <div class="form-group">
                                <label class="control-label">Description*</label>
                                <input type="text" class="form-control" name="description" id="description" placeholder="Enter description" required>
                            </div>
                            <div class="form-group">
                                <label class="control-label">Speciality Type*</label>
                                <select class="form-control select" name="speciality_type_id" id="speciality_type_id" required>
                                    <option value="" selected disabled>Select Speciality Type</option>
                                    @foreach($speciality_types as $type)
                                        <option value="{{ $type->id }}">{{ $type->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger waves-effect" data-dismiss="modal">Cancel</button>
                            <button type="submit" id="save" class="btn btn-info waves-effect">
                                <i class="fa fa-save"></i> Save
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        @include('dashboard.partials.footer')
        
    </div>
    
@endsection

@push('scripts')
    <script type="text/javascript">
       
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        var table = $('#specialityTable').DataTable({
            ajax: "{{ route('settings.merchant.specialities.list') }}",
            columns: [
                { data : 'DT_RowIndex' },
                { data : 'name' },
                { data : 'description' },
                { data : 'speciality_type_name' },
                { data : 'status' },
                { data : 'action', orderable: false, searchable: false}
            ],
            paging      : true,
            lengthChange: true,
            searching   : true,
            ordering    : false,
            info        : true,
            autoWidth   : false,
            dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                        "<'row'<'col-12'tr>>" +
                        "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
            fnDrawCallback: function () {
                self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                $('#count').text(self.QtdOcorrenciasAgendadosHoje);
            }
        });

        // Modal Add
        function addSpeciality() {
            $('#addSpecialityModal').modal('show');
            $('#save').removeAttr('disabled',true);
            $('#image').attr('required',true);
            $('#name').removeClass('is-invalid');
            $('.name').removeClass('invalid-feedback');
            $('.name').text('');

            const token = $('input[name="_token"]').val();
            $('#addSpecialityModal :input').val('');
            $('#addSpecialityModal select').select2('');
            $('input[name="_token"]').val(token);

            select2();

            var content = "<i class='mdi mdi-plus'></i> Add Speciality";
            $('#vcenter').html(content);
        }

        // Modal Edit
        $('body').on('click','#edit', function(e){
            e.preventDefault();

            $('#save').removeAttr('disabled',true);
            $('#name').removeClass('is-invalid');
            $('.name').removeClass('invalid-feedback');
            $('.name').text('');
            $('#image').val('');
            $('#image').removeAttr('required',true);
            select2();

            var content = "<i class='mdi mdi-table-edit'></i> Edit Speciality";
            $('#vcenter').html(content);

            var url = $(this).attr('href');

            $.ajax({
                type: "GET",
                url: url,
                success: function (response) {
                    $('#name').val(response.name);
                    $('#description').val(response.description);
                    $('#speciality_id').val(response.id);

                    $('#speciality_type_id').empty();
                    $('#speciality_type_id').append('<option value="" selected disabled>Select Specialty Type</option>');
                    $.each(response.types, function(id, data) {
                        $('#speciality_type_id').append('<option value="'+ data.id +'" '+ ((response.speciality_type_id == data.id) ? 'selected' : '') +'>'+ data.name +'</option>'); 
                    });

                    $('#addSpecialityModal').modal('show');
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });

        // Form Add & Update
        $('form').submit( function(e){
            e.preventDefault();

            $('#save').attr('disabled',true);

            const speciality_id = $('#speciality_id').val();

            var url = speciality_id == '' ? '{{ route('settings.merchant.specialities') }}' : 
                                    '{{ route('settings.merchant.specialities.update') }}';

            let form = new FormData(this);

            $.ajax({
                url: url,
                type: 'POST',
                data: form,
                cache: false,
                contentType: false,
                processData: false,
                beforeSend: function(){
                   loadingAjaxPreloader();
                },
                success: function (response) {

                    if (response.message == 'success') {
                        
                        $('#save').removeAttr('disabled',true);
                        $('#addSpecialityModal').modal('hide');
                        $('#name').removeClass('is-invalid');
                        $('.name').removeClass('invalid-feedback');
                        $('.name').text('');

                        successAjaxPreloader();
                        table.ajax.reload();
                        swal({
                            title: "Success",
                            text: 'Speciality successfully',
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });
                        
                    } else {
                        successAjaxPreloader();
                        $('#save').removeAttr('disabled',true);
                        $('#name').addClass('is-invalid');
                        $('.name').addClass('invalid-feedback');
                        $('.name').text(response.message.name);
                    }
                },
                error: function(error){
                  console.log(error);
                },
            });
        });

        // Status Activate or Deactivate
        $('body').on('click','#status', function(e){
            e.preventDefault();

            var url = $(this).attr('href');
            var status = $(this).data('status');

            swal({
                title: "Are you sure?",
                text: "Once you "+ status +", it will "+ status+" speciality!",
                type: "warning",
                confirmButtonClass: status == 'Deactivate' ? 'btn-danger' : 'btn-success',
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: status,
                closeOnConfirm: false,
            },
            ()=>{
                $.ajax({
                    type: "POST",
                    url: url,
                    data: {
                        _token: "{{ csrf_token() }}"
                    },
                    success: function (response) {
                        table.ajax.reload();
                        swal({
                            title: status+"d!",
                            text: response.message,
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });
                    },
                    error: function (response) {
                        swal('Error!', response, 'danger');
                    }
                });
            });
        });

        function select2() {
           $('select.select').select2({
                dropdownParent: $('#addSpecialityModal'),
                width: '100%',
            });
        }

   </script>
@endpush