@extends('layouts.admin')
@section('title','Establishment Schedules')
@section('styles')
    <style type="text/css">
        #schedulesTable tbody tr td:nth-child(2), 
        #schedulesTable tbody tr td:nth-child(3){
            padding-top: 24px !important;
        }
        #schedulesTable tbody tr td:nth-child(4){
            padding-top: 20px !important;
        }
        .form-group{
            margin-bottom: .4rem;
        }
    </style>
@endsection

@section('content')

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Establishment Schedules</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('dashboard') }}">Home</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Establishment Schedules</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-6 col-12">
                    <h4 class="page-title mt-2">
                        <i class="mdi mdi-account-settings-variant"></i> 
                        List of Establishment Schedules (<span id="count">0</span>)
                    </h4>                
                </div>
                <div class="col-12 mt-1">
                    <div class="card">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="schedulesTable" class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th width="20%">Establishment Name</th>
                                            <th width="20%">Merchant Type</th>
                                            <th width="20%">Status</th>
                                            <th width="10%">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- view modal -->
        @include('dashboard.settings.merchant-schedules.partials.view-schedules-modal')

        @include('dashboard.partials.footer')
        
    </div>
    
@endsection

@push('scripts')
   <script type="text/javascript">
       
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        var table = $('#schedulesTable').DataTable({
            ajax: "{{ route('merchants.schedules.list') }}",
            columns: [
                { data : 'name' },
                { data : 'merchant_type' },
                { data : 'status' },
                { data : 'action', orderable: false, searchable: false}
            ],
            paging      : true,
            lengthChange: true,
            searching   : true,
            ordering    : false,
            info        : true,
            autoWidth   : false,
            dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                        "<'row'<'col-12'tr>>" +
                        "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
            fnDrawCallback: function () {
                self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                $('#count').text(self.QtdOcorrenciasAgendadosHoje);
            }
        });

        // view modal
        $('body').on('click', '#view', function(e){
            e.preventDefault();

            var url = $(this).attr('href');
            
            $.ajax({
                type: "GET",
                url: url,
                success: function (response) {

                    $('#image').attr('src',response.path);
                    $('#name').text(response.name);
                    $('#merchant_type').text(response.merchant_type);
                    $('#address').text(response.address);

                    $('#user_status').empty();
                    if (response.status == 1) {
                        $('#user_status').append('<i class="mdi mdi-checkbox-blank-circle text-success mr-2"></i> Active');
                    } else {
                        $('#user_status').append('<i class="mdi mdi-checkbox-blank-circle text-danger mr-2"></i> Not Active');
                    }
                    // daily schedules
                    const no_schedules = '<span class="text-danger">No Schedule</span>';
                    $('#monday').html(response.monday ? response.monday : no_schedules);
                    $('#tuesday').html(response.tuesday ? response.tuesday : no_schedules);
                    $('#wednesday').html(response.wednesday ? response.wednesday : no_schedules);
                    $('#thursday').html(response.thursday ? response.thursday : no_schedules);
                    $('#friday').html(response.friday ? response.friday : no_schedules);
                    $('#saturday').html(response.saturday ? response.saturday : no_schedules);
                    $('#sunday').html(response.sunday ? response.sunday : no_schedules);
                    $('#viewScheduleModal').modal('show');
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });

   </script>
@endpush