@extends('layouts.admin')
@section('title','Add Schedule')

@section('content')

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Add Schedule</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('dashboard') }}">Home</a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="{{ route('merchants.schedules') }}">Establishment Schedules</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Add Schedule</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-9 col-12">
                    <div class="card">
                        <div class="card-body">
                            <form method="POST" action="{{ route('merchants.schedules.add', base64_encode($establishment->id) ) }}">
                                @csrf
                                <div class="row">
                                    <div class="col-12">
                                        <label class="control-label">Monday</label>                                
                                    </div>
                                    <div class="col-lg-6 col-12">
                                        <div class="row form-group">
                                            <div class="col-12">
                                                <label class="control-label font-weight-light">(5AM - 12PM)</label>
                                            </div>
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="monday[]">
                                            </div> 
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="monday[]">
                                            </div>   
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-12">
                                        <div class="row form-group">
                                            <div class="col-12">
                                                <label class="control-label font-weight-light">(1PM - 10:00PM)</label>
                                            </div>
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="monday[]">
                                            </div> 
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="monday[]">
                                            </div>   
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12">
                                        <label class="control-label">Tuesday</label>                                
                                    </div>
                                    <div class="col-lg-6 col-12">
                                        <div class="row form-group">
                                            <div class="col-12">
                                                <label class="control-label font-weight-light">(5AM - 12PM)</label>
                                            </div>
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="tuesday[]">
                                            </div> 
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="tuesday[]">
                                            </div>   
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-12">
                                        <div class="row form-group">
                                            <div class="col-12">
                                                <label class="control-label font-weight-light">(1PM - 10:00PM)</label>
                                            </div>
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="tuesday[]">
                                            </div> 
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="tuesday[]">
                                            </div>   
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12">
                                        <label class="control-label">Wednesday</label>                                
                                    </div>
                                    <div class="col-lg-6 col-12">
                                        <div class="row form-group">
                                            <div class="col-12">
                                                <label class="control-label font-weight-light">(5AM - 12PM)</label>
                                            </div>
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="wednesday[]">
                                            </div> 
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="wednesday[]">
                                            </div>   
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-12">
                                        <div class="row form-group">
                                            <div class="col-12">
                                                <label class="control-label font-weight-light">(1PM - 10:00PM)</label>
                                            </div>
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="wednesday[]">
                                            </div> 
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="wednesday[]">
                                            </div>   
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12">
                                        <label class="control-label">Thursday</label>                                
                                    </div>
                                    <div class="col-lg-6 col-12">
                                        <div class="row form-group">
                                            <div class="col-12">
                                                <label class="control-label font-weight-light">(5AM - 12PM)</label>
                                            </div>
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="thursday[]">
                                            </div> 
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="thursday[]">
                                            </div>   
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-12">
                                        <div class="row form-group">
                                            <div class="col-12">
                                                <label class="control-label font-weight-light">(1PM - 10:00PM)</label>
                                            </div>
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="thursday[]">
                                            </div> 
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="thursday[]">
                                            </div>   
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12">
                                        <label class="control-label">Friday</label>                                
                                    </div>
                                    <div class="col-lg-6 col-12">
                                        <div class="row form-group">
                                            <div class="col-12">
                                                <label class="control-label font-weight-light">(5AM - 12PM)</label>
                                            </div>
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="friday[]">
                                            </div> 
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="friday[]">
                                            </div>   
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-12">
                                        <div class="row form-group">
                                            <div class="col-12">
                                                <label class="control-label font-weight-light">(1PM - 10:00PM)</label>
                                            </div>
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="friday[]">
                                            </div> 
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="friday[]">
                                            </div>   
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12">
                                        <label class="control-label">Saturday</label>                                
                                    </div>
                                    <div class="col-lg-6 col-12">
                                        <div class="row form-group">
                                            <div class="col-12">
                                                <label class="control-label font-weight-light">(5AM - 12PM)</label>
                                            </div>
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="saturday[]">
                                            </div> 
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="saturday[]">
                                            </div>   
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-12">
                                        <div class="row form-group">
                                            <div class="col-12">
                                                <label class="control-label font-weight-light">(1PM - 10:00PM)</label>
                                            </div>
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="saturday[]">
                                            </div> 
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="saturday[]">
                                            </div>   
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12">
                                        <label class="control-label">Sunday</label>                                
                                    </div>
                                    <div class="col-lg-6 col-12">
                                        <div class="row form-group">
                                            <div class="col-12">
                                                <label class="control-label font-weight-light">(5AM - 12PM)</label>
                                            </div>
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="sunday[]">
                                            </div> 
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="sunday[]">
                                            </div>   
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-12">
                                        <div class="row form-group">
                                            <div class="col-12">
                                                <label class="control-label font-weight-light">(1PM - 10:00PM)</label>
                                            </div>
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="sunday[]">
                                            </div> 
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="sunday[]">
                                            </div>   
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12 form-group text-right">
                                        <a href="{{ route('merchants.schedules') }}">
                                            <button type="button" class="btn btn-danger">
                                                <i class="mdi mdi-close-circle"></i> Cancel
                                            </button>
                                        </a>
                                        <button type="submit" class="btn btn-info">
                                            <i class="fa fa-save"></i> Save
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-12">
                    <div class="card">
                        <div class="card-body text-center">
                            <div class="m-b-10 m-t-20">
                                <img src="{{ $establishment->path }}" width="140" class="rounded-circle" alt="establishment" />
                                <h6 class="m-t-20 mb-2">{{ $establishment->name }}</h6>
                                <h6 class="text-muted">({{ $establishment->merchant_type }})</h6>
                            </div>
                        </div>
                        <div class="p-25 border-top">
                            <small class="text-muted">Description</small>
                            <h6>{{ $establishment->description }}</h6>
                            <small class="text-muted">Address</small>
                            <h6>{{ $establishment->address }}</h6>
                            <div class="map-box">
                                <iframe src="https://maps.google.com/maps?q={{ $establishment->address }}&t=&z=13&ie=UTF8&iwloc=&output=embed" width="100%" height="150" frameborder="0" style="border:0" allowfullscreen></iframe>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @include('dashboard.partials.footer')
        
    </div>
    
@endsection