@extends('layouts.admin')
@section('title','Area Codes')

@section('content')

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Area Codes</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('dashboard') }}">Home</a>
                                </li>
                                <li class="breadcrumb-item">Member Settings</li>
                                <li class="breadcrumb-item active" aria-current="page">Area Codes</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-6 col-12">
                    <h4 class="page-title mt-2">
                        <i class="mdi mdi-account-settings-variant"></i>
                        List of Area Codes (<span id="count">0</span>)
                    </h4>                
                </div>
                <div class="col-lg-6 col-12 text-right">
                    <button class="btn btn-success" onclick="addAreaCode()">
                        <i class="fa fa-plus"></i> Add Area Code
                    </button>       
                </div>
                <div class="col-12 mt-1">
                    <div class="card">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="areaCodeTable" class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Area Name</th>
                                            <th>Area Code</th>
                                            <th>Status</th>
                                            <th>Date/Time Created</th>
                                            <th width="10%">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal Add-->
        <div id="addAreaCodeModal" class="modal" tabindex="-1" role="dialog" aria-labelledby="vcenter" aria-hidden="true" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <form method="POST">
                        @csrf
                        <div class="modal-header">
                            <h4 class="modal-title" id="vcenter">
                                
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                        </div>
                        <div class="modal-body">
                            <div class="form-group">
                                <label class="control-label">Area Name/City*</label>
                                <input type="text" class="form-control" name="area_name" id="area_name" placeholder="Ex. Cebu City" required>
                                <input type="hidden" name="area_id" id="area_id">
                                <div class="invalid-feedback area_name"></div>
                            </div>
                            <div class="form-group">
                                <label class="control-label">Area Code*</label>
                                <input type="text" class="form-control" name="area_code" id="area_code" placeholder="Ex. CEB" required>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger waves-effect" data-dismiss="modal">Cancel</button>
                            <button type="submit" id="save" class="btn btn-info waves-effect">
                                <i class="fa fa-save"></i> Save
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        @include('dashboard.partials.footer')
        
    </div>
    
@endsection

@push('scripts')
    <script type="text/javascript">
        
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        var table = $('#areaCodeTable').DataTable({
            ajax: "{{ route('settings.member.areacodes.list') }}",
            columns: [
                { data : 'DT_RowIndex' },
                { data : 'area_name' },
                { data : 'area_code' },
                { data : 'status' },
                { data : 'created_at' },
                { data : 'action', orderable: false, searchable: false}
            ],
            paging      : true,
            lengthChange: true,
            searching   : true,
            ordering    : false,
            info        : true,
            autoWidth   : false,
            dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                        "<'row'<'col-12'tr>>" +
                        "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
            fnDrawCallback: function () {
                self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                $('#count').text(self.QtdOcorrenciasAgendadosHoje);
            }
        });

        // Modal Add
        function addAreaCode() {
            $('#addAreaCodeModal').modal('show');
            $('#save').removeAttr('disabled',true);
            $('#area_name').removeClass('is-invalid');
            $('.area_name').removeClass('invalid-feedback');
            $('.area_name').text('');
            $('#area_name').val('');
            $('#area_code').val('');

            $('#area_id').val('');

            var content = "<i class='mdi mdi-plus'></i> Add Area Code";
            $('#vcenter').html(content);
        }

        // Modal Edit
        $('body').on('click','#edit', function(e){
            e.preventDefault();

            $('#save').removeAttr('disabled',true);
            $('#area_name').removeClass('is-invalid');
            $('.area_name').removeClass('invalid-feedback');
            $('.area_name').text('');
            
            var content = "<i class='mdi mdi-table-edit'></i> Edit Area Code";
            $('#vcenter').html(content);

            var url = $(this).attr('href');

            $.ajax({
                type: "GET",
                url: url,
                success: function (response) {
                    $('#area_name').val(response.area_name);
                    $('#area_code').val(response.area_code);
                    $('#area_id').val(response.id);
                    $('#addAreaCodeModal').modal('show');
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });

        // Form Add & Update
        $('form').submit( function(e){
            e.preventDefault();

            $('#save').attr('disabled',true);

            const area_id = $('#area_id').val();

            var url = area_id == '' ? '{{ route('settings.member.areacodes') }}' : 
                                    '{{ route('settings.member.areacodes.update') }}';

            var formData = $(this).serialize();

            $.ajax({
                type: "POST",
                url: url,
                data: formData,
                success: function (response) {

                    if (response.message == 'success') {
                        $('#save').removeAttr('disabled',true);
                        $('#addAreaCodeModal').modal('hide');
                        $('#area_name').removeClass('is-invalid');
                        $('.area_name').removeClass('invalid-feedback');
                        $('.area_name').text('');
                        $('#area_name').val('');
                        $('#area_code').val('');

                        table.ajax.reload();
                        swal({
                            title: "Success",
                            text: 'Area code successfully',
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });
                        
                    } else {

                        $('#save').removeAttr('disabled',true);
                        $('#area_name').addClass('is-invalid');
                        $('.area_name').addClass('invalid-feedback');
                        $('.area_name').text(response.message.area_name);
                    }
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });

        // Status Activate or Deactivate
        $('body').on('click','#status', function(e){
            e.preventDefault();

            var url = $(this).attr('href');
            var status = $(this).data('status');

            swal({
                title: "Are you sure?",
                text: "Once you "+ status +", it will "+ status+" area code!",
                type: "warning",
                confirmButtonClass: status == 'Deactivate' ? 'btn-danger' : 'btn-success',
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: status,
                closeOnConfirm: false,
            },
            ()=>{
                $.ajax({
                    type: "POST",
                    url: url,
                    data: {
                        _token: "{{ csrf_token() }}"
                    },
                    success: function (response) {
                        table.ajax.reload();
                        swal({
                            title: status+"d!",
                            text: response.message,
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });
                    },
                    error: function (response) {
                        swal('Error!', response, 'danger');
                    }
                });
            });
        });

   </script>
@endpush