@extends('layouts.admin')
@section('title','Admin Point Settings')

@section('content')

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Admin Point Settings</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('dashboard') }}">Home</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Admin Point Settings</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-6 col-12">
                    <h4 class="page-title mt-2">
                        <i class="mdi mdi-account-settings-variant"></i>
                        List of Admin Point Settings (<span id="count">0</span>)
                    </h4>                
                </div>
                <div class="col-lg-6 col-12 text-right">
                    <button class="btn btn-success" onclick="addMemberType()">
                        <i class="fa fa-plus"></i> Add Point Setting
                    </button>       
                </div>
                <div class="col-12 mt-1">
                    <div class="card">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="memberTypeTable" class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Qualified Points</th>
                                            <th>Status</th>
                                            <th>Date/Time Created</th>
                                            <th width="10%">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- modal -->
        <div id="addPointSettingModal" class="modal" tabindex="-1" role="dialog" aria-labelledby="vcenter" aria-hidden="true" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <form method="POST">
                        @csrf
                        <div class="modal-header">
                            <h4 class="modal-title" id="vcenter">
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                        </div>
                        <div class="modal-body">
                            <div class="form-group">
                                <label class="control-label">Qualified Points*</label>
                                <input type="text" class="form-control number-with-decimal" name="qualified_points" id="qualified_points" placeholder="Enter qualified points" required>
                                <input type="hidden" name="admin_id" id="admin_id">
                                <div class="invalid-feedback qualified_points"></div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger waves-effect" data-dismiss="modal">Cancel</button>
                            <button type="submit" id="save" class="btn btn-info waves-effect">
                                <i class="fa fa-save"></i> Save
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        @include('dashboard.partials.footer')
        
    </div>
    
@endsection

@push('scripts')
    <script type="text/javascript">
       
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        var table = $('#memberTypeTable').DataTable({
            ajax: "{{ route('admin.pointsettings.list') }}",
            columns: [
                { data : 'DT_RowIndex' },
                { data : 'qualified_points' },
                { data : 'status' },
                { data : 'created_at' },
                { data : 'action', orderable: false, searchable: false}
            ],
            paging      : true,
            lengthChange: true,
            searching   : true,
            ordering    : false,
            info        : true,
            autoWidth   : false,
            dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                        "<'row'<'col-12'tr>>" +
                        "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
            fnDrawCallback: function () {
                self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                $('#count').text(self.QtdOcorrenciasAgendadosHoje);
            }
        });

         // Modal Add
        function addMemberType() {
            $('#addPointSettingModal').modal('show');
            $('#save').removeAttr('disabled',true);
            $('#qualified_points').removeClass('is-invalid');
            $('.qualified_points').removeClass('invalid-feedback');
            $('.qualified_points').text('');
            $('#qualified_points').val('');

            $('#admin_id').val('');

            var content = "<i class='mdi mdi-plus'></i> Add Point Setting";
            $('#vcenter').html(content);
        }

        // Modal Edit
        $('body').on('click','#edit', function(e){
            e.preventDefault();

            $('#save').removeAttr('disabled',true);
            $('#qualified_points').removeClass('is-invalid');
            $('.qualified_points').removeClass('invalid-feedback');
            $('.qualified_points').text('');
            
            var content = "<i class='mdi mdi-table-edit'></i> Edit Point Setting";
            $('#vcenter').html(content);

            var url = $(this).attr('href');

            $.ajax({
                type: "GET",
                url: url,
                success: function (response) {
                    $('#qualified_points').val(response.qualified_points);
                    $('#admin_id').val(response.id);
                    $('#addPointSettingModal').modal('show');
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });

        // Form Add & Update
        $('form').submit( function(e){
            e.preventDefault();

            $('#save').attr('disabled',true);

            const admin_id = $('#admin_id').val();

            var url = admin_id == '' ? '{{ route('admin.pointsettings') }}' : 
                                    '{{ route('admin.pointsettings.update') }}';

            var formData = $(this).serialize();

            $.ajax({
                type: "POST",
                url: url,
                data: formData,
                success: function (response) {

                    if (response.message == 'success') {
                        $('#save').removeAttr('disabled',true);
                        $('#addPointSettingModal').modal('hide');
                        $('#qualified_points').removeClass('is-invalid');
                        $('.qualified_points').removeClass('invalid-feedback');
                        $('.qualified_points').text('');
                        $('#qualified_points').val('');
        
                        table.ajax.reload();
                        swal({
                            title: "Success",
                            text: 'Point Setting successfully',
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });
                    } else {
                        $('#save').removeAttr('disabled',true);
                        $('#qualified_points').addClass('is-invalid');
                        $('.qualified_points').addClass('invalid-feedback');
                        $('.qualified_points').text(response.message.qualified_points);
                    }
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });

         // Status Activate or Deactivate
        $('body').on('click','#status', function(e){
            e.preventDefault();

            var url = $(this).attr('href');

            swal({
                title: "Are you sure?",
                text: "Once you Activate, it will Activate qualified points!",
                type: "warning",
                confirmButtonClass: 'btn-success',
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: 'Activate',
                closeOnConfirm: false,
            },
            ()=>{
                $.ajax({
                    type: "POST",
                    url: url,
                    data: {
                        _token: "{{ csrf_token() }}"
                    },
                    success: function (response) {
                        table.ajax.reload();
                        swal({
                            title: "Activated!",
                            text: response.message,
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });
                    },
                    error: function (response) {
                        swal('Error!', response, 'danger');
                    }
                });
            });
        });

   </script>
@endpush