@extends('layouts.admin')
@section('title','Overall Transactions Report')
@section('styles')
    <link rel="stylesheet" type="text/css" href="{{ asset('admin_dashboard/assets/libs/daterangepicker/daterangepicker.css') }}">
    <style type="text/css">
        #overallTransactionTable tbody tr td:nth-child(2), 
        #overallTransactionTable tbody tr td:nth-child(3), 
        #overallTransactionTable tbody tr td:nth-child(4), 
        #overallTransactionTable tbody tr td:nth-child(5), 
        #overallTransactionTable tbody tr td:nth-child(6){
            padding-top: 24px !important;
        }
        h6.text-uppercase{
            font-weight: 500
        }
        h4.font-light{
            font-weight: 400 !important;
        }
        .card-body.shadow{
            height: 142px;
        }
    </style>
@endsection

@section('content')

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Overall Transactions Report</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('dashboard') }}">Home</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Overall Transactions Report</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-3 col-12">
                    <div class="card">
                        <div class="card-body shadow">
                            <div class="row p-t-10 p-b-10">
                                <div class="col p-r-0">
                                    <div class="round align-self-center round-success mt-3">
                                        <i class="mdi mdi-wrench mdi-24px"></i>
                                    </div>
                                </div>
                                <div class="col text-right align-self-center">
                                    <h4 class="font-light" id="system">0</h4>
                                    <h6 class="text-muted">Total System & Maintenance</h6>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-12">
                    <div class="card">
                        <div class="card-body shadow">
                            <div class="row p-t-10 p-b-10">
                                <div class="col p-r-0">
                                    <div class="round align-self-center round-success mt-3">
                                        <i class="mdi mdi-briefcase mdi-24px"></i>
                                    </div>
                                </div>
                                <div class="col text-right align-self-center">
                                    <h4 class="font-light" id="advocacy">0</h4>
                                    <h6 class="text-muted pb-3">Total Advocacy</h6>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-12">
                    <div class="card">
                        <div class="card-body shadow">
                            <div class="row p-t-10 p-b-10">
                                <div class="col p-r-0">
                                    <div class="round align-self-center round-success mt-3">
                                        <i class="mdi mdi-wallet-giftcard mdi-24px"></i>
                                    </div>
                                </div>
                                <div class="col text-right align-self-center">
                                    <h4 class="font-light" id="points">0</h4>
                                    <h6 class="text-muted">Total Members Earned Pts.</h6>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-12">
                    <div class="card">
                        <div class="card-body shadow">
                            <div class="row p-t-10 p-b-10">
                                <div class="col p-r-0">
                                    <div class="round align-self-center round-success mt-3">
                                        <i class="mdi mdi-credit-card-multiple mdi-24px"></i>
                                    </div>
                                </div>
                                <div class="col text-right align-self-center">
                                    <h4 class="font-light" id="pointAsPayment">0</h4>
                                    <h6 class="text-muted">Total Pts. as Payment</h6>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-10 col-12">
                    <h4 class="page-title mt-2">
                        <i class="mdi mdi-file-document"></i>
                        List of Overall Transactions Report (<span id="count">0</span>)
                    </h4>                
                </div>
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12">
                                    <form method="get">
                                        <div class="row">
                                            <div class="col-lg-3 col-12">
                                                <h6 class="text-uppercase">Select Date Range :</h6>
                                                <input type="text" name="date" class="form-control" id="daterangepicker">
                                            </div>
                                            <div class="col-lg-4 col-12">
                                                <button class="btn btn-info mt-4 mr-1" type="submit">
                                                    <i class="mdi mdi-filter"></i> Filter
                                                </button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <div class="col-12 mt-4">
                                    <div class="table-responsive">
                                        <table id="overallTransactionTable" class="table table-hover">
                                            <thead>
                                                <tr>
                                                    <th>Merchant</th>
                                                    <th><strong>Total Rebate</strong></th>
                                                    <th>System & Maintenance</th>
                                                    <th>Advocacy</th>
                                                    <th>Members Earned Pts.</th>
                                                    <th>Upline Earned Pts.</th>
                                                    <th>Pts. as Payment</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                        
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @include('dashboard.partials.footer')
        
    </div>
    
@endsection

@push('scripts')
    <!-- start - This is for export functionality only -->
    <script src="https://cdn.datatables.net/buttons/1.5.1/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.5.1/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.5.1/js/buttons.print.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/plug-ins/1.10.21/api/sum().js"></script>

    <script src="{{ asset('admin_dashboard/assets/libs/moment/moment.js') }}"></script>
    <script src="{{ asset('admin_dashboard/assets/libs/daterangepicker/daterangepicker.js')}}"></script>
    <script type="text/javascript">
        $(document).ready( function(){
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            initialize();

            function initialize(formData){
                var url = "{{ route('reports.overall.transactions.list') }}";
                url = (formData != null) ? url + "?" + formData : url;
                $('#overallTransactionTable').DataTable({
                    ajax: url,
                    columns: [
                        { data : 'merchant_name' },
                        { data : 'rebate' },
                        { data : 'system' },
                        { data : 'advocacy' },
                        { data : 'points' },
                        { data : 'upline' },
                        { data : 'pointAsPayment' },
                    ],
                    paging      : true,
                    lengthChange: true,
                    searching   : true,
                    ordering    : false,
                    info        : true,
                    autoWidth   : false,
                    destroy     : true,
                    buttons     : ['csv', 'excel', 'print'],
                    dom         : "<'row'<'col-lg-6 col-12' @role('super_admin') B @endrole><'col-lg-6 col-12'f>>" +
                            "<'row'<'col-12'tr>>" +
                            "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
                    fnDrawCallback: function () {
                        self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                        $('#count').text(self.QtdOcorrenciasAgendadosHoje);

                        var api = this.api();
                        $('#system').text(numberFormat(api.column(2).data().sum()));
                        $('#advocacy').text(numberFormat(api.column(3).data().sum()));
                        $('#points').text(numberFormat(api.column(4).data().sum()));
                        $('#pointAsPayment').text(numberFormat(api.column(6).data().sum()));

                        if (self.QtdOcorrenciasAgendadosHoje < 1)  {
                            $('.dt-buttons').addClass('d-none');
                        } else {
                            $('.dt-buttons').removeClass('d-none');
                        }
                    }
                });

                $('.buttons-csv, .buttons-print, .buttons-excel').addClass('btn btn-success mr-1');
            }

            // Form Get Submit
            $('form').submit( function(e){
                e.preventDefault();
                var formData = $(this).serialize();

                initialize(formData);
            });

           // Custom Date Range
            var date = $('#daterangepicker').daterangepicker({
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                },
                alwaysShowCalendars: true,
                drops: "down",
                buttonClasses: "btn",
                applyClass: "btn-info",
                cancelClass: "btn-danger",
            });

            // amount number format
            function numberFormat(num) {
                return num.toFixed(2).replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1,')
            }
        });
    </script>
@endpush