@extends('layouts.admin')
@section('title','Members Registration Report')
@section('styles')
    <link rel="stylesheet" type="text/css" href="{{ asset('admin_dashboard/assets/libs/daterangepicker/daterangepicker.css') }}">
    <style type="text/css">
        #memberReportTable tbody tr td:nth-child(1), 
        #memberReportTable tbody tr td:nth-child(3), 
        #memberReportTable tbody tr td:nth-child(4), 
        #memberReportTable tbody tr td:nth-child(5), 
        #memberReportTable tbody tr td:nth-child(6){
            padding-top: 24px !important;
        }
        h6{
            font-weight: 500
        }
    </style>
@endsection

@section('content')

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Members Registration Report</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('dashboard') }}">Home</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Members Registration Report</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-10 col-12">
                    <h4 class="page-title mt-2">
                        <i class="mdi mdi-account-multiple"></i>
                        List of Members Registration Report (<span id="count">0</span>)
                    </h4>                
                </div>
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                @role('super_admin|accounting|admin')
                                    <div class="col-12">
                                        <form method="get">
                                            <div class="row">
                                                <div class="col-lg-3 col-12">
                                                    <h6 class="text-uppercase">Date Range :</h6>
                                                    <input type="text" name="date" class="form-control" id="daterangepicker">
                                                </div>
                                                <div class="col-lg-3 col-12">
                                                    <h6 class="text-uppercase">Member Status :</h6>
                                                    <select class="form-control" name="status" id="status">
                                                        <option value="all">All</option>
                                                        <option value="verified">Verified</option>
                                                        <option value="unverified">Not Verified</option>
                                                    </select>
                                                </div>
                                                <div class="col-lg-4 col-12">
                                                    <button class="btn btn-info mt-4 mr-1" type="submit">
                                                        <i class="mdi mdi-filter"></i> Filter
                                                    </button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                @endrole
                                <div class="col-12 @role('super_admin|accounting') mt-4 @endrole">
                                    <div class="table-responsive">
                                        <table id="memberReportTable" class="table table-hover">
                                            <thead>
                                                <tr>
                                                    <th>Member ID</th>
                                                    <th>Name</th>
                                                    <th>Member Type</th>
                                                    <th>Registration Status</th>
                                                    <th>Date Registered</th>
                                                    <th>Date Expiration</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @include('dashboard.partials.footer')
        
    </div>
    
@endsection

@push('scripts')
    <!-- start - This is for export functionality only -->
    <script src="https://cdn.datatables.net/buttons/1.5.1/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.5.1/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.5.1/js/buttons.print.min.js"></script>

    <script src="{{ asset('admin_dashboard/assets/libs/moment/moment.js') }}"></script>
    <script src="{{ asset('admin_dashboard/assets/libs/daterangepicker/daterangepicker.js')}}"></script>
    <script type="text/javascript">
    $(document).ready( function(){
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        initialize();

        function initialize(formData){
            var url = "{{ route('reports.members.registration.list') }}";
            url = (formData != null) ? url + "?" + formData : url;
            $('#memberReportTable').DataTable({
                ajax: url,
                columns: [
                    { data : 'member_id' },
                    { data : 'name' },
                    { data : 'member_type' },
                    { data : 'status' },
                    { data : 'verification_date' },
                    { data : 'expiration_date' },
                ],
                paging      : true,
                lengthChange: true,
                searching   : true,
                ordering    : false,
                info        : true,
                autoWidth   : false,
                destroy     : true,
                buttons     : ['csv', 'excel', 'print'],
                dom         : "<'row'<'col-lg-6 col-12' @role('super_admin|accounting') B @endrole><'col-lg-6 col-12'f>>" +
                            "<'row'<'col-12'tr>>" +
                            "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
                fnDrawCallback: function () {
                    self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                    $('#count').text(self.QtdOcorrenciasAgendadosHoje);

                    if (self.QtdOcorrenciasAgendadosHoje < 1)  {
                        $('.dt-buttons').addClass('d-none');
                    } else {
                        $('.dt-buttons').removeClass('d-none');
                    }
                }
            });

            $('.buttons-csv, .buttons-print, .buttons-excel').addClass('btn btn-success mr-1');
        }

        // Form Get Submit
        $('form').submit( function(e){
            e.preventDefault();
            var formData = $(this).serialize();
            initialize(formData);
        });

        // Custom Date Range
        var date = $('#daterangepicker').daterangepicker({
            ranges: {
                'Today': [moment(), moment()],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
            },
            alwaysShowCalendars: true,
            drops: "down",
            buttonClasses: "btn",
            applyClass: "btn-info",
            cancelClass: "btn-danger",
        });

        $('#status').select2({
            width  : '100%',
        });
    });
    </script>
@endpush