@extends('layouts.admin')
@section('title','Promos and Offers')
@section('styles')
    <style type="text/css">
        table.dataTable.select tbody tr,
        table.dataTable thead th:first-child {
          cursor: pointer;
        }
        @if(!auth()->user()->isSuperAdmin())
            tbody tr td:nth-child(2),
            tbody tr td:nth-child(3),
        @endif
        tbody tr td:nth-child(4), 
        tbody tr td:nth-child(5), 
        tbody tr td:nth-child(6),
        tbody tr td:nth-child(7),
        tbody tr td:nth-child(8){
            padding-top: 24px !important;
        }
    </style>
@endsection

@section('content')

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Promos and Offers</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('dashboard') }}">Home</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Promos and Offers</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-10 col-12">
                    <h4 class="page-title mt-2">
                        <i class="mdi mdi-wallet-giftcard"></i>
                        List of Promos and Offers (<span class="promo-count">0</span>)
                    </h4>                
                </div>
                
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <form method="POST" id="form-promo">
                                @csrf
                                <div class="table-responsive">
                                    <table id="promosTable" class="table table-hover">
                                        <thead>
                                            <tr>
                                                @role('super_admin|admin|accounting')
                                                    <th><input name="select_all" value="1" type="checkbox"></th>
                                                @endrole
                                                <th>Merchant Name</th>
                                                <th>Promo Code</th>
                                                <th>Description</th>
                                                <th>Item Type</th>
                                                <th>Quantity</th>
                                                <th>Status</th>
                                                <th>Date Created</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                           
                                        </tbody>
                                    </table>
                                </div>
                                <div class="text-right mt-4" id="show-button"></div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @include('dashboard.partials.footer')
        
    </div>
    
@endsection

@push('scripts')
    <script type="text/javascript">
        
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        var rows_selected = [];
        var table = $('#promosTable').DataTable({
            ajax : "{{ route('promos.list') }}",
            columns: [
                @role('super_admin|admin|accounting')
                    { data : 'checkbox' },
                @endrole
                { data : 'company' },
                { data : 'promo_code' },
                { data : 'description' },
                { data : 'item_type' },
                { data : 'quantity' },
                { data : 'status' },
                { data : 'created_at' },
            ],
            serverSide  : true,
            processing  : true,
            paging      : true,
            lengthChange: true,
            searching   : true,
            ordering    : false,
            info        : true,
            autoWidth   : false,
            dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                        "<'row'<'col-12'tr>>" +
                        "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
            fnDrawCallback: function () {
                self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                $('.promo-count').text(self.QtdOcorrenciasAgendadosHoje);
            }
        });

        @role('super_admin|admin|accounting')
            function updateDataTableSelectAllCtrl(table){
                var $table             = table.table().node();
                var $chkbox_all        = $('tbody input[type="checkbox"]', $table);
                var $chkbox_checked    = $('tbody input[type="checkbox"]:checked', $table);
                var chkbox_select_all  = $('thead input[name="select_all"]', $table).get(0);

                // If none of the checkboxes are checked
                if($chkbox_checked.length === 0){
                    showButton('not-selected');
                    chkbox_select_all.checked = false;
                    if('indeterminate' in chkbox_select_all){
                        chkbox_select_all.indeterminate = false;
                    }

                // If all of the checkboxes are checked
                } else if ($chkbox_checked.length === $chkbox_all.length){
                    chkbox_select_all.checked = true;
                    if('indeterminate' in chkbox_select_all){

                        chkbox_select_all.indeterminate = false;
                    }

                // If some of the checkboxes are checked
                } else {
                    chkbox_select_all.checked = true;
                    if('indeterminate' in chkbox_select_all){
                        chkbox_select_all.indeterminate = true;
                    }
                }
            }
            // Handle click on checkbox
            $('#promosTable tbody').on('click', 'input[type="checkbox"]', function(e){
                var $row = $(this).closest('tr');

                // Get row data
                var data = table.row($row).data();

                // Get row ID
                var rowId = data[0];

                // Determine whether row ID is in the list of selected row IDs
                var index = $.inArray(rowId, rows_selected);

                // If checkbox is checked and row ID is not in list of selected row IDs
                if(this.checked && index === -1){
                    rows_selected.push(rowId);

                // Otherwise, if checkbox is not checked and row ID is in list of selected row IDs
                } else if (!this.checked && index !== -1){
                    rows_selected.splice(index, 1);
                }

                if(this.checked){
                    $row.addClass('selected');
                    $row.css('background-color','#8dc83d');
                    $row.css('color','#fff');
                    showButton('selected');
                } else {
                    $row.removeClass('selected');
                    $row.removeAttr('style');
                }

                // Update state of "Select all" control
                updateDataTableSelectAllCtrl(table);

                // Prevent click event from propagating to parent
                e.stopPropagation();
            });

           // Handle click on table cells with checkboxes
            $('#promosTable').on('click', 'tbody td, thead th:first-child', function(e){
                $(this).parent().find('input[type="checkbox"]').trigger('click');
            });

           // Handle click on "Select all" control
            $('thead input[name="select_all"]', table.table().container()).on('click', function(e){
                if(this.checked){
                    $('#promosTable tbody input[type="checkbox"]:not(:checked)').trigger('click');
                } else {
                    $('#promosTable tbody input[type="checkbox"]:checked').trigger('click');
                }
                // Prevent click event from propagating to parent
                e.stopPropagation();
            });

            // Handle table draw event
            table.on('draw', function(){

                // Update state of "Select all" control
                updateDataTableSelectAllCtrl(table);
            });

           // Handle rejected promos and offers
            $('body').on('click', '#reject',function(e){
                e.preventDefault();

                swal({
                    title: "Are you sure?",
                    text: "Once you Reject, it will reject promos & offers!",
                    type: "warning",
                    confirmButtonClass: 'btn-danger',
                    showCancelButton: true,
                    showLoaderOnConfirm: true,
                    confirmButtonText: 'Reject',
                    closeOnConfirm: false,
                },
                ()=>{
                    var code = "{{ base64_encode(3) }}";
                    submit(code);

                    swal({
                        title: "Success",
                        text: 'Promos and Offers rejected successfully',
                        type: "success",
                        showConfirmButton: false,
                        timer: 1500
                    });
                });
            });

            // Handle approved promos and offers
           $('body').on('click', '#approved', function(e){
                e.preventDefault();
                
                swal({
                    title: "Are you sure?",
                    text: "Once you Approved, it will approved promos & offers!",
                    type: "warning",
                    confirmButtonClass: 'btn-info',
                    showCancelButton: true,
                    showLoaderOnConfirm: true,
                    confirmButtonText: 'Approved',
                    closeOnConfirm: false,
                },
                ()=>{
                    var code = "{{ base64_encode(1) }}";
                    submit(code);

                    swal({
                        title: "Success",
                        text: 'Promos and Offers approved successfully',
                        type: "success",
                        showConfirmButton: false,
                        timer: 1500
                    });
                });
            });

            // update promo and offer status
            function submit(code) {
                var formData = $('#form-promo').serialize();
                formData+='&code='+code;
                $.ajax({
                    type: "POST",
                    url: '{{ route("promos.update")}}',
                    data: formData,
                    success: function (response) {
                        table.ajax.reload();
                        $('#promosTable tbody input[type="checkbox"]:checked').trigger('click');
                    },
                    error: function (response) {
                        console.log('Error:', response);
                    }
                });
            }

            // show button if checked/selected
            function showButton(value) {
                var content = '';
                if (value == 'selected') {
                    content+='<button class="btn btn-danger mr-1" id="reject" type="submit">';
                        content+='<i class="mdi mdi-close-circle"></i> Reject';
                    content+='</button>';
                    content+='<button class="btn btn-info" id="approved" type="submit">';
                        content+='<i class="mdi mdi-checkbox-multiple-marked-circle"></i> Approve';
                    content+='</button>';
                }
                $('#show-button').html(content);
            }
        @endrole
    </script>
@endpush