@extends('layouts.admin')
@section('title','Wallet Transactions')

@section('content')

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Wallet Transactions</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('dashboard') }}">Home</a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="{{ route('merchants.wallets') }}">Merchant Wallets</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Wallet Transactions</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-5 col-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row p-t-10 p-b-10">
                                <div class="col p-r-0">
                                    <h3 class="font-light" id="balance" style="font-weight: 400 !important;">
                                        ₱ {{ number_format($merchant->getWalletBalance(),2) }}
                                    </h3>
                                    <h5 class="text-muted">{{ $merchant->name }}</h5>
                                    <h6 class="text-muted">Wallet Balance</h6>
                                </div>
                                <div class="col text-right align-self-center">
                                    <div data-label="{{ $merchant->mb_percent.'%' }}" class="css-bar m-b-0 css-bar-info css-bar-{{ $merchant->mb_percent }}">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-6 col-12">
                    <h4 class="page-title mt-2">
                        <i class="mdi mdi-credit-card"></i>
                        List of Wallet Transactions (<span id="count">0</span>)
                    </h4>                
                </div>
                <div class="col-lg-6 col-12 text-right">
                    <button class="btn btn-info" onclick="topUp()">
                        <i class="fa fa-plus"></i> Top-up
                    </button>             
                </div>
                <div class="col-12 mt-1">
                    <div class="card">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="walletTransactionTable" class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Amount</th>
                                            <th>Description</th>
                                            <th>Reference</th>
                                            <th>Remarks</th>
                                            <th width="12%">Date</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- modal -->
        <div id="topUpModal" class="modal" tabindex="-1" role="dialog" aria-labelledby="vcenter" aria-hidden="true" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <form method="POST">
                        @csrf
                        <div class="modal-header">
                            <h4 class="modal-title" id="vcenter">
                                <i class="mdi mdi-plus"></i> Top-Up
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-group">
                                        <label class="control-label">Transaction Amount*</label>
                                        <input type="text" class="form-control number" name="amount" placeholder="Enter transaction amount" required>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-group">
                                        <label class="control-label">Description*</label>
                                        <input type="text" class="form-control" name="description" placeholder="Enter description" required>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-group">
                                        <label class="control-label">Reference*</label>
                                        <input type="text" class="form-control" name="reference" placeholder="Enter reference" required>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-group">
                                        <label class="control-label">Remarks*</label>
                                        <input type="text" class="form-control" name="remarks" placeholder="Enter remarks" required>
                                    </div>
                                </div>
                            </div>                           
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger waves-effect" data-dismiss="modal">Cancel</button>
                            <button type="submit" id="top-up" class="btn btn-info waves-effect">
                                <i class="fa fa-save"></i> Top-Up
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        @include('dashboard.partials.footer')
        
    </div>
    
@endsection

@push('scripts')
   <script type="text/javascript">
        
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        var table = $('#walletTransactionTable').DataTable({
            ajax: "{{ route('merchants.wallets.transactions.list', base64_encode($merchant->id)) }}",
            columns: [
                { data : 'DT_RowIndex' },
                { data : 'amount' },
                { data : 'description' },
                { data : 'reference' },
                { data : 'remarks' },
                { data : 'created_at' },
            ],
            paging      : true,
            lengthChange: true,
            searching   : true,
            ordering    : false,
            info        : true,
            autoWidth   : false,
            dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                        "<'row'<'col-12'tr>>" +
                        "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
            fnDrawCallback: function () {
                self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                $('#count').text(self.QtdOcorrenciasAgendadosHoje);
            }
        });

        function topUp() {
           $('#topUpModal').modal('show');
            const token = $('input[name="_token"]').val();
            $('#topUpModal :input').val('');
            $('input[name="_token"]').val(token);
        }

         // Top-Up Form Submit
        $('form').submit( function(e){
            e.preventDefault();

            $('#top-up').attr('disabled',true);

            var url = "{{ route('merchants.wallets.settings.topUp', base64_encode($merchant->id)) }}";
            var formData = $(this).serialize();

            $.ajax({
                type: "POST",
                url: url,
                data: formData,
                success: function (response) {

                    if (!response.error) {
                        $('#top-up').removeAttr('disabled',true);
                        $('#topUpModal').modal('hide');
                        $('#balance').text('₱ '+response.balance);
                        
                        table.ajax.reload();
                        swal({
                            title: "Success",
                            text: 'Top-up successfully',
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });

                    } else {
                        $('#top-up').removeAttr('disabled',true);
                        // error repsonse
                        console.log(response);
                    }
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });
   </script>
@endpush