@extends('layouts.admin')
@section('title','Merchant Wallets')
@section('styles')
    <style type="text/css"> 
        #merchantWalletTable tbody tr td:nth-child(2){
            padding-top: 24px !important;
        }
        #merchantWalletTable tbody tr td:nth-child(3){
            padding-top: 20px !important;
        }
        h6{
            font-weight: 500
        }
    </style>
@endsection

@section('content')

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Merchant Wallets</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('dashboard') }}">Home</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Merchant Wallets</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-10 col-12">
                    <h4 class="page-title mt-2">
                        <i class="mdi mdi-credit-card"></i>
                        List of Merchant Wallets (<span id="count">0</span>)
                    </h4>                
                </div>
                
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="merchantWalletTable" class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Merchant Name</th>
                                            <th>Wallet Balance</th>
                                            <th width="20%">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                      
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- modal -->
        <div id="settingsModal" class="modal" tabindex="-1" role="dialog" aria-labelledby="vcenter" aria-hidden="true" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <form method="POST">
                        @csrf
                        <div class="modal-header">
                            <h4 class="modal-title" id="vcenter">
                                <i class="mdi mdi-plus"></i> Settings Configuration
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-lg-6 col-12">
                                    <div class="form-group">
                                        <label class="control-label">Merchant Name</label>
                                        <input type="text" class="form-control" id="merchant_name" disabled>
                                        <input type="hidden" name="merchant_id" id="merchant_id">
                                    </div>
                                </div>
                                <div class="col-lg-6 col-12">
                                    <div class="form-group">
                                        <label class="control-label">Amount*</label>
                                        <input type="text" class="form-control number" name="mb_amount" id="mb_amount" placeholder="Enter amount" required>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-12">
                                    <div class="form-group">
                                        <label class="control-label">Maintaining Balance Percentage*</label>
                                        <select class="form-control select" name="mb_percent" id="mb_percent" required>
                                        </select>
                                    </div>
                                </div> 
                                <div class="col-lg-6 col-12">
                                    <div class="form-group">
                                        <label class="control-label">Deduction on*</label>
                                        <select class="form-control select" name="deduction_on" id="deduction_on" required>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger waves-effect" data-dismiss="modal">Cancel</button>
                            @role('super_admin|admin|accounting')
                                <button type="submit" id="save" class="btn btn-info waves-effect">
                                    <i class="fa fa-save"></i> Set-up Configuration
                                </button>
                            @endrole
                        </div>
                    </form>
                </div>
            </div>
        </div>

        @include('dashboard.partials.footer')
        
    </div>
    
@endsection

@push('scripts')
    <script type="text/javascript">
       
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        var table = $('#merchantWalletTable').DataTable({
            ajax: "{{ route('merchants.wallets.list') }}",
            columns: [
                { data : 'merchant_name' },
                { data : 'wallet_balance' },
                { data : 'action', orderable: false, searchable: false}
            ],
            paging      : true,
            lengthChange: true,
            searching   : true,
            ordering    : false,
            info        : true,
            autoWidth   : false,
            dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                        "<'row'<'col-12'tr>>" +
                        "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
            fnDrawCallback: function () {
                self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                $('#count').text(self.QtdOcorrenciasAgendadosHoje);
            }
        });

        // view modal settings
        $('body').on('click', '#settings', function(e){
            e.preventDefault();

            var url = $(this).attr('href');
            $.ajax({
                type: "GET",
                url: url,
                success: function (response) {
                    $('#merchant_id').val(response.id);
                    $('#merchant_name').val(response.name);
                    $('#mb_amount').val(response.mb_amount);

                    var data = ['Points','Rebate','System','Accumulated','Advocacy'];

                    // Remove Points in Item Type if not superadmin
                    @role('admin|accounting|cashier')
                        data.splice(0,1);
                    @endrole

                    var percentage = [];
                    for (var i = 0; i < 101; i++) {
                        percentage.push([i]);
                    }

                    select2();
                    $('#deduction_on').empty();
                    $.each(data, function(id, data) {
                        $('#deduction_on').append('<option value="'+ data.toLowerCase() +'" '+ ((response.deduction_on == data.toLowerCase()) ? 'selected' : '') +'>'+ ((data == "Points") ? 'Point of Payment' : data) +'</option>'); 
                    });

                    $('#mb_percent').empty();
                    $.each(percentage, function(id, data) {
                        $('#mb_percent').append('<option value="'+ data +'" '+ ((response.mb_percent == data) ? 'selected' : '') +'>'+ data +'%</option>'); 
                    });

                    $('#settingsModal').modal('show');
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });

         // Form setup configuration
        $('form').submit( function(e){
            e.preventDefault();

            $('#save').attr('disabled',true);

            var url = "{{ route('merchants.wallets.settings.update')}}";
            var formData = $(this).serialize();

            $.ajax({
                type: "POST",
                url: url,
                data: formData,
                success: function (response) {
                    $('#save').removeAttr('disabled',true);
                    $('#settingsModal').modal('hide');
                    
                    table.ajax.reload();
                    swal({
                        title: "Success",
                        text: 'Set-up Configuration saved successfully',
                        type: "success",
                        showConfirmButton: false,
                        timer: 1500
                    });
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });

        function select2() {
            $('select.select').select2({
                dropdownParent: $('#settingsModal'),
                width: '100%',
            });
        }
        // $('form input').attr('disabled',true);
        // $('form select').attr('disabled',true);

   </script>
@endpush