@extends('layouts.admin')
@section('title','Settings')
@section('styles')
    <style type="text/css">
        #promosTable tbody tr td:nth-child(2),
        #promosTable tbody tr td:nth-child(3),
        #promosTable tbody tr td:nth-child(4), 
        #promosTable tbody tr td:nth-child(5), 
        #promosTable tbody tr td:nth-child(6),
        #promosTable tbody tr td:nth-child(7){
            padding-top: 24px !important;
        }
        #promosTable tbody tr td:nth-child(8){
            padding-top: 20px !important;
        }
        .form-group{
            margin-bottom: .4rem;
        }
    </style>
@endsection

@section('content')

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Settings</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('dashboard') }}">Home</a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="{{ route('merchants') }}">Merchants</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Settings</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-4 col-12">
                    <div class="card">
                        <div class="card-body shadow">
                            <div class="row">
                                <div class="col p-r-0 mt-2">
                                    <h5 style="font-weight: 500 !important;">{{ strtoupper($merchant->name) }} </h5>
                                    <h6 class="text-muted text-uppercase">Merchant</h6>
                                </div>
                                <div class="col-4 text-right align-self-center">
                                    <img class="round align-self-center round-success"src="{{ $merchant->path }}" style="width: 50px; height: 50px;">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12 mt-2">
                    <div class="card">
                        <div class="card-body">
                            <ul class="nav nav-tabs" role="tablist">
                                <li class="nav-item"> 
                                    <a class="nav-link active" data-toggle="tab" href="#promotions" role="tab">
                                        <span class="hidden-sm-up">
                                            <i class="mdi mdi-cart-plus"></i>
                                        <span class="hidden-xs-down"> List of Promotions (<span id="count">0</span>)</span>
                                    </a>
                                </li>
                                <li class="nav-item"> 
                                    <a class="nav-link" data-toggle="tab" href="#rebates" role="tab">
                                        <span class="hidden-sm-up">
                                            <i class="mdi mdi-cart-plus"></i>
                                            <span class="hidden-xs-down">Current Setup Rebate</span>
                                        </span> 
                                    </a> 
                                </li>
                            </ul>
                            <!-- Tab panes -->
                            <div class="tab-content tabcontent-border">
                                <div class="tab-pane active" id="promotions" role="tabpanel">
                                    <div class="row">
                                        <div class="col-lg-3 col-12 mt-4">
                                            <label>Filter By:</label>
                                            <select class="form-control" id="filter_by">
                                                <option value="All">All</option>
                                                <option value="0">Pending</option>
                                                <option value="1">Approved</option>
                                                <option value="-1">Rejected</option>
                                            </select>
                                        </div>  
                                        <div class="col-lg-9 col-12 text-right">
                                            @role('super_admin')
                                                <button class="btn btn-success mt-4" onclick="addPromo()">
                                                    <i class="fa fa-plus"></i> Add Promo
                                                </button>
                                            @endrole     
                                        </div>
                                        <div class="col-12 mt-4">
                                            <div class="table-responsive">
                                                <table id="promosTable" class="table table-hover">
                                                    <thead>
                                                        <tr>
                                                            <th>Voucher Code</th>
                                                            <th>Item Type</th>
                                                            <th>Quantity</th>
                                                            <th>Description</th>
                                                            <th>Date Start</th>
                                                            <th>Date End</th>
                                                            <th>Status</th>
                                                            <th>Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        
                                                    </tbody>
                                                </table>
                                            </div> 
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane" id="rebates" role="tabpanel">
                                    <div class="row">
                                        @role('super_admin')
                                            <div class="col-lg-8 col-12">
                                                <form id="setup-rebates">
                                                    @csrf
                                                    <div class="row mt-4">
                                                        @php
                                                            $percentage = [];
                                                            for ($i=0; $i < 101; $i++) { 
                                                                array_push($percentage, $i);
                                                            }
                                                        @endphp
                                                        <div class="col-lg-6 col-12 form-group">
                                                            <label>Rebate (%)</label>
                                                            <select class="form-control" name="rebate">
                                                                @foreach($percentage as $percent)
                                                                    <option value="{{ $percent }}" {{ old('rebate', $merchant->rebate) == $percent ? 'selected' : ''}}>{{ $percent.'%' }}</option>
                                                                @endforeach 
                                                            </select>
                                                        </div>
                                                        <div class="col-lg-6 col-12 form-group">
                                                            <label>System and Maintenance (%)</label>
                                                            <select class="form-control" name="system">
                                                                @foreach($percentage as $percent)
                                                                    <option value="{{ $percent }}" {{ old('system', $merchant->system) == $percent ? 'selected' : ''}}>{{ $percent.'%' }}</option>
                                                                @endforeach 
                                                            </select>
                                                        </div>
                                                        <div class="col-lg-6 col-12 form-group">
                                                            <label>Accumulated (%)</label>
                                                            <select class="form-control" name="accumulated">
                                                                @foreach($percentage as $percent)
                                                                    <option value="{{ $percent }}" {{ old('accumulated', $merchant->accumulated) == $percent ? 'selected' : ''}}>{{ $percent.'%' }}</option>
                                                                @endforeach 
                                                            </select>
                                                        </div>
                                                        <div class="col-lg-6 col-12 form-group">
                                                            <label>Advocacy (%)</label>
                                                            <select class="form-control" name="advocacy">
                                                                @foreach($percentage as $percent)
                                                                    <option value="{{ $percent }}" {{ old('advocacy', $merchant->advocacy) == $percent ? 'selected' : ''}}>{{ $percent.'%' }}</option>
                                                                @endforeach 
                                                            </select>
                                                        </div>
                                                        <div class="col-lg-6 col-12 form-group">
                                                            <label>Member (%)</label>
                                                            <select class="form-control" name="member">
                                                                @foreach($percentage as $percent)
                                                                    <option value="{{ $percent }}" {{ old('member', $merchant->member) == $percent ? 'selected' : ''}}>{{ $percent.'%' }}</option>
                                                                @endforeach 
                                                            </select>
                                                        </div>
                                                        <div class="col-lg-6 col-12 form-group">
                                                            <label>Upline (%)</label>
                                                            <select class="form-control" name="upline">
                                                                @foreach($percentage as $percent)
                                                                    <option value="{{ $percent }}" {{ old('upline', $merchant->upline) == $percent ? 'selected' : ''}}>{{ $percent.'%' }}</option>
                                                                @endforeach 
                                                            </select>
                                                        </div>
                                                        <div class="col-lg-6 col-12 form-group">
                                                            <label>No. of Upline*</label>
                                                            <input type="text" name="upline_number" class="form-control only-number" value="{{ $merchant->upline_number }}" placeholder="Enter number of upline" required>
                                                        </div>
                                                        <div class="col-lg-12 col-12 form-group text-right">
                                                            <button type="submit" id="update" class="btn btn-info">
                                                                <i class="fa fa-save"></i> Update Settings
                                                            </button>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        @endrole
                                        <div class="col-12 mt-4">
                                            <h5>List of Point Settings History (<span id="points_count">0</span>)</h5>
                                            <div class="table-responsive">
                                                <table id="pointSettingsTable" class="table table-hover">
                                                    <thead>
                                                        <tr>
                                                            <th>#</th>
                                                            <th>Rebate</th>
                                                            <th>System</th>
                                                            <th>Accumulated</th>
                                                            <th>Advocacy</th>
                                                            <th>Member</th>
                                                            <th>Upline</th>
                                                            <th>No. of Upline</th>
                                                            <th>Status</th>
                                                            <th>Date Created</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        
                                                    </tbody>
                                                </table>
                                            </div> 
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- add promo modal -->
        @include('dashboard.merchants.partials.add-promo-modal')

        <!-- view promo modal -->
        @include('dashboard.merchants.partials.view-promo-modal')

        @include('dashboard.partials.footer')
        
    </div>
    
@endsection

@push('scripts')
    <script type="text/javascript">
        
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        initialize();

        function initialize(type) {
            var type = type != null ? type : '';
            var table = $('#promosTable').DataTable({
                ajax: "{{ route('merchants.settings.list', base64_encode($merchant->id)) }}/"+type,
                columns: [
                    { data : 'promo_code' },
                    { data : 'item_type' },
                    { data : 'quantity' },
                    { data : 'description' },
                    { data : 'date_start' },
                    { data : 'date_end' },
                    { data : 'status' },
                    { data : 'action', orderable: false, searchable: false}
                ],
                select      : true,
                paging      : true,
                lengthChange: true,
                searching   : true,
                ordering    : false,
                info        : true,
                autoWidth   : false,
                destroy     : true,
                dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                            "<'row'<'col-12'tr>>" +
                            "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
                fnDrawCallback: function () {
                    self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                    $('#count').text(self.QtdOcorrenciasAgendadosHoje);
                }
            });
        }

        var table1 = $('#pointSettingsTable').DataTable({
            ajax: "{{ route('merchants.settings.points', base64_encode($merchant->id)) }}",
            columns: [
                { data : 'DT_RowIndex' },
                { data : 'rebate' },
                { data : 'system' },
                { data : 'accumulated' },
                { data : 'advocacy' },
                { data : 'member' },
                { data : 'upline' },
                { data : 'upline_number' },
                { data : 'status' },
                { data : 'created_at' },
            ],
            select: true,
            paging      : true,
            lengthChange: true,
            searching   : true,
            ordering    : false,
            info        : true,
            autoWidth   : false,
            dom         : '<"top"><"bottom"><"clear">',
            fnDrawCallback: function () {
                self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                $('#points_count').text(self.QtdOcorrenciasAgendadosHoje);
            }
        });

        // Filter By 
        $('#filter_by').on('change', function(){

            var type = $(this).val();
            initialize(type);
        })

        function addPromo() {
            $('#addPromoModal').modal('show');
            const token = $('input[name="_token"]').val();
            $('#addPromoModal :input').val('');
            $('#addPromoModal select').select2('');
            $('input[name="_token"]').val(token);
            $('#is_custom').val(1);

            select2();
            getMembers();
            getMemberTypes();
            $('#is_custom').prop('checked', false);
            isCustomChecked();
        }

        // Form Add & Update Promo
        $('form#add-promo').submit( function(e){
            e.preventDefault();

            $('#save').attr('disabled',true);

            var url = "{{ route('merchants.settings.add', base64_encode($merchant->id)) }}";

            let form = new FormData(this);

            $.ajax({
                url: url,
                type: 'POST',
                data: form,
                cache: false,
                contentType: false,
                processData: false,
                beforeSend: function(){
                   loadingAjaxPreloader();
                },
                success: function (response) {

                    if (response.message == 'success') {
                        var count = "{{ getPromotionCount()+1 }}";
                        
                        $('#save').removeAttr('disabled',true);
                        $('#addPromoModal').modal('hide');
                        $('.promo-count').text(count);

                        successAjaxPreloader();
                        initialize();
                        swal({
                            title: "Success",
                            text: 'Promo add successfully',
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });
                        
                    } else {
                        successAjaxPreloader();
                        $('#save').removeAttr('disabled',true);
                        $('#promo_code').addClass('is-invalid');
                        $('.promo_code').addClass('invalid-feedback');
                        $('.promo_code').text(response.message.promo_code);
                    }
                },
                error: function(error){
                  console.log(error);
                },
            });
        });

        // Form Setup rebates
        $('form#setup-rebates').submit( function(e){
            e.preventDefault();

            $('#update').attr('disabled',true);

            var url = "{{ route('merchants.settings.setuprebate', base64_encode($merchant->id)) }}";

            var formData = $(this).serialize();

            $.ajax({
                type: "POST",
                url: url,
                data: formData,
                success: function (response) {
                    $('#update').removeAttr('disabled',true);
                    table1.ajax.reload();
                    swal({
                        title: "Success",
                        text: 'Setup Rebates successfully',
                        type: "success",
                        showConfirmButton: false,
                        timer: 1500
                    });
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });

        // view modal
        $('body').on('click', '#view', function(e){
            e.preventDefault();

            var url = $(this).attr('href');
            
            $.ajax({
                type: "GET",
                url: url,
                success: function (response) {
                    $('#images').empty();
                    if (response.images.length) {
                        for (i = 0; i < response.images.length; i++) {
                            $('#images').append("<div class='col-4 form-group text-center'><img src="+response.images[i]+" class='shadow' width='110px' height='100px'></div>");
                        }
                    } else {
                        $('#images').append('<img src="{{ asset("admin_dashboard/img/no-images.png") }}" width="40%">');
                    }
                    
                    $('#status').empty();
                    if (response.status == 0) {
                        $('#status').append('<i class="mdi mdi-checkbox-blank-circle text-warning mr-2"></i> Pending');
                    } else if(response.status == 1) {
                        $('#status').append('<i class="mdi mdi-checkbox-blank-circle text-success mr-2"></i> Approved');
                    } else {
                        $('#status').append('<i class="mdi mdi-checkbox-blank-circle text-danger mr-2"></i> Rejected');
                    }
                    $('#v_promo_code').text(response.promo_code);
                    $('#v_item_type').text(response.item_type);
                    $('#v_quantity').text(response.quantity);
                    $('#v_description').text(response.description);
                    $('#v_points_required').text(response.points_required);
                    $('#v_discount').text(response.discount);
                    $('#v_price').text(response.price);
                    $('#v_content').text(response.content);
                    $('#v_allocation_amount').text(response.allocation_amount);
                    $('#v_remarks').text(response.remarks);
                    $('#v_date_start1').text(response.date_startFormat);
                    $('#v_date_end2').text(response.date_endFormat);  
                    $('#viewPromoModal').modal('show');
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });

        function select2() {
            $('select.select').select2({
                dropdownParent: $('#addPromoModal'),
                width: '100%',
            });
        }

        $('#is_custom').click( function(){
            isCustomChecked();
        });

        // is custom checked
        function isCustomChecked() {
            if ($('#is_custom').is(":checked")){
                $('#custom-promo').removeClass('d-none');
                $('#custom-promo :input').removeAttr('disabled', true);
                $('#custom-promo select').removeAttr('disabled', true);
            } else {
                $('#custom-promo').addClass('d-none');
                $('#custom-promo :input').attr('disabled', true);
                $('#custom-promo select').attr('disabled', true);
            }
        }

        $('#custom_type').change( function() {
            let value = $(this).val();
            isCustomType(value);
        });

        function isCustomType(value){

            if (value == 'promo_members') {
                $('#member_div').removeClass('d-none');
                $('#member_id').removeAttr('disabled', true);
                $('#member_id').attr('required', true);
                $('#member_id').empty()

                $('#member_type_div').addClass('d-none');
                $('#member_types').attr('disabled', true);
                $('#member_types').removeAttr('required', true);

            } else{
                
                $('#member_type_div').removeClass('d-none');
                $('#member_types').removeAttr('disabled', true);
                $('#member_types').attr('required', true);
                $('#member_types').empty()

                $('#member_div').addClass('d-none');
                $('#member_id').attr('disabled', true);
                $('#member_id').removeAttr('required', true);
            }
        }

        function getMemberTypes(data){
            const member_types = data != null ? data : '';
            var url = '{{ route('promos.members.types') }}';

            $("#member_types").select2({
                ajax: {
                    url: url,
                    dataType: 'json',
                    delay: 250,
                    cache: true,
                    multiple: true,
                    minimumInputLength: 1,
                    processResults: function(data, params) {
                        return {
                            results: $.map(data, function(item) {
                                return {
                                    text: item.name,
                                    id: item.id
                                }
                            })
                        };
                    },
                },
                dropdownParent: $('#addPromoModal'),
                width: '100%',
            });

            $('#member_types').empty();
            $.map(member_types, function (item) {
                $('#member_types').append('<option value="'+ item.id +'" selected="selected">'+ item.name+'</option>');
            });
            $('#member_types').trigger('change');
        }

        // get members
        function getMembers(data) {
            const members = data != null ? data : '';
            var url = '{{ route('promos.members') }}?filter=';

            $("#member_id").select2({
                ajax: {
                    url: function (params) {
                        return url + params.term;
                    },
                    dataType: 'json',
                    delay: 250,
                    cache: true,
                    multiple: true,
                    minimumInputLength: 1,
                    processResults: function(data, params) {
                        return {
                            results: $.map(data, function(item) {
                                return {
                                    image: item.path,
                                    text: item.firstname + ' ' + item.lastname,
                                    id: item.id
                                }
                            })
                        };
                    },
                },
                templateResult: formatState,
                templateSelection: formatState,
                dropdownParent: $('#addPromoModal'),
                width: '100%',
            });

            $('#member_id').empty();
            $.map(members, function (item) {
                $('#member_id').append('<option value="'+ item.id +'" selected="selected"><img src="'+ item.path +'" class="rounded-circle mr-1 ml-1" width="30px" height="30px" /> '+ item.firstname + ' ' + item.lastname+'</option>');
            });
            $('#member_id').trigger('change');
        }

        function formatState(opt) {
            var optimage = opt.image;
            if(!optimage){
                var image = "{{ asset('admin_dashboard/img/default.png') }}";
            } else {                    
                var image = "{{ config('app.AWS_BUCKET_URL') }}"+optimage;
            }

            return $('<span><img src="' + image + '" class="rounded-circle mr-1 ml-1" width="30px" height="30px" /> ' + opt.text + '</span>');
        };

        $('#setup-rebates select').select2({
            width: '100%'
        }); 

        $('select#filter_by').select2({
            width: '100%'
        }); 

         // Date start
        $('#date_start').datepicker({
            autoclose: true,
            todayHighlight: true
        });

        // Date end
        $('#date_end').datepicker({
            autoclose: true,
            todayHighlight: true
        });
    </script>
@endpush