@extends('layouts.admin')
@section('title','Reviews')

@php
    $kol_a = auth()->user()->account->merchant->merchantAgreement->application_type == 'kol-a';
@endphp

@section('styles')
    <style type="text/css">
        tbody tr td:nth-child(2){
            padding-top: 20px !important;
        }
        tbody tr td:nth-child(3), 
        @if(!$kol_a)
            tbody tr td:nth-child(4),
        @endif 
        tbody tr td:nth-child(5){
            padding-top: 24px !important;
        }
    </style>
@endsection

@section('content')

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Reviews</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('dashboard') }}">Home</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Reviews</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-6 col-12">
                    <h4 class="page-title mt-2">
                        <i class="mdi mdi-comment-multiple-outline"></i>
                        List of Reviews (<span id="count">0</span>)
                    </h4>                
                </div>

                <div class="col-12 mt-1">
                    <div class="card">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="reviewTable" class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th width="22%">Customer Name</th>
                                            <th width="12%">Rate</th>
                                            <th>Comment</th>
                                            @if($kol_a)
                                                <th>Doctor</th>
                                            @endif
                                            <th>Date/Time</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @include('dashboard.partials.footer')
        
    </div>
    
@endsection

@push('scripts')
   <script type="text/javascript">
        
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        var table = $('#reviewTable').DataTable({
            ajax: "{{ route('merchants.reviews.list') }}",
            columns: [
                { data : 'customer_name' },
                { data : 'rate' },
                { data : 'comment' },
                @if($kol_a)
                    { data : 'doctor_name' },
                @endif
                { data : 'created_at' },
            ],
            paging      : true,
            lengthChange: true,
            searching   : true,
            ordering    : false,
            info        : true,
            autoWidth   : false,
            dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                        "<'row'<'col-12'tr>>" +
                        "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
            fnDrawCallback: function () {
                self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                $('#count').text(self.QtdOcorrenciasAgendadosHoje);
            }
        });

   </script>
@endpush