@extends('layouts.admin')
@section('title','Promos and Offers')
@section('styles')
    <style type="text/css">
        #promosTable tbody tr td:nth-child(2),
        #promosTable tbody tr td:nth-child(3),
        #promosTable tbody tr td:nth-child(4), 
        #promosTable tbody tr td:nth-child(5), 
        #promosTable tbody tr td:nth-child(6),
        #promosTable tbody tr td:nth-child(7){
            padding-top: 24px !important;
        }
        #promosTable tbody tr td:nth-child(8){
            padding-top: 20px !important;
        }
        .form-group{
            margin-bottom: .4rem;
        }
    </style>
@endsection

@section('content')

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Promos and Offers</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('dashboard') }}">Home</a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="{{ route('merchants') }}">Merchants</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Promos and Offers</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-6 col-12">
                    <h4 class="page-title mt-2">
                        <i class="mdi mdi-wallet-giftcard"></i>
                        List of Promos and Offers (<span id="count">0</span>)
                    </h4>                
                </div>
                <div class="col-lg-6 col-12 text-right">
                    <button class="btn btn-success" onclick="addPromo()">
                        <i class="fa fa-plus"></i> Add Promo
                    </button>
                </div>
                
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <form method="POST" id="form-promo">
                                @csrf
                                <div class="table-responsive">
                                    <table id="promosTable" class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th>Promo Code</th>
                                                <th>Item Type</th>
                                                <th>Quantity</th>
                                                <th>Description</th>
                                                <th>Date Start</th>
                                                <th>Date End</th>
                                                <th>Status</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                           
                                        </tbody>
                                    </table>
                                </div>
                                <div class="text-right mt-4" id="show-button"></div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- add promo modal -->
        @include('dashboard.merchants.partials.add-promo-modal')

        <!-- view promo modal -->
        @include('dashboard.merchants.partials.view-promo-modal')

        @include('dashboard.partials.footer')
        
    </div>
    
@endsection

@push('scripts')
    <script type="text/javascript">
        
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        initialize();

        function initialize(type) {
            var type = type != null ? type : '';
            var table = $('#promosTable').DataTable({
                ajax: "{{ route('merchants.settings.list', $id) }}/"+type,
                columns: [
                    { data : 'promo_code' },
                    { data : 'item_type' },
                    { data : 'quantity' },
                    { data : 'description' },
                    { data : 'date_start' },
                    { data : 'date_end' },
                    { data : 'status' },
                    { data : 'action', orderable: false, searchable: false}
                ],
                select      : true,
                paging      : true,
                lengthChange: true,
                searching   : true,
                ordering    : false,
                info        : true,
                autoWidth   : false,
                destroy     : true,
                dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                        "<'row'<'col-12'tr>>" +
                        "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
                fnDrawCallback: function () {
                    self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                    $('#count').text(self.QtdOcorrenciasAgendadosHoje);
                }
            });
        }

        // Filter By 
        $('#filter_by').on('change', function(){

            var type = $(this).val();
            initialize(type);
        })

        $('select#filter_by').select2({
            width: '100%'
        });

        function addPromo() {
            $('#addPromoModal').modal('show');
            const token = $('input[name="_token"]').val();
            $('#addPromoModal :input').val('');
            $('#addPromoModal select').select2('');
            $('input[name="_token"]').val(token);
            $('#is_custom').val(1);

            select2();
            getMembers();
            getMemberTypes();
            $('#is_custom').prop('checked', false);
            isCustomChecked();

            var content = "<i class='mdi mdi-plus'></i> Add Promo";
            $('#vcenter').html(content);
        }
        
        // Modal Edit
        $('body').on('click','#edit', function(e){
            e.preventDefault();

            $('#save').removeAttr('disabled',true);
            $('#promo_code').removeClass('is-invalid');
            $('.promo_code').removeClass('invalid-feedback');
            $('.promo_code').text('');
            
            var content = "<i class='mdi mdi-table-edit'></i> Edit Promo";
            $('#vcenter').html(content);
            
            var items = ['Bundle','Discount','Freebies'];
            var url = $(this).attr('href');

            $.ajax({
                type: "GET",
                url: url,
                success: function (response) {
                    
                    select2();
                    getMembers();
                    getMemberTypes();
                    $('#is_custom').prop('checked', false);
                    isCustomChecked();

                    $('#item_type').empty();
                    $('#item_type').append('<option value="" disabled>Select Item Type</option>');
                    $.each(items, function(id, data) {
                        $('#item_type').append('<option value="'+ data.toLowerCase() +'" '+ ((response.item_type == data.toLowerCase()) ? 'selected' : '') +'>'+ data +'</option>'); 
                    });

                    $('#discount').empty();
                    $('#discount').append('<option value="" disabled>Select Discount</option>');
                    for ($i=0; $i < 101; $i++) { 
                        $('#discount').append('<option value="'+ $i +'" '+ ((response.discount == $i) ? 'selected' : '') +'>'+ $i +'%</option>');
                    }

                    if (response.is_custom == 1) {
                        $('#is_custom').prop('checked', true);
                        isCustomChecked();
                        isCustomType(response.custom_type);
                        getMembers(response.promo_members);
                        getMemberTypes(response.promo_members_types);

                        const array = ['promo_members', 'promo_member_types'];
                        const $option = $('#custom_type');

                        $option.empty();
                        $option.append('<option value="" disabled>Select Custom Type</option>');
                        array.map(item => {
                            var data = (item == 'promo_members') ? 'Members' : 'Member Types';
                            $option.append('<option value="'+ item +'" '+ ((response.custom_type == item) ? 'selected' : '') +'>'+ data +'</option>');
                        });
                    }

                    $('#promo_code').val(response.promo_code);
                    $('#quantity').val(response.quantity);
                    $('#description').val(response.description);
                    $('#points_required').val(response.points_required);
                    $('#price').val(response.price);
                    $('#content').val(response.content);
                    $('#allocation_amount').val(response.allocation_amount);
                    $('#remarks').val(response.remarks);
                    $('#date_start').val(response.date_startFormat);
                    $('#date_end').val(response.date_endFormat);
                    $('#promo_id').val(response.id);
                    $('#addPromoModal').modal('show');
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });

        // view modal
        $('body').on('click', '#view', function(e){
            e.preventDefault();

            var url = $(this).attr('href');
            
            $.ajax({
                type: "GET",
                url: url,
                success: function (response) {
                    $('#images').empty();
                    const array = response.images;
                    if (array.length) {
                        array.map(image => {
                            $('#images').append("<div class='col-4 form-group text-center'><img src="+image+" class='shadow' width='110px' height='100px'></div>");
                        });
                    } else {
                        $('#images').append('<img src="{{ asset("admin_dashboard/img/no-images.png") }}" width="40%">');
                    }
                    
                    $('#status').empty();
                    if (response.status == 0) {
                        $('#status').append('<i class="mdi mdi-checkbox-blank-circle text-warning mr-2"></i> Pending');
                    } else if(response.status == 1) {
                        $('#status').append('<i class="mdi mdi-checkbox-blank-circle text-success mr-2"></i> Approved');
                    } else {
                        $('#status').append('<i class="mdi mdi-checkbox-blank-circle text-danger mr-2"></i> Rejected');
                    }
                    $('#v_promo_code').text(response.promo_code);
                    $('#v_item_type').text(response.item_type);
                    $('#v_quantity').text(response.quantity);
                    $('#v_description').text(response.description);
                    $('#v_points_required').text(response.points_required);
                    $('#v_discount').text(response.discount);
                    $('#v_price').text(response.price);
                    $('#v_content').text(response.content);
                    $('#v_allocation_amount').text(response.allocation_amount);
                    $('#v_remarks').text(response.remarks);
                    $('#v_date_start1').text(response.date_startFormat);
                    $('#v_date_end2').text(response.date_endFormat);  
                    $('#viewPromoModal').modal('show');
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });

        // Form Add & Update Promo
        $('form#add-promo').submit( function(e){
            e.preventDefault();

            $('#save').attr('disabled',true);

            const promo_id = $('#promo_id').val();

            var url = promo_id == '' ? '{{ route('merchants.settings.add', $id) }}' : 
                                    '{{ route('merchants.settings.update', $id) }}';

            let form = new FormData(this);

            $.ajax({
                url: url,
                type: 'POST',
                data: form,
                cache: false,
                contentType: false,
                processData: false,
                beforeSend: function(){
                   loadingAjaxPreloader();
                },
                success: function (response) {
                    if (response.message == 'success') {
                        var count = "{{ getPromotionCount()+1 }}";
                        
                        $('#save').removeAttr('disabled',true);
                        $('#addPromoModal').modal('hide');
                        $('.promo-count').text(count);

                        successAjaxPreloader();
                        initialize();
                        swal({
                            title: "Success",
                            text: 'Promo add successfully',
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });
                        
                    } else {
                        successAjaxPreloader();
                        $('#save').removeAttr('disabled',true);
                        $('#promo_code').addClass('is-invalid');
                        $('.promo_code').addClass('invalid-feedback');
                        $('.promo_code').text(response.message.promo_code);
                    }
                },
                error: function(error){
                    console.log(error);
                },
            });
        });

        function select2() {
            $('select.select').select2({
                dropdownParent: $('#addPromoModal'),
                width: '100%',
            });
        }

        $('#is_custom').click( function(){
            isCustomChecked();
        });

        // is custom checked
        function isCustomChecked() {
            if ($('#is_custom').is(":checked")){
                $('#custom-promo').removeClass('d-none');
                $('#custom-promo :input').removeAttr('disabled', true);
                $('#custom-promo select').removeAttr('disabled', true);
            } else {
                $('#custom-promo').addClass('d-none');
                $('#custom-promo :input').attr('disabled', true);
                $('#custom-promo select').attr('disabled', true);
            }
        }

        $('#custom_type').change( function() {
            let value = $(this).val();
            isCustomType(value);
        });

        function isCustomType(value){

            if (value == 'promo_members') {
                $('#member_div').removeClass('d-none');
                $('#member_id').removeAttr('disabled', true);
                $('#member_id').attr('required', true);
                $('#member_id').empty()

                $('#member_type_div').addClass('d-none');
                $('#member_types').attr('disabled', true);
                $('#member_types').removeAttr('required', true);

            } else{
                
                $('#member_type_div').removeClass('d-none');
                $('#member_types').removeAttr('disabled', true);
                $('#member_types').attr('required', true);
                $('#member_types').empty()

                $('#member_div').addClass('d-none');
                $('#member_id').attr('disabled', true);
                $('#member_id').removeAttr('required', true);
            }
        }

        function getMemberTypes(data){
            const member_types = data != null ? data : '';
            var url = '{{ route('promos.members.types') }}';

            $("#member_types").select2({
                ajax: {
                    url: url,
                    dataType: 'json',
                    delay: 250,
                    cache: true,
                    multiple: true,
                    minimumInputLength: 1,
                    processResults: function(data, params) {
                        return {
                            results: $.map(data, function(item) {
                                return {
                                    text: item.name,
                                    id: item.id
                                }
                            })
                        };
                    },
                },
                dropdownParent: $('#addPromoModal'),
                width: '100%',
            });

            $('#member_types').empty();
            $.map(member_types, function (item) {
                $('#member_types').append('<option value="'+ item.id +'" selected="selected">'+ item.name+'</option>');
            });
            $('#member_types').trigger('change');
        }

        // get members
        function getMembers(data) {
            const members = data != null ? data : '';
            var url = '{{ route('promos.members') }}?filter=';

            $("#member_id").select2({
                ajax: {
                    url: function (params) {
                        return url + params.term;
                    },
                    dataType: 'json',
                    delay: 250,
                    cache: true,
                    multiple: true,
                    minimumInputLength: 1,
                    processResults: function(data, params) {
                        return {
                            results: $.map(data, function(item) {
                                return {
                                    image: item.path,
                                    text: item.firstname + ' ' + item.lastname,
                                    id: item.id
                                }
                            })
                        };
                    },
                },
                templateResult: formatState,
                templateSelection: formatState,
                placeholder: "Search Member",
                dropdownParent: $('#addPromoModal'),
                width: '100%',
            });

            $('#member_id').empty();
            $('#member_id').append('<option value="" selected disabled>Search Member</option>');
            $.map(members, function (item) {
                $('#member_id').append('<option value="'+ item.id +'" selected="selected"><img src="'+ item.path +'" class="rounded-circle mr-1 ml-1" width="30px" height="30px" /> '+ item.firstname + ' ' + item.lastname+'</option>');
            });
            $('#member_id').trigger('change');
        }

        function formatState(opt) {
            var optimage = opt.image;
            if(!optimage){
                var image = "{{ asset('admin_dashboard/img/default.png') }}";
            } else {                    
                var image = "{{ config('app.AWS_BUCKET_URL') }}"+optimage;
            }

            return $('<span><img src="' + image + '" class="rounded-circle mr-1 ml-1" width="30px" height="30px" /> ' + opt.text + '</span>');
        };

        // Date start
        $('#date_start').datepicker({
            autoclose: true,
            todayHighlight: true
        });

        // Date end
        $('#date_end').datepicker({
            autoclose: true,
            todayHighlight: true
        });
    </script>
@endpush