<div id="addPromoModal" class="modal" tabindex="-1" role="dialog" aria-labelledby="vcenter" aria-hidden="true" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <form id="add-promo" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="modal-header">
                    <h4 class="modal-title" id="vcenter">
                        <i class="mdi mdi-plus"></i> Add Promo
                    </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-lg-6 col-12">
                            <div class="form-group">
                                <label class="control-label">
                                    Banner Image <span class="text-danger">(1)</span>
                                </label>
                                <input type="file" class="form-control" name="image"  id="banner" accept="image/*">
                            </div>
                        </div>
                        <div class="col-lg-6 col-12">
                            <div class="form-group">
                                <label class="control-label">
                                    Regular Images <span class="text-danger">(3)</span>
                                </label>
                                <input type="file" class="form-control" name="images[]" multiple accept="image/*">
                            </div>
                        </div>
                        <div class="col-lg-6 col-12">
                            <div class="form-group">
                                <label class="control-label">Voucher Code*</label>
                                <input type="text" class="form-control" name="promo_code" id="promo_code" placeholder="Enter voucher code" required>
                                <input type="hidden" name="promo_id" id="promo_id">
                                <div class="invalid-feedback promo_code"></div>
                            </div>
                        </div>
                        <div class="col-lg-6 col-12">
                            <div class="form-group">
                                <label class="control-label">Item Type*</label>
                                <select class="form-control select" name="item_type" id="item_type" required>
                                    <option value="" selected disabled>Select Item Type</option>
                                    <option value="bundle">Bundle</option>
                                    <option value="discount">Discount</option>
                                    <option value="freebies">Freebies</option>
                                    @role('super_admin')
                                        <option value="points_of_payment">Points as Payment</option>
                                    @endrole
                                    <option value="other">Other</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-lg-6 col-12">
                            <div class="form-group">
                                <label class="control-label">Quantity*</label>
                                <input type="text" class="form-control number" name="quantity" id="quantity" placeholder="Enter quantity" required>
                            </div>
                        </div>
                        <div class="col-lg-6 col-12">
                            <div class="form-group">
                                <label class="control-label">Description*</label>
                                <input type="text" class="form-control" name="description" id="description" placeholder="Enter description" required>
                            </div>
                        </div>
                        <div class="col-lg-6 col-12">
                            <div class="form-group">
                                <label class="control-label">Points Required*</label>
                                <input type="text" class="form-control number" name="points_required" id="points_required" placeholder="Enter points required" required>
                            </div>
                        </div>
                        <div class="col-lg-6 col-12">
                            <div class="form-group">
                                <label class="control-label">Discount*</label>
                                <select class="form-control select" name="discount" id="discount" required>
                                    <option value="" selected disabled>Select Discount</option>
                                    @for ($i = 0; $i < 101; $i++)
                                        <option value="{{ $i }}">{{ $i.'%' }}</option>
                                    @endfor
                                </select>
                            </div>
                        </div>
                        <div class="col-lg-6 col-12">
                            <div class="form-group">
                                <label class="control-label">Price*</label>
                                <input type="text" class="form-control number" name="price" id="price" placeholder="Enter price" required>
                            </div>
                        </div>
                        <div class="col-lg-6 col-12">
                            <div class="form-group">
                                <label class="control-label">Content*</label>
                                <input type="text" class="form-control" name="content" id="content" placeholder="Enter content" required>
                            </div>
                        </div>
                        <div class="col-lg-6 col-12">
                            <div class="form-group">
                                <label class="control-label">Allocation Amount*</label>
                                <input type="text" class="form-control number" name="allocation_amount" id="allocation_amount" placeholder="Enter allocation amount" required>
                            </div>
                        </div>
                        <div class="col-lg-6 col-12">
                            <div class="form-group">
                                <label class="control-label">Remarks*</label>
                                <input type="text" class="form-control" name="remarks" id="remarks" placeholder="Enter remarks" required>
                            </div>
                        </div>
                        <div class="col-lg-6 col-12">
                            <div class="form-group">
                                <label class="control-label">Startdate*</label>
                                <input type="text" class="form-control" name="date_start" id="date_start" placeholder="mm/dd/yyyy" required>
                            </div>
                        </div>
                        <div class="col-lg-6 col-12">
                            <div class="form-group">
                                <label class="control-label">Endate*</label>
                                <input type="text" class="form-control" name="date_end" id="date_end" placeholder="mm/dd/yyyy" required> 
                            </div>
                        </div>      
                        <div class="col-lg-6 col-12">
                            <div class="form-group">
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="is_custom" id="is_custom" value="1">
                                    <label class="custom-control-label" for="is_custom">Custom Promo</label>
                                </div>
                            </div>
                        </div>        
                    </div>
                    <div class="row d-none" id="custom-promo">
                        <div class="col-lg-6 col-12">
                            <div class="form-group">
                                <label class="control-label">Custom Type*</label>
                                <select class="form-control select" name="custom_type" id="custom_type" required>
                                    <option value="" selected disabled>Select Custom Type</option>
                                    <option value="promo_members">Members</option>
                                    <option value="promo_member_types">Member Types</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-12 d-none" id="member_div">
                            <div class="form-group">
                                <label>Members*</label>
                                <select class="form-control multiple" name="member_ids[]" id="member_id" multiple="multiple"></select>
                            </div>
                        </div> 
                        <div class="col-12 d-none" id="member_type_div">
                            <div class="form-group">
                                <label>Member Types*</label>
                                <select class="form-control multiple" name="member_types[]" id="member_types" multiple="multiple">
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger waves-effect" data-dismiss="modal">Cancel</button>
                    <button type="submit" id="save" class="btn btn-info waves-effect">
                        <i class="fa fa-save"></i> Save
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>