@extends('layouts.admin')
@section('title','Merchant Establishments')
@section('styles')
    <style type="text/css">
        #establishmentTable tbody tr td:nth-child(2), 
        #establishmentTable tbody tr td:nth-child(3), 
        #establishmentTable tbody tr td:nth-child(4){
            padding-top: 24px !important;
        }
        #establishmentTable tbody tr td:nth-child(5){
            padding-top: 20px !important;
        }
        /*Fix Autocomplete address in modal*/
        .pac-container {
            z-index: 1051 !important;
        }
        .form-group{
            margin-bottom: .6rem;
        }
    </style>
@endsection

@section('content')

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Establishments</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('dashboard') }}">Home</a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="{{ route('merchants') }}">Merchants</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Establishments</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-4 col-12">
                    <div class="card">
                        <div class="card-body shadow">
                            <div class="row">
                                <div class="col p-r-0 mt-2">
                                    <h5 style="font-weight: 500 !important;">{{ strtoupper($merchant->name) }} </h5>
                                    <h6 class="text-muted text-uppercase">Merchant</h6>
                                </div>
                                <div class="col-4 text-right align-self-center">
                                    <img class="round align-self-center round-success"src="{{ $merchant->path }}" style="width: 54px; height: 54px;">
                                    <br>
                                </div>
                                <div class="col-12 text-right">
                                    <a href="{{ route('merchants.edit', base64_encode($merchant->id)) }}">
                                        <button class="btn btn-info btn-sm mt-2">
                                            <i class="ti-pencil"></i> Edit
                                        </button>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-6 col-12">
                    <h4 class="page-title mt-2">
                        <i class="ti-layout-accordion-merged"></i>
                        List of Establishments (<span id="count">0</span>)
                    </h4>                
                </div>
                <div class="col-lg-6 col-12 text-right">
                    <button class="btn btn-success" onclick="addEstablishment()">
                        <i class="fa fa-plus"></i> Add Establishment
                    </button>       
                </div>
                <div class="col-12 mt-1">
                    <div class="card">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="establishmentTable" class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th width="20%">Establishment Name</th>
                                            <th>Address</th>
                                            <th width="12%">Type</th>
                                            <th width="10%">Status</th>
                                            <th width="10%">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- modal -->
        @include('dashboard.merchants.establishments.partials.add-establishment-modal')

        @include('dashboard.partials.footer')
        
    </div>
    
@endsection

@push('scripts')
    <script type="text/javascript">
       
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        var table = $('#establishmentTable').DataTable({
            ajax: "{{ route('merchants.establishments.list', base64_encode($merchant->id)) }}",
            columns: [
                { data : 'name' },
                { data : 'address' },
                { data : 'merchant_type' },
                { data : 'status' },
                { data : 'action', orderable: false, searchable: false}
            ],
            paging      : true,
            lengthChange: true,
            searching   : true,
            ordering    : false,
            info        : true,
            autoWidth   : false,
            dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                        "<'row'<'col-12'tr>>" +
                        "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
            fnDrawCallback: function () {
                self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                $('#count').text(self.QtdOcorrenciasAgendadosHoje);
            }
        });

        // Modal Add
        function addEstablishment() {
            $('#addEstablishmentModal').modal('show');
            $('#save').removeAttr('disabled',true);
            $('#image').attr('required',true);
            $('#name').removeClass('is-invalid');
            $('.name').removeClass('invalid-feedback');
            $('.name').text('');

            const token = $('input[name="_token"]').val();
            $('#addEstablishmentModal :input').val('');
            $('#addEstablishmentModal select').select2('');
            $('input[name="_token"]').val(token);
            select2();

            var content = "<i class='mdi mdi-plus'></i> Add Establishment";
            $('#vcenter').html(content);
        }

        // Modal Edit
        $('body').on('click','#edit', function(e){
            e.preventDefault();

            $('#save').removeAttr('disabled',true);
            $('#name').removeClass('is-invalid');
            $('.name').removeClass('invalid-feedback');
            $('.name').text('');
            $('#image').val('');
            $('#image').removeAttr('required',true);
            select2();

            var content = "<i class='mdi mdi-table-edit'></i> Edit Establishment";
            $('#vcenter').html(content);

            var url = $(this).attr('href');

            $.ajax({
                type: "GET",
                url: url,
                success: function (response) {
                    $('#name').val(response.name);
                    $('#address').val(response.address);
                    $('#latitude').val(response.latitude);
                    $('#longitude').val(response.longitude);
                    $('#description').val(response.description);
                    $('#establishment_id').val(response.id);

                    $('#merchant_type_id').empty();
                    $('#merchant_type_id').append('<option value="" selected disabled>Select Industry Type</option>');
                    $.each(response.merchant_types, function(id, data) {
                        $('#merchant_type_id').append('<option value="'+ data.id +'" '+ ((response.merchant_type_id == data.id) ? 'selected' : '') +'>'+ data.name +'</option>'); 
                    });

                    $('#addEstablishmentModal').modal('show');
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });

        // Form Add & Update
        $('form').submit( function(e){
            e.preventDefault();

            $('#save').attr('disabled',true);

            const establishment_id = $('#establishment_id').val();

            var url = establishment_id == '' ?  "{{ route('merchants.establishments', base64_encode($merchant->id)) }}" : 
                                    "{{ route('merchants.establishments.update', base64_encode($merchant->id)) }}";

            let form = new FormData(this);

            $.ajax({
                url: url,
                type: 'POST',
                data: form,
                cache: false,
                contentType: false,
                processData: false,
                beforeSend: function(){
                   loadingAjaxPreloader();
                },
                success: function (response) {
                	
                    if (response.message == 'success') {
                        
                        $('#save').removeAttr('disabled',true);
                        $('#addEstablishmentModal').modal('hide');
                        $('#name').removeClass('is-invalid');
                        $('.name').removeClass('invalid-feedback');
                        $('.name').text('');

                        successAjaxPreloader();
                        table.ajax.reload();
                        swal({
                            title: "Success",
                            text: 'Establishment successfully',
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });
                        
                    } else {
                        successAjaxPreloader();
                        console.log(response);
                    }
                },
                error: function(error){
                  console.log(error);
                },
            });
        });

        // Status Activate or Deactivate
        $('body').on('click','#status', function(e){
            e.preventDefault();

            var url = $(this).attr('href');
            var status = $(this).data('status');

            swal({
                title: "Are you sure?",
                text: "Once you "+ status +", it will "+ status+" establishment!",
                type: "warning",
                confirmButtonClass: status == 'Deactivate' ? 'btn-danger' : 'btn-success',
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: status,
                closeOnConfirm: false,
            },
            ()=>{
                $.ajax({
                    type: "POST",
                    url: url,
                    data: {
                        _token: "{{ csrf_token() }}"
                    },
                    success: function (response) {
                        table.ajax.reload();
                        swal({
                            title: status+"d!",
                            text: response.message,
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });
                    },
                    error: function (response) {
                        table.ajax.reload();
                        swal({
                            title: "Cannot be deactivated!",
                            text: response.responseJSON.message,
                            type: "error"
                        });
                    }
                });
            });
        });

        function select2() {
            $('select.select').select2({
                dropdownParent: $('#addEstablishmentModal'),
                width: '100%',
            });
        }

        function initialize() {
            var complete_address = document.getElementById('address');
            var autocomplete = new google.maps.places.Autocomplete(complete_address);
            google.maps.event.addListener(autocomplete, 'place_changed', function () {
                var place = autocomplete.getPlace();
                document.getElementById('latitude').value = place.geometry.location.lat();
                document.getElementById('longitude').value = place.geometry.location.lng();
            });
        }
        google.maps.event.addDomListener(window, 'load', initialize); 
   </script>
@endpush