@extends('layouts.admin')
@section('title','Edit Driver')

@section('content')

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Edit Driver</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('dashboard') }}">Home</a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="{{ route('merchants.drivers') }}">Drivers</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Edit Driver</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <form method="POST" action="{{ route('merchants.drivers.update', base64_encode($driver->user_id)) }}" enctype="multipart/form-data">
                                @csrf
                                <div class="row">
                                   <div class="col-lg-3 col-12">
                                        <label>PHOTO</label>
                                        <input type="file" id="input-file-now-custom-2" name="image" value="{{ old('image')}}" data-default-file="{{ $driver->path }}" class="dropify" data-height="300" data-allowed-file-extensions="jpeg png jpg"/>
                                        @error('image')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                        <p class="mt-2 text-center">Image must be square and at least 500x500 pixels</p>
                                    </div>
                                    <div class="col-lg-9 col-12">
                                        <h4 class="card-title mb-4">Personal Information</h4>
                                        <div class="row">
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>First Name*</label>
                                                <input type="text" class="form-control @error('firstname') is-invalid @enderror" name="firstname" value="{{ old('firstname', $driver->firstname) }}" placeholder="Enter first name" required>
                                                @error('firstname')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                 <label>Middle Name</label>
                                                <input type="text" class="form-control @error('middlename') is-invalid @enderror" name="middlename" value="{{ old('middlename', $driver->middlename) }}" placeholder="Enter middle name">
                                                @error('middlename')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>Last Name*</label>
                                                 <input type="text" class="form-control @error('lastname') is-invalid @enderror" name="lastname" value="{{ old('lastname', $driver->lastname) }}" placeholder="Enter last name" required>
                                                @error('lastname')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Email*</label>
                                                <input type="email" class="form-control @error('email') is-invalid @enderror" value="{{ old('email', $driver->email) }}" placeholder="Enter email" name="email" required>
                                                @error('email')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Mobile No.*</label>
                                                <input type="text" class="form-control @error('contact_number') is-invalid @enderror" value="{{ old('contact_number', $driver->contact_number) }}" placeholder="Enter mobile number" name="contact_number" maxlength="13" required>
                                                @error('contact_number')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Vehicles*</label>
                                                <select class="form-control @error('vehicle_id') is-invalid @enderror" name="vehicle_id" required>
                                                    <option value="" disabled selected> Select Vehicle</option>
                                                    @foreach($vehicles as $vehicle)
                                                        <option value="{{ $vehicle->id }}" {{ old('vehicle_id', $driver->vehicle_id) == $vehicle->id ? 'selected' : ''}} >
                                                            {{ $vehicle->name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                                @error('vehicle_id')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Merchants</label>
                                                <select class="form-control @error('merchant_id') is-invalid @enderror" name="merchant_id">
                                                    <option value="" disabled selected> Select Merchant</option>
                                                    @foreach($merchants as $merchant)
                                                        <option value="{{ $merchant->id }}" {{ old('merchant_id', $driver->merchant_id) == $merchant->id ? 'selected' : ''}} >
                                                            {{ $merchant->name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                                @error('merchant_id')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>

                                            <div class="col-12 form-group">
                                                <h4 class="card-title mt-2">Account Information</h4>
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Username*</label>
                                                <input type="text" class="form-control @error('username') is-invalid @enderror" value="{{ old('username', $driver->username) }}" placeholder="Enter username" name="username" disabled>
                                                @error('username')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                
                                            <div class="col-lg-12 col-12 form-group text-right">
                                                <a href="{{ route('merchants.drivers') }}">
                                                    <button type="button" class="btn btn-danger">
                                                        <i class="mdi mdi-close-circle"></i> Cancel
                                                    </button>
                                                </a>
                                                <button type="submit" class="btn btn-info">
                                                    <i class="fa fa-save"></i> Update
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @include('dashboard.partials.footer')
        
    </div>
    
@endsection


@push('scripts')
    <script type="text/javascript">

        // Select
        $('select').select2({
            width: '100%'
        });  
       
   </script>
@endpush