@extends('layouts.admin')
@section('title','Edit Doctor Schedule')

@section('content')

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Doctor Schedule</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('dashboard') }}">Home</a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="{{ route('merchants.doctors') }}">Doctors</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Edit Doctor Schedule</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-9 col-12">
                    <div class="card">
                        <div class="card-body">
                            <form method="POST" action="{{ route('merchants.doctors.schedules.update', base64_encode($doctor->id)) }}">
                                @csrf
                                <div class="row">
                                    <div class="col-12">
                                        <label class="control-label">Monday</label>                                
                                    </div>
                                    <div class="col-lg-6 col-12">
                                        <div class="row form-group">
                                            <div class="col-12">
                                                <label class="control-label font-weight-light">(4AM - 12PM)</label>
                                            </div>
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="monday[]" value="{{ $doctor->schedules->monday[0] }}" min="04:00" max="12:00">
                                            </div> 
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="monday[]" value="{{ $doctor->schedules->monday[1] }}" min="04:00" max="12:00">
                                            </div>   
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-12">
                                        <div class="row form-group">
                                            <div class="col-12">
                                                <label class="control-label font-weight-light">(1PM - 12:00AM)</label>
                                            </div>
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="monday[]" value="{{ $doctor->schedules->monday[2] }}" min="13:00" max="00:00">
                                            </div> 
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="monday[]" value="{{ $doctor->schedules->monday[3] }}" min="13:00" max="00:00">
                                            </div>   
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12">
                                        <label class="control-label">Tuesday</label>                                
                                    </div>
                                    <div class="col-lg-6 col-12">
                                        <div class="row form-group">
                                            <div class="col-12">
                                                <label class="control-label font-weight-light">(4AM - 12PM)</label>
                                            </div>
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="tuesday[]" value="{{ $doctor->schedules->tuesday[0] }}" min="04:00" max="12:00">
                                            </div> 
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="tuesday[]" value="{{ $doctor->schedules->tuesday[1] }}" min="04:00" max="12:00">
                                            </div>   
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-12">
                                        <div class="row form-group">
                                            <div class="col-12">
                                                <label class="control-label font-weight-light">(1PM - 12:00AM)</label>
                                            </div>
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="tuesday[]" value="{{ $doctor->schedules->tuesday[2] }}" min="13:00" max="00:00">
                                            </div> 
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="tuesday[]" value="{{ $doctor->schedules->tuesday[3] }}" min="13:00" max="00:00">
                                            </div>   
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12">
                                        <label class="control-label">Wednesday</label>                                
                                    </div>
                                    <div class="col-lg-6 col-12">
                                        <div class="row form-group">
                                            <div class="col-12">
                                                <label class="control-label font-weight-light">(4AM - 12PM)</label>
                                            </div>
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="wednesday[]" value="{{ $doctor->schedules->wednesday[0] }}" min="04:00" max="12:00">
                                            </div> 
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="wednesday[]" value="{{ $doctor->schedules->wednesday[1] }}" min="04:00" max="12:00">
                                            </div>   
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-12">
                                        <div class="row form-group">
                                            <div class="col-12">
                                                <label class="control-label font-weight-light">(1PM - 12:00AM)</label>
                                            </div>
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="wednesday[]" value="{{ $doctor->schedules->wednesday[2] }}" min="13:00" max="00:00">
                                            </div> 
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="wednesday[]" value="{{ $doctor->schedules->wednesday[3] }}" min="13:00" max="00:00">
                                            </div>   
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12">
                                        <label class="control-label">Thursday</label>                                
                                    </div>
                                    <div class="col-lg-6 col-12">
                                        <div class="row form-group">
                                            <div class="col-12">
                                                <label class="control-label font-weight-light">(4AM - 12PM)</label>
                                            </div>
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="thursday[]" value="{{ $doctor->schedules->thursday[0] }}" min="04:00" max="12:00">
                                            </div> 
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="thursday[]" value="{{ $doctor->schedules->thursday[1] }}" min="04:00" max="12:00">
                                            </div>   
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-12">
                                        <div class="row form-group">
                                            <div class="col-12">
                                                <label class="control-label font-weight-light">(1PM - 12:00AM)</label>
                                            </div>
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="thursday[]" value="{{ $doctor->schedules->thursday[2] }}" min="13:00" max="00:00">
                                            </div> 
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="thursday[]" value="{{ $doctor->schedules->thursday[3] }}" min="13:00" max="00:00">
                                            </div>   
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12">
                                        <label class="control-label">Friday</label>                                
                                    </div>
                                    <div class="col-lg-6 col-12">
                                        <div class="row form-group">
                                            <div class="col-12">
                                                <label class="control-label font-weight-light">(4AM - 12PM)</label>
                                            </div>
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="friday[]" value="{{ $doctor->schedules->friday[0] }}" min="04:00" max="12:00">
                                            </div> 
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="friday[]" value="{{ $doctor->schedules->friday[1] }}" min="04:00" max="12:00">
                                            </div>   
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-12">
                                        <div class="row form-group">
                                            <div class="col-12">
                                                <label class="control-label font-weight-light">(1PM - 12:00AM)</label>
                                            </div>
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="friday[]" value="{{ $doctor->schedules->friday[2] }}" min="13:00" max="00:00">
                                            </div> 
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="friday[]" value="{{ $doctor->schedules->friday[3] }}" min="13:00" max="00:00">
                                            </div>   
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12">
                                        <label class="control-label">Saturday</label>                                
                                    </div>
                                    <div class="col-lg-6 col-12">
                                        <div class="row form-group">
                                            <div class="col-12">
                                                <label class="control-label font-weight-light">(4AM - 12PM)</label>
                                            </div>
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="saturday[]" value="{{ $doctor->schedules->saturday[0] }}" min="04:00" max="12:00">
                                            </div> 
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="saturday[]" value="{{ $doctor->schedules->saturday[1] }}" min="04:00" max="12:00">
                                            </div>   
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-12">
                                        <div class="row form-group">
                                            <div class="col-12">
                                                <label class="control-label font-weight-light">(1PM - 12:00AM)</label>
                                            </div>
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="saturday[]" value="{{ $doctor->schedules->saturday[1] }}" min="04:00" max="12:00">
                                            </div> 
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="saturday[]" value="{{ $doctor->schedules->saturday[2] }}" min="13:00" max="00:00">
                                            </div>   
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12">
                                        <label class="control-label">Sunday</label>                                
                                    </div>
                                    <div class="col-lg-6 col-12">
                                        <div class="row form-group">
                                            <div class="col-12">
                                                <label class="control-label font-weight-light">(4AM - 12PM)</label>
                                            </div>
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="sunday[]" value="{{ $doctor->schedules->sunday[0] }}" min="04:00" max="12:00">
                                            </div> 
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="sunday[]" value="{{ $doctor->schedules->sunday[1] }}" min="04:00" max="12:00">
                                            </div>   
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-12">
                                        <div class="row form-group">
                                            <div class="col-12">
                                                <label class="control-label font-weight-light">(1PM - 12:00AM)</label>
                                            </div>
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="sunday[]" value="{{ $doctor->schedules->sunday[2] }}" min="13:00" max="00:00">
                                            </div> 
                                            <div class="col-6">
                                                <input type="time" class="form-control" name="sunday[]" value="{{ $doctor->schedules->sunday[3] }}" min="13:00" max="00:00">
                                            </div>   
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12 form-group text-right">
                                        <a href="{{ route('merchants.doctors') }}">
                                            <button type="button" class="btn btn-danger">
                                                <i class="mdi mdi-close-circle"></i> Cancel
                                            </button>
                                        </a>
                                        <button type="submit" class="btn btn-info">
                                            <i class="fa fa-save"></i> Save
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-12">
                    <div class="card">
                        <div class="card-body text-center">
                            <div class="m-b-10 m-t-20">
                                <img src="{{ $doctor->path }}" width="140" class="rounded-circle" alt="doctor" />
                                <h6 class="m-t-20 mb-2">
                                    {{ $doctor->prefix }}.
                                    {{ ucwords($doctor->firstname.' '.$doctor->middlename.' '.$doctor->lastname) }}
                                </h6>
                                <h6 class="text-muted">({{ $doctor->usertype }})</h6>
                            </div>
                        </div>
                        <div class="p-25 border-top">
                            <small class="text-muted">Professional ID</small>
                            <h6>{{ $doctor->professional_id }}</h6>
                            <small class="text-muted">Contact Number</small>
                            <h6>{{ $doctor->contact_number }}</h6>
                            <small class="text-muted">Bio</small>
                            <h6>{{ $doctor->bio ? $doctor->bio : '-' }}</h6>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @include('dashboard.partials.footer')
        
    </div>
    
@endsection