@extends('layouts.admin')
@section('title','Reports')
@section('styles')
    <style type="text/css">
        h6{
            font-weight: 500
        }
    </style>
@endsection

@section('content')

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Reports</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('dashboard') }}">Home</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Reports</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-10 col-12">
                    <h4 class="page-title mt-2">
                        <i class="mdi mdi-file-document"></i>
                        List of Report (<span id="count">0</span>)
                    </h4>                
                </div>
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12">
                                    <form method="get">
                                        <div class="row">
                                            <div class="col-lg-3 col-12">
                                                <h6 class="text-uppercase">Appointments :</h6>
                                                <select class="form-control" name="status" id="status">
                                                    <option value="all">All</option>
                                                    <option value="completed">Completed</option>
                                                    <option value="approved">Approved</option>
                                                    <option value="pending">Pending</option>
                                                    <option value="declined">Declined</option>
                                                    <option value="cancelled">Cancelled</option>
                                                    <option value="ratings">Patient & Ratings</option>
                                                </select>
                                            </div>
                                            <div class="col-lg-4 col-12">
                                                <button class="btn btn-info mt-4 mr-1" type="submit">
                                                    <i class="mdi mdi-filter"></i> Filter
                                                </button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <div class="col-12 mt-4 ">
                                    <div class="table-responsive">
                                        <table id="reportTable" class="table table-hover">
                                            <thead>
                                                <tr>
                                                    <th>Appointment ID</th>
                                                    <th>Date/Time</th>
                                                    <th>Patient</th>
                                                    <th>Reference #</th>
                                                    <th>Status</th>
                                                    <th>Establishment</th>
                                                    <th>Payment</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @include('dashboard.partials.footer')
        
    </div>
    
@endsection

@push('scripts')
    <!-- start - This is for export functionality only -->
    <script src="https://cdn.datatables.net/buttons/1.5.1/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.5.1/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.5.1/js/buttons.print.min.js"></script>

    <script type="text/javascript">
    $(document).ready( function(){
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        initialize();

        function initialize(formData){
            var url = "{{ route('doctors.reports.list') }}";
            url = (formData != null) ? url + "?" + formData : url;

            $('#reportTable').DataTable({
                ajax        : url,
                columns     : columns(formData),
                paging      : true,
                lengthChange: true,
                searching   : true,
                ordering    : false,
                info        : true,
                autoWidth   : false,
                destroy     : true,
                buttons     : ['csv', 'excel', 'print'],
                dom         : "<'row'<'col-lg-6 col-12 col-md-6'B><'col-lg-6 col-12'f>>" +
                            "<'row'<'col-12'tr>>" +
                            "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
                fnDrawCallback: function () {
                    self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                    $('#count').text(self.QtdOcorrenciasAgendadosHoje);

                    if (self.QtdOcorrenciasAgendadosHoje < 1)  {
                        $('.dt-buttons').addClass('d-none');
                    } else {
                        $('.dt-buttons').removeClass('d-none');
                    }
                }
            });

            $('.buttons-csv, .buttons-print, .buttons-excel').addClass('btn btn-success mr-1');
        }

        function columns(formData) {
            if (formData != 'status=ratings') {
                return [
                    { data : 'appointment_id' },
                    { data : 'date_time' },
                    { data : 'name' },
                    { data : 'reference_id' },
                    { data : 'status' },
                    { data : 'establishment' },
                    { data : 'payment_method' },
                ];
            } else {
                return [
                    { data : 'reference_id' },
                    { data : 'name' },
                    { data : 'pending' },
                    { data : 'approved' },
                    { data : 'completed' },
                    { data : 'cancelled' },
                    { data : 'declined' },
                ];
            }
        }

        // Form Get Submit
        $('form').submit( function(e){
            e.preventDefault();
            var formData = $(this).serialize();

            if (formData != 'status=ratings') {
                $('#reportTable thead tr').empty();
                $('#reportTable thead tr').append('<th>Appointment ID</th><th>Date/Time</th><th>Patient</th><th>Reference #</th><th>Status</th><th>Establishment</th><th>Payment</th>');
            } else {
                $('#reportTable thead tr').empty();
                $('#reportTable thead tr').append('<th>Patient ID</th><th>Name</th><th>Pending</th><th>Approved</th><th>Completed</th><th>Cancelled</th><th>Declined</th>');
            }

            initialize(formData);
        });

        $('#status').select2({
            width  : '100%',
        });
    });
    </script>
@endpush