@extends('layouts.admin')
@section('title','Doctors')
@section('styles')
    <style type="text/css">
        tbody tr td:nth-child(1), 
        tbody tr td:nth-child(3), 
        tbody tr td:nth-child(4), 
        tbody tr td:nth-child(5){
            padding-top: 24px !important;
        }
        tbody tr td:nth-child(6){
            padding-top: 20px !important;
        }
        .form-group{
            margin-bottom: .6rem;
        }
    </style>
@endsection

@section('content')

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Doctors</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('dashboard') }}">Home</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Doctors</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-6 col-12">
                    <h4 class="page-title mt-2">
                        <i class="mdi mdi-account-multiple-plus"></i>
                        List of Doctors (<span id="count">0</span>)
                    </h4>                
                </div>
                <div class="col-lg-6 col-12 text-right">
                    <a href="{{ route('merchants.doctors.add') }}">
                        <button class="btn btn-success">
                            <i class="mdi mdi-account-plus"></i> Add Doctor
                        </button>  
                    </a>  
                </div>
                
                <div class="col-12 mt-1">
                    <div class="card">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="doctorTable" class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Doctors ID</th>
                                            <th>Name</th>
                                            <th>Email</th>
                                            <th>Specialities</th>
                                            <th>Status</th>
                                            <th width="10%">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- view doctors modal -->
        @include('dashboard.merchants.doctors.partials.view-doctors-modal')

        @include('dashboard.partials.footer')
        
    </div>
    
@endsection

@push('scripts')
   <script type="text/javascript">
        
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        var table = $('#doctorTable').DataTable({
            ajax: "{{ route('merchants.doctors.list') }}",
            columns: [
                { data : 'professional_id' },
                { data : 'name' },
                { data : 'email' },
                { data : 'specialities' },
                { data : 'status' },
                { data : 'action', orderable: false, searchable: false}
            ],
            paging      : true,
            lengthChange: true,
            searching   : true,
            ordering    : false,
            info        : true,
            autoWidth   : false,
            dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                        "<'row'<'col-12'tr>>" +
                        "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
            fnDrawCallback: function () {
                self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                $('#count').text(self.QtdOcorrenciasAgendadosHoje);
            }
        });

        // view modal
        $('body').on('click', '#view', function(e){
            e.preventDefault();

            var url = $(this).attr('href');
            
            $.ajax({
                type: "GET",
                url: url,
                success: function (response) {
                    $('#image').attr('src',response.path);
                    $('#name').text(response.name);
                    $('#email').text(response.email);
                    $('#usertype').text(response.usertype);
                    $('#username').text(response.username);
                    $('#professional_id').text(response.professional_id);
                    $('#contact_number').text(response.contact_number);
                    $('#consulation_fee').text('₱'+response.minimum_consultation_fee+' - '+'₱'+response.maximum_consultation_fee);
                    $('#specialities').text(response.specialities);

                    // schedules
                    const no_schedules = '<span class="text-danger">No Schedules</span>';
                    $('#monday').html(response.schedules.monday ? response.schedules.monday : no_schedules);
                    $('#tuesday').html(response.schedules.tuesday ? response.schedules.tuesday : no_schedules);
                    $('#wednesday').html(response.schedules.wednesday ? response.schedules.wednesday : no_schedules);
                    $('#thursday').html(response.schedules.thursday ? response.schedules.thursday : no_schedules);
                    $('#friday').html(response.schedules.friday ? response.schedules.friday : no_schedules);
                    $('#saturday').html(response.schedules.saturday ? response.schedules.saturday : no_schedules);
                    $('#sunday').html(response.schedules.sunday ? response.schedules.sunday : no_schedules);

                    $('#user_status').empty();
                    if (response.status == 1) {
                        $('#user_status').append('<i class="mdi mdi-checkbox-blank-circle text-success mr-2"></i> Active');
                    } else {
                        $('#user_status').append('<i class="mdi mdi-checkbox-blank-circle text-danger mr-2"></i> Not Active');
                    }
                    $('#created_at').text(response.date_registered);
                    $('#viewDoctorModal').modal('show');
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });

        // Status Activate or Deactivate
        $('body').on('click','#status', function(e){
            e.preventDefault();

            var url = $(this).attr('href');
            var status = $(this).data('status');

            swal({
                title: "Are you sure?",
                text: "Once you "+ status +", it will "+ status+" doctor!",
                type: "warning",
                confirmButtonClass: status == 'Deactivate' ? 'btn-danger' : 'btn-success',
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: status,
                closeOnConfirm: false,
            },
            ()=>{
                $.ajax({
                    type: "POST",
                    url: url,
                    data: {
                        _token: "{{ csrf_token() }}"
                    },
                    success: function (response) {
                        table.ajax.reload();
                        swal({
                            title: status+"d!",
                            text: response.message,
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });
                    },
                    error: function (response) {
                        swal('Error!', response, 'danger');
                    }
                });
            });
        });

        // User Reset Password
        $('body').on('click','#resetPassword', function(e){
            e.preventDefault();

            var url = $(this).attr('href');

            swal({
                title: "Are you sure?",
                text: 'Once you Reset Password, it will reset the doctor password to "pplus2020"',
                type: "warning",
                confirmButtonClass: 'btn-danger',
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: 'Reset',
                closeOnConfirm: false,
            },
            ()=>{
                $.ajax({
                    type: "POST",
                    url: url,
                    data: {
                        _token: "{{ csrf_token() }}"
                    },
                    success: function (response) {
                        table.ajax.reload();
                        swal({
                            title: "Success",
                            text: response.message,
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });
                    },
                    error: function (response) {
                        swal('Error!', response, 'danger');
                    }
                });
            });
        });

   </script>
@endpush