@extends('layouts.admin')
@section('title','Edit Doctor')

@section('content')

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Edit Doctor</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('dashboard') }}">Home</a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="{{ route('merchants.doctors') }}">Doctors</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Edit Doctor</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <form method="POST" action="{{ route('merchants.doctors.update', base64_encode($doctor->user_id)) }}" enctype="multipart/form-data">
                                @csrf
                                <div class="row">
                                   <div class="col-lg-3 col-12">
                                        <label>PHOTO</label>
                                        <input type="file" id="input-file-now-custom-2" name="image" value="{{ old('image')}}" data-default-file="{{ $doctor->path }}" class="dropify" data-height="300" data-allowed-file-extensions="jpeg png jpg"/>
                                        @error('image')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                        <p class="mt-2 text-center">Image must be square and at least 500x500 pixels</p>
                                    </div>
                                    <div class="col-lg-9 col-12">
                                        <h4 class="card-title mb-4">Personal Information</h4>
                                        <div class="row">
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>First Name*</label>
                                                <input type="text" class="form-control @error('firstname') is-invalid @enderror" name="firstname" value="{{ old('firstname', $doctor->firstname) }}" placeholder="Enter first name" required>
                                                @error('firstname')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                 <label>Middle Name</label>
                                                <input type="text" class="form-control @error('middlename') is-invalid @enderror" name="middlename" value="{{ old('middlename', $doctor->middlename) }}" placeholder="Enter middle name">
                                                @error('middlename')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>Last Name*</label>
                                                 <input type="text" class="form-control @error('lastname') is-invalid @enderror" name="lastname" value="{{ old('lastname', $doctor->lastname) }}" placeholder="Enter last name" required>
                                                @error('lastname')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>Prefix*</label>
                                                <input type="text" class="form-control @error('prefix') is-invalid @enderror" value="{{ old('prefix', $doctor->prefix) }}" placeholder="Enter prefix" name="prefix" required>
                                                @error('prefix')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>Email*</label>
                                                <input type="email" class="form-control @error('email') is-invalid @enderror" value="{{ old('email', $doctor->email) }}" placeholder="Enter email" name="email" required>
                                                @error('email')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>Mobile No.*</label>
                                                <input type="text" class="form-control @error('contact_number') is-invalid @enderror" value="{{ old('contact_number', $doctor->contact_number) }}" placeholder="Enter mobile number" name="contact_number" maxlength="13" required>
                                                @error('contact_number')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Minimum Consultation Fee*</label>
                                                <input type="text" class="form-control number @error('minimum_consultation_fee') is-invalid @enderror" value="{{ old('minimum_consultation_fee', $doctor->minimum_consultation_fee) }}" placeholder="0.00" name="minimum_consultation_fee" required>
                                                @error('minimum_consultation_fee')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Maximum Consultation Fee*</label>
                                                <input type="text" class="form-control number @error('maximum_consultation_fee') is-invalid @enderror" value="{{ old('maximum_consultation_fee', $doctor->maximum_consultation_fee) }}" placeholder="0.00" name="maximum_consultation_fee" required>
                                                @error('maximum_consultation_fee')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Specialities*</label>
                                                <select class="form-control multiple" name="doctor_specialities[]" id="doctor_specialities" multiple="multiple" required>
                                                    @foreach($specialities as $speciality)
                                                        @if (is_array(old('doctor_specialities')))
                                                            <option value="{{ $speciality->id }}" {{ in_array($speciality->id, old('doctor_specialities')) ? 'selected' : '' }}>
                                                                {{ ucwords($speciality->name) }}
                                                            </option>
                                                        @else
                                                            <option value="{{ $speciality->id }}" {{ in_array($speciality->id, $doctor->specialities) ? 'selected' : ''}}>
                                                                {{ ucwords($speciality->name) }}
                                                            </option>
                                                        @endif
                                                    @endforeach
                                                </select>
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>HMO*</label>
                                                <select class="form-control multiple" name="doctor_payment_methods[]" id="doctor_payment_methods" multiple="multiple" required>
                                                    @if (is_array(old('doctor_payment_methods')))
                                                        <option value="maxicare" {{ in_array('maxicare', old('doctor_payment_methods')) ? 'selected' : '' }}>Maxicare</option>
                                                        <option value="life_insurance" {{ in_array('life_insurance', old('doctor_payment_methods')) ? 'selected' : '' }}>Life Insurance</option>
                                                        <option value="asian_care" {{ in_array('asian_care', old('doctor_payment_methods')) ? 'selected' : '' }}>Asian Care</option>
                                                        <option value="coco_life" {{ in_array('coco_life', old('doctor_payment_methods')) ? 'selected' : '' }}>Coco Life</option>
                                                    @else
                                                        <option value="maxicare" {{ in_array('maxicare', $doctor->payment_methods) ? 'selected' : ''}}>Maxicare</option>
                                                        <option value="life_insurance" {{ in_array('life_insurance', $doctor->payment_methods) ? 'selected' : ''}}>Life Insurance</option>
                                                        <option value="asian_care" {{ in_array('asian_care', $doctor->payment_methods) ? 'selected' : ''}}>Asian Care</option>
                                                        <option value="coco_life" {{ in_array('coco_life', $doctor->payment_methods) ? 'selected' : ''}}>Coco Life</option>
                                                    @endif
                                                </select>
                                            </div>
                                            
                                            <div class="col-12 form-group">
                                                <h4 class="card-title mt-2">Account Information</h4>
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Username*</label>
                                                <input type="text" class="form-control @error('username') is-invalid @enderror" value="{{ old('username', $doctor->username) }}" placeholder="Enter username" name="username" disabled>
                                                @error('username')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                
                                            <div class="col-lg-12 col-12 form-group text-right">
                                                <a href="{{ route('merchants.doctors') }}">
                                                    <button type="button" class="btn btn-danger">
                                                        <i class="mdi mdi-close-circle"></i> Cancel
                                                    </button>
                                                </a>
                                                <button type="submit" class="btn btn-info">
                                                    <i class="fa fa-save"></i> Update
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @include('dashboard.partials.footer')
        
    </div>
    
@endsection

@push('scripts')
    <script type="text/javascript">
        
       // All select option
        $('select').select2({
            width : '100%'
        });

   </script>
@endpush