@extends('layouts.admin')
@section('title','Appointments')
@section('styles')
    <style type="text/css">
        tbody tr td:nth-child(2), 
        tbody tr td:nth-child(3), 
        tbody tr td:nth-child(4), 
        tbody tr td:nth-child(5){
            padding-top: 24px !important;
        }
        tbody tr td:nth-child(6){
            padding-top: 20px !important;
        }
        .form-group{
            margin-bottom: .4rem;
        }
    </style>
@endsection

@section('content')

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Appointments</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('dashboard') }}">Home</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Appointments</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-6 col-12">
                    <h4 class="page-title mt-2">
                        <i class="mdi mdi-calendar-text"></i>
                        List of Appointments 
                    </h4>                
                </div>
                <div class="col-12 mt-1">
                    <div class="card">
                        <div class="card-body">
                            <ul class="nav nav-tabs" role="tablist">
                                <li class="nav-item"> 
                                    <a class="nav-link active" data-toggle="tab" href="#all" role="tab">
                                        <span class="hidden-xs-down"> 
                                            All (<span id="all_count">0</span>)
                                        </span>
                                    </a>
                                </li>
                                <li class="nav-item"> 
                                    <a class="nav-link" data-toggle="tab" href="#pending" role="tab">
                                        <span class="hidden-xs-down"> 
                                            Pending (<span id="pending_count">0</span>)
                                        </span>
                                    </a> 
                                </li>
                                <li class="nav-item"> 
                                    <a class="nav-link" data-toggle="tab" href="#approved" role="tab">
                                        <span class="hidden-xs-down"> 
                                            Approved (<span id="approved_count">0</span>)
                                        </span>
                                    </a> 
                                </li>
                                <li class="nav-item"> 
                                    <a class="nav-link" data-toggle="tab" href="#completed" role="tab">
                                        <span class="hidden-xs-down"> 
                                            Completed (<span id="completed_count">0</span>)
                                        </span>
                                    </a> 
                                </li>
                                <li class="nav-item"> 
                                    <a class="nav-link" data-toggle="tab" href="#cancelled" role="tab">
                                        <span class="hidden-xs-down"> 
                                            Cancelled (<span id="cancelled_count">0</span>)
                                        </span>
                                    </a> 
                                </li>
                                <li class="nav-item"> 
                                    <a class="nav-link" data-toggle="tab" href="#declined" role="tab">
                                        <span class="hidden-xs-down"> 
                                            Declined (<span id="declined_count">0</span>)
                                        </span>
                                    </a> 
                                </li>
                            </ul>
                            <!-- Tab panes -->
                            <div class="tab-content tabcontent-border">
                                <div class="tab-pane active" id="all" role="tabpanel">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="table-responsive mt-4">
                                                <table id="allTable" class="table table-hover order-table">
                                                    <thead>
                                                        <tr>
                                                            <th>Patient Name</th>
                                                            <th>Reference #</th>
                                                            <th>Date/Time</th>
                                                            <th>Payment</th>
                                                            <th>Status</th>
                                                            <th width="10%">Action</th>
				                                        </tr>
                                                    </thead>
                                                    <tbody>
                            							<tr>
                            								<th>All</th>
                            							</tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane" id="pending" role="tabpanel">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="table-responsive mt-4">
                                                <table id="pendingTable" class="table table-hover order-table">
                                                    <thead>
                                                        <tr>
				                                            <th>Patient Name</th>
				                                            <th>Reference #</th>
                                                            <th>Date/Time</th>
                                                            <th>Payment</th>
				                                            <th>Status</th>
				                                            <th width="10%">Action</th>
				                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                    	<tr>
                            								<th>Pending</th>
                            							</tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane" id="approved" role="tabpanel">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="table-responsive mt-4">
                                                <table id="approvedTable" class="table table-hover order-table">
                                                    <thead>
                                                        <tr>
                                                            <th>Patient Name</th>
                                                            <th>Reference #</th>
                                                            <th>Date/Time</th>
                                                            <th>Payment</th>
                                                            <th>Status</th>
                                                            <th width="10%">Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <th>Approved</th>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane" id="completed" role="tabpanel">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="table-responsive mt-4">
                                                <table id="completedTable" class="table table-hover order-table">
                                                    <thead>
                                                        <tr>
                                                            <th>Patient Name</th>
                                                            <th>Reference #</th>
                                                            <th>Date/Time</th>
                                                            <th>Payment</th>
                                                            <th>Status</th>
                                                            <th width="10%">Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <th>Completed</th>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane" id="cancelled" role="tabpanel">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="table-responsive mt-4">
                                                <table id="cancelledTable" class="table table-hover order-table">
                                                    <thead>
                                                        <tr>
                                                            <th>Patient Name</th>
                                                            <th>Reference #</th>
                                                            <th>Date/Time</th>
                                                            <th>Payment</th>
                                                            <th>Status</th>
                                                            <th width="10%">Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <th>Cancelled</th>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane" id="declined" role="tabpanel">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="table-responsive mt-4">
                                                <table id="declinedTable" class="table table-hover order-table">
                                                    <thead>
                                                        <tr>
                                                            <th>Patient Name</th>
                                                            <th>Reference #</th>
                                                            <th>Date/Time</th>
                                                            <th>Payment</th>
                                                            <th>Status</th>
                                                            <th width="10%">Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <th>Declined</th>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- modal -->
        @include('dashboard.merchants.doctors.partials.view-appointments-modal')

        @include('dashboard.partials.footer')
        
    </div>
    
@endsection

@push('scripts')
    <script src="{{ asset('admin_dashboard/assets/libs/moment/moment.js') }}"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/plug-ins/1.10.21/api/sum().js"></script>
    <script type="text/javascript">
        
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        var allTable = $('#allTable').DataTable({
            ajax: "{{ route('doctors.appointments.list') }}",
            columns: [
                { data : 'name' },
                { data : 'reference_id' },
                { data : 'date_time' },
                { data : 'payment_method' },
                { data : 'status' },
                { data : 'action', orderable: false, searchable: false}
            ],
            paging      : true,
            lengthChange: true,
            searching   : true,
            ordering    : false,
            info        : true,
            autoWidth   : false,
            dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                        "<'row'<'col-12'tr>>" +
                        "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
            fnDrawCallback: function () {
                self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                $('#all_count').text(self.QtdOcorrenciasAgendadosHoje);
            }
        });

        var approvedTable = $('#approvedTable').DataTable({
            ajax: "{{ route('doctors.appointments.list','status=approved') }}",
            columns: [
                { data : 'name' },
                { data : 'reference_id' },
                { data : 'date_time' },
                { data : 'payment_method' },
                { data : 'status' },
                { data : 'action', orderable: false, searchable: false}
            ],
            paging      : true,
            lengthChange: true,
            searching   : true,
            ordering    : false,
            info        : true,
            autoWidth   : false,
            dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                        "<'row'<'col-12'tr>>" +
                        "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
            fnDrawCallback: function () {
                self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                $('#approved_count').text(self.QtdOcorrenciasAgendadosHoje);
            }
        });

        var pendingTable = $('#pendingTable').DataTable({
            ajax: "{{ route('doctors.appointments.list','status=pending') }}",
            columns: [
                { data : 'name' },
                { data : 'reference_id' },
                { data : 'date_time' },
                { data : 'payment_method' },
                { data : 'status' },
                { data : 'action', orderable: false, searchable: false}
            ],
            paging      : true,
            lengthChange: true,
            searching   : true,
            ordering    : false,
            info        : true,
            autoWidth   : false,
            dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                        "<'row'<'col-12'tr>>" +
                        "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
            fnDrawCallback: function () {
                self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                $('#pending_count').text(self.QtdOcorrenciasAgendadosHoje);
            }
        });

        var completedTable = $('#completedTable').DataTable({
            ajax: "{{ route('doctors.appointments.list','status=completed') }}",
            columns: [
                { data : 'name' },
                { data : 'reference_id' },
                { data : 'date_time' },
                { data : 'payment_method' },
                { data : 'status' },
                { data : 'action', orderable: false, searchable: false}
            ],
            paging      : true,
            lengthChange: true,
            searching   : true,
            ordering    : false,
            info        : true,
            autoWidth   : false,
            dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                        "<'row'<'col-12'tr>>" +
                        "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
            fnDrawCallback: function () {
                self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                $('#completed_count').text(self.QtdOcorrenciasAgendadosHoje);
            }
        });

        var cancelledTable = $('#cancelledTable').DataTable({
            ajax: "{{ route('doctors.appointments.list','status=cancelled') }}",
            columns: [
                { data : 'name' },
                { data : 'reference_id' },
                { data : 'date_time' },
                { data : 'payment_method' },
                { data : 'status' },
                { data : 'action', orderable: false, searchable: false}
            ],
            paging      : true,
            lengthChange: true,
            searching   : true,
            ordering    : false,
            info        : true,
            autoWidth   : false,
            dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                        "<'row'<'col-12'tr>>" +
                        "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
            fnDrawCallback: function () {
                self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                $('#cancelled_count').text(self.QtdOcorrenciasAgendadosHoje);
            }
        });

        var declinedTable = $('#declinedTable').DataTable({
            ajax: "{{ route('doctors.appointments.list','status=declined') }}",
            columns: [
                { data : 'name' },
                { data : 'reference_id' },
                { data : 'date_time' },
                { data : 'payment_method' },
                { data : 'status' },
                { data : 'action', orderable: false, searchable: false}
            ],
            paging      : true,
            lengthChange: true,
            searching   : true,
            ordering    : false,
            info        : true,
            autoWidth   : false,
            dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                        "<'row'<'col-12'tr>>" +
                        "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
            fnDrawCallback: function () {
                self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                $('#declined_count').text(self.QtdOcorrenciasAgendadosHoje);
            }
        });

        // view modal
        $('body').on('click', '#view', function(e){
            e.preventDefault();

            var url = $(this).attr('href');
            
            $.ajax({
                type: "GET",
                url: url,
                beforeSend: function(){
                   loadingAjaxPreloader();
                },
                success: function (response) {

                    $('#image').attr('src',response.path);
                    $('#name').text(response.name);
                    $('#email').text(response.email);
                    $('#mobile_number').text(response.mobile_number);
                    $('#birthdate').text(response.birthdate);
                    $('#gender').text(response.gender);
                    $('#marital_status').text(response.marital_status);
                    $('#citizenship').text(response.citizenship);
                    $('#notes').text(response.notes);
                    $('#reference_number').text(response.reference_id);
                    $('#schedule').text(response.date_time);
                    $('#date_requested').text(response.date_requested);
                    $('#date_updated').text(response.date_updated);
                    $('#payment_method').text(response.payment_method);
                    $('#hmo').text(response.hmo);
                    $('#status').html(getStatusColor(response.status));
                    $('#actions').html(getActionButton(response.status, response.id));
                    $('#viewAppointmentModal').modal('show');
                    successAjaxPreloader();
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });

        // reload all table
        function ajaxReloadTable(){
            allTable.ajax.reload();
            approvedTable.ajax.reload();
            pendingTable.ajax.reload();
            completedTable.ajax.reload();
            cancelledTable.ajax.reload();
            declinedTable.ajax.reload();
        }

        // complete appointment
        $('body').on('click', '#btn_complete', function(e){
            e.preventDefault();
            
            var url = $(this).attr('href');

            swal({
                title: "Are you sure?",
                text: "Once Completed, it will complete the appointment!",
                type: "warning",
                confirmButtonClass: 'btn-info',
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: 'Complete',
                closeOnConfirm: false,
            },
            ()=>{
                $.ajax({
                    type: "POST",
                    url: url,
                    data: {
                        _token: "{{ csrf_token() }}",
                        status: 'completed'
                    },                    
                    success: function (response) {
                        ajaxReloadTable();
                        swal({
                            title: "Complete!",
                            text: 'Appointment successfully updated!',
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });
                        $('#viewAppointmentModal').modal('hide');
                    },
                    error: function (response) {
                        swal('Error!', response, 'danger');
                    }
                });
            });
        });

        // approved appointment
        $('body').on('click', '#btn_approved', function(e){
            e.preventDefault();
            
            var url = $(this).attr('href');

            swal({
                title: "Are you sure?",
                text: "Once you Approved, it will approved appointment!",
                type: "warning",
                confirmButtonClass: 'btn-info',
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: 'Approved',
                closeOnConfirm: false,
            },
            ()=>{
                $.ajax({
                    type: "POST",
                    url: url,
                    data: {
                        _token: "{{ csrf_token() }}",
                        status: 'approved'
                    },                    
                    success: function (response) {
                        ajaxReloadTable();
                        swal({
                            title: "Approved!",
                            text: 'Appointment successfully updated!',
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });
                        $('#viewAppointmentModal').modal('hide');
                    },
                    error: function (response) {
                        swal('Error!', response, 'danger');
                    }
                });
            });
        });

        // cancelled appointment
        $('body').on('click', '#btn_declined', function(e){
            e.preventDefault();
            
            var url = $(this).attr('href');

            swal({
                title: "Are you sure?",
                text: "Once you Declined, it will declined appointment!",
                type: "warning",
                confirmButtonClass: 'btn-danger',
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: 'Declined',
                closeOnConfirm: false,
            },
            ()=>{
                $.ajax({
                    type: "POST",
                    url: url,
                    data: {
                        _token: "{{ csrf_token() }}",
                        status: 'declined'
                    },
                    success: function (response) {
                        ajaxReloadTable();
                        swal({
                            title: "Declined!",
                            text: 'Appointment declined successfully',
                            type: "success",
                            showConfirmButton: false,
                            timer: 1500
                        });
                        
                        $('#viewAppointmentModal').modal('hide');
                    },
                    error: function (response) {
                        console.log('Error:', response);
                    }
                });
            });
        });

        function getActionButton(status, id) {
            let action = '';
            var url = '{{ route('doctors.appointments.update', ':id') }}';
            if (status == 'pending') {
                action += '<div class="row">';
                    action += '<div class="col-6 pr-1">';
                        action += '<a href='+url.replace(':id', btoa(id))+' id="btn_declined">';
                            action += '<button type="button" class="btn btn-danger btn-block"> Decline </button>';
                        action += '</a>';
                    action += '</div>';
                    action += '<div class="col-6 pl-1">';
                        action += '<a href='+url.replace(':id', btoa(id))+' id="btn_approved">';
                            action += '<button class="btn btn-info btn-block"> Accept </button>';
                        action += '</a>';
                    action += '</div>';
                action += '</div>';
            } 

            if (status == 'approved') {
                action += '<div class="row">';
                    action += '<div class="col-6 pr-1">';
                        action += '<a href='+url.replace(':id', btoa(id))+' id="btn_declined">';
                            action += '<button type="button" class="btn btn-danger btn-block"> Cancel </button>';
                        action += '</a>';
                    action += '</div>';
                    action += '<div class="col-6 pl-1">';
                        action += '<a href='+url.replace(':id', btoa(id))+' id="btn_complete">';
                            action += '<button class="btn btn-info btn-block"> Complete </button>';
                        action += '</a>';
                    action += '</div>';
                action += '</div>';
            } 
            return action;
        }

        function getStatusColor(status) {
            if (status == 'pending') {
                status = '<i class="mdi mdi-checkbox-blank-circle text-warning"></i> Pending' ;
            } else if (status == 'approved') {
                status = '<i class="mdi mdi-checkbox-blank-circle text-info"></i> Approved';
            } else if (status == 'completed'){
                status = '<i class="mdi mdi-checkbox-blank-circle text-success"></i> Completed';
            } else {
                status = '<i class="mdi mdi-checkbox-blank-circle text-danger"></i> <span class="text-capitalize">'+status+'</span>';
            }
            return status;
        }

   </script>
@endpush