@extends('layouts.admin')
@section('title','Customers')
@section('styles')
    <style type="text/css">
        #customerTable tbody tr td:nth-child(1), 
        #customerTable tbody tr td:nth-child(3), 
        #customerTable tbody tr td:nth-child(4), 
        #customerTable tbody tr td:nth-child(5){
            padding-top: 24px !important;
        }
        #customerTable tbody tr td:nth-child(6){
            padding-top: 20px !important;
        }
        .form-group{
            margin-bottom: .6rem;
        }
    </style>
@endsection

@section('content')

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Customers</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('dashboard') }}">Home</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Customers</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-6 col-12">
                    <h4 class="page-title mt-2">
                        <i class="mdi mdi-account-multiple"></i>
                        List of Customers
                    </h4>    
                </div>
                <div class="col-12 mt-1">
                    <div class="card">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="customerTable" class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Member ID</th>
                                            <th>Name</th>
                                            <th>Address</th>
                                            <th>PrimaryPlus Member</th>
                                            <th>Status</th>
                                            <th width="10%">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- view customers modal -->
        @include('dashboard.merchants.customers.partials.view-customer-modal')

        @include('dashboard.merchants.customers.partials.view-transactions-modal')

        @include('dashboard.partials.footer')
        
    </div>
    
@endsection

@push('scripts')
   <script type="text/javascript">
        
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        var table = $('#customerTable').DataTable({
            ajax: "{{ route('merchants.customers.list') }}",
            columns: [
                { data : 'member_id' },
                { data : 'name' },
                { data : 'address' },
                { data : 'member_status' },
                { data : 'status' },
                { data : 'action', orderable: false, searchable: false}
            ],
            paging      : true,
            lengthChange: true,
            searching   : true,
            ordering    : false,
            info        : true,
            autoWidth   : false,
            dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                        "<'row'<'col-12'tr>>" +
                        "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
            fnDrawCallback: function () {
                self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                $('#count').text(self.QtdOcorrenciasAgendadosHoje);
            }
        });

        // view modal
        $('body').on('click', '#view', function(e){
            e.preventDefault();

            var url = $(this).attr('href');
            
            $.ajax({
                type: "GET",
                url: url,
                success: function (response) {
                    $('#image').attr('src',response.path);
                    $('#name').text(response.name);
                    $('#email').text(response.email);
                    $('#mobile_number').text(response.mobile_number);
                    $('#address').text(response.address);
                    $('#birthdate').text(response.birth_date);
                    $('#gender').text(response.gender);
                    $('#marital_status').text(response.marital_status);
                    $('#citizenship').text(response.citizenship);
                    $('#registration_status').text((response.registration_status == 'unverified') ? 'NON-MEMBER' : 'MEMBER');
                    $('#viewCustomerModal').modal('show');
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });

        $('body').on('click', '#transactions', function(e){
            e.preventDefault();

            var url = $(this).attr('href');

            $('#transactionTable').DataTable({
                ajax: url,
                columns: [
                    { data : 'reference_id' },
                    { data : 'updated_at' },
                    { data : 'status' },
                ],
                serverSide  : true,
                processing  : true,
                paging      : true,
                lengthChange: false,
                searching   : true,
                ordering    : false,
                info        : true,
                autoWidth   : false,
                destroy     : true,
                dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                        "<'row'<'col-12'tr>>" +
                        "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
                fnDrawCallback: function () {
                    self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                    $('#transaction_count').text(self.QtdOcorrenciasAgendadosHoje);
                }
            });
            $('#viewTransactionModal').modal('show');
        });

   </script>
@endpush