@extends('layouts.admin')
@section('title','Edit Member')

@section('content')

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Edit Member</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('dashboard') }}">Home</a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="{{ route('members') }}">Members</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Edit Member</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <form method="POST" action="{{ route('members.update', base64_encode($member->user_id)) }}" enctype="multipart/form-data">
                                @csrf
                                <div class="row">
                                   <div class="col-lg-3 col-12">
                                        <label>PHOTO</label>
                                        <input type="file" id="input-file-now-custom-2" name="image" data-default-file="{{ $member->path }}" value="{{ old('image')}}" class="dropify" data-height="300" data-allowed-file-extensions="jpeg png jpg"/>
                                        @error('image')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                        <p class="mt-2 text-center">Image must be square and at least 500x500 pixels</p>
                                    </div>
                                    <div class="col-lg-9 col-12">
                                        <h4 class="card-title mb-4">Personal Information</h4>
                                        <div class="row">
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>First Name*</label>
                                                <input type="text" class="form-control @error('firstname') is-invalid @enderror" name="firstname" value="{{ old('firstname', $member->firstname) }}" placeholder="Enter first name" required>
                                                @error('firstname')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                 <label>Middle Name</label>
                                                <input type="text" class="form-control @error('middlename') is-invalid @enderror" name="middlename" value="{{ old('middlename', $member->middlename) }}" placeholder="Enter middle name">
                                                @error('middlename')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>Last Name*</label>
                                                 <input type="text" class="form-control @error('lastname') is-invalid @enderror" name="lastname" value="{{ old('lastname', $member->lastname) }}" placeholder="Enter last name" required>
                                                @error('lastname')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>Birth Date*</label>
                                                <input type="text" class="form-control @error('birthdate') is-invalid @enderror" value="{{ old('birthdate', $member->birthdate->format('m/d/Y') ) }}" name="birthdate" id="birthdate" required>
                                                @error('birthdate')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>Gender*</label>
                                                <select class="form-control @error('gender') is-invalid @enderror" name="gender" required>
                                                    <option value="" disabled selected>Select Gender</option>
                                                    <option value="Male" {{ old('gender', $member->gender) == 'Male' ? 'selected' : ''}}>Male</option>
                                                    <option value="Female" {{ old('gender', $member->gender) == 'Female' ? 'selected' : ''}}>Female</option>
                                                </select>
                                                @error('gender')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>Marital Status*</label>
                                                <select class="form-control @error('marital_status') is-invalid @enderror" name="marital_status" required>
                                                    <option value="" disabled selected>Select Marital Status</option>
                                                    <option value="Single" {{ old('marital_status', $member->marital_status) == 'Single' ? 'selected' : ''}}>Single</option>
                                                    <option value="Married" {{ old('marital_status', $member->marital_status) == 'Married' ? 'selected' : ''}}>Married</option>
                                                    <option value="Divorced" {{ old('marital_status', $member->marital_status) == 'Divorced' ? 'selected' : ''}}>Divorced</option>
                                                    <option value="Widowed" {{ old('marital_status', $member->marital_status) == 'Widowed' ? 'selected' : ''}}>Widowed</option>
                                                </select>
                                                @error('marital_status')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>Citizenship:*</label>
                                                <input type="text" class="form-control @error('citizenship') is-invalid @enderror" value="{{ old('citizenship', $member->citizenship) }}" placeholder="Enter citizenship" name="citizenship" required>
                                                @error('citizenship')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>Mobile No.*</label>
                                                <input type="text" class="form-control @error('mobile_number') is-invalid @enderror" value="{{ old('mobile_number', $member->mobile_number) }}" placeholder="Enter mobile number" name="mobile_number" required>
                                                @error('mobile_number')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>Landline No.</label>
                                                <input type="text" class="form-control @error('landline_number') is-invalid @enderror" value="{{ old('landline_number', $member->landline_number) }}" placeholder="Enter landline number" name="landline_number">
                                                @error('landline_number')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                             <div class="col-lg-4 col-12 form-group">
                                                <label>Email*</label>
                                                <input type="email" class="form-control @error('email') is-invalid @enderror" value="{{ old('email', $member->email) }}" placeholder="Enter email" name="email" required>
                                                @error('email')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>TIN No.</label>
                                                <input type="text" class="form-control @error('tin_number') is-invalid @enderror" value="{{ old('tin_number', $member->tin_number) }}" placeholder="Enter tin number" name="tin_number">
                                                @error('tin_number')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>Occupation*</label>
                                                <input type="text" class="form-control @error('occupation') is-invalid @enderror" value="{{ old('occupation', $member->occupation) }}" placeholder="Enter occupation" name="occupation" required>
                                                @error('occupation')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                             <div class="col-lg-8 col-12 form-group">
                                                <label>Address*</label>
                                                <input type="text" class="form-control @error('address') is-invalid @enderror" value="{{ old('address', $member->address) }}" placeholder="Enter address" name="address" id="address" required>
                                                @error('address')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-12 form-group">
                                                <h4 class="card-title mt-2">Account Information</h4>
                                            </div>
                                            @php
                                                $status = $member->registration_status;
                                            @endphp
                                            <div class="{{ $status == 'verified' ? 'col-lg-6' : 'col-lg-4' }} col-12 form-group">
                                                <label>Account No. (NFC)*</label>
                                                <input type="text" class="form-control" name="account_number" value="{{ old('account_number', $member->account_number) }}" placeholder="Enter account number">
                                                @error('account_number')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="form-group {{ $status == 'verified' ? 'col-lg-6' : 'col-lg-4' }} col-12 ">
                                                <label>Card No.</label>
                                                <input type="text" class="form-control" name="card_number" value="{{ old('card_number', $member->card_number)}}" placeholder="Enter card number" disabled>
                                            </div>
                                            <div class="form-group {{ $status == 'verified' ? 'col-lg-6' : 'col-lg-4' }} col-12">
                                                <label>Patient ID</label>
                                                <input type="text" class="form-control text-danger" value="" disabled>
                                            </div>
                                            @if($status == 'verified')
                                                <div class="col-lg-6 col-12 form-group">
                                                    <label>Area code*</label>
                                                    <select class="form-control @error('area_code_id') is-invalid @enderror" name="area_code_id">
                                                        <option value="" disabled selected> Select Area Code</option>
                                                        @foreach($area_codes as $area)
                                                            <option value="{{ $area->id }}" {{ old('area_code_id', $member->area_code_id) == $area->id ? 'selected' : ''}} >
                                                                {{ $area->area_name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                    @error('area_code_id')
                                                        <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            @endif
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Member Type*</label>
                                                <select class="form-control @error('member_type_id') is-invalid @enderror" name="member_type_id"required>
                                                    <option value="" disabled selected> Select Member Type</option>
                                                    @foreach($member_types as $type)
                                                        <option value="{{ $type->id }}" {{ old('member_type_id', $member->member_type_id) == $type->id ? 'selected' : ''}} >
                                                            {{ $type->name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                                @error('type')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Home Ownership*</label>
                                                <input type="text" class="form-control @error('homeownership') is-invalid @enderror" name="homeownership" value="{{ old('homeownership', $member->homeownership) }}" placeholder="Enter home ownership" required>
                                                @error('homeownership')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Date of Registration*</label>
                                                <input type="text" class="form-control @error('verification_date') is-invalid @enderror" name="verification_date" id="verification_date" value="{{ old('verification_date', $member->verification_date ? $member->verification_date->format('m/d/Y') : '') }}" required>
                                                @error('verification_date')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Expiration Date*</label>
                                                <input type="text" class="form-control @error('expiration_date') is-invalid @enderror" name="expiration_date" id="expiration_date" value="{{ old('expiration_date', $member->expiration_date ? $member->expiration_date->format('m/d/Y') : '') }}" required>
                                                @error('expiration_date')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Username</label>
                                                <input type="text" class="form-control @error('username') is-invalid @enderror" value="{{ old('username', $member->username) }}" placeholder="Enter username" name="username" disabled>
                                                @error('username')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-12 col-12 form-group text-right">
                                                <a href="{{ route('members') }}">
                                                    <button type="button" class="btn btn-danger">
                                                        <i class="mdi mdi-close-circle"></i> Cancel
                                                    </button>
                                                </a>
                                                <button type="submit" class="btn btn-info">
                                                    <i class="fa fa-save"></i> Update
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @include('dashboard.partials.footer')
        
    </div>
    
@endsection

@push('scripts')
   <script type="text/javascript">

        // All select option
        $('select').select2({
            width : '100%'
        })

        // Birthdate
        $('#birthdate').datepicker({
            autoclose: true,
            todayHighlight: true
        });
        
        // Verification Date now
        $('#verification_date').datepicker({
            autoclose: true,
            todayHighlight: true
        });

        // Expriration Date
        $('#expiration_date').datepicker({
            autoclose: true,
            todayHighlight: true
        });

        function initialize() {
            var complete_address = document.getElementById('address');
            var autocomplete = new google.maps.places.Autocomplete(complete_address);
        }
        google.maps.event.addDomListener(window, 'load', initialize); 
   </script>
@endpush