@extends('layouts.admin')
@section('title','Dashboard')
@section('styles')
	<style type="text/css">
        tbody tr td:nth-child(2), 
        tbody tr td:nth-child(3), 
        tbody tr td:nth-child(4), 
        tbody tr td:nth-child(5){
            padding-top: 24px !important;
        }
        tbody tr td:nth-child(6){
            padding-top: 20px !important;
        }
		.round{
		    width: 60px;
		    height: 60px;
		    line-height: 60px;
		}
        h4.font-light{
            font-weight: 500 !important;
        }
        .card-body.shadow{
            height: 122px;
        }
	</style>
@endsection

@section('content')

    <div class="page-wrapper">
        <div class="container-fluid">
            <div class="row">
                @role('super_admin|admin|human_resource|accounting|admin_cashier')
                    <div class="col-lg-4 col-12">
                        <div class="card">
                            <div class="card-body shadow">
                                <div class="row">
                                    <div class="col p-r-0 mt-2">
                                        <h6 class="text-muted text-uppercase">Members</h6>
                                        <h4 class="font-light">{{ $member_count }}</h4>
                                        <h6 class="text-muted">Total</h6>
                                    </div>
                                    <div class="col-5 text-right align-self-center">
                                        <div class="round align-self-center round-success">
                                            <i class="mdi mdi-account-multiple mdi-24px"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-12">
                        <div class="card">
                            <div class="card-body shadow">
                                <div class="row">
                                    <div class="col p-r-0 mt-2">
                                        <h6 class="text-muted text-uppercase">Merchants</h6>
                                        <h4 class="font-light">{{ $merchant_count }}</h4>
                                        <h6 class="text-muted">Total</h6>
                                    </div>
                                    <div class="col-5 text-right align-self-center">
                                        <div class="round align-self-center round-success">
                                            <i class="mdi mdi-cart mdi-24px"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-12">
                        <div class="card">
                            <div class="card-body shadow">
                                <div class="row">
                                    <div class="col p-r-0 mt-2">
                                        <h6 class="text-muted text-uppercase">Pts. as Payment</h6>
                                        <h4 class="font-light">{{ number_format($total_points_payment,2) }}</h4>
                                        <h6 class="text-muted">Total</h6>
                                    </div>
                                    <div class="col-5 text-right align-self-center">
                                        <div class="round align-self-center round-success">
                                            <i class="mdi mdi-credit-card-multiple mdi-24px"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-12">
                        <div class="card">
                            <div class="card-body shadow">
                                <div class="row">
                                    <div class="col p-r-0 mt-2">
                                        <h6 class="text-muted text-uppercase">System & Maintenance</h6>
                                        <h4 class="font-light">{{ $total_system }}</h4>
                                        <h6 class="text-muted">Total</h6>
                                    </div>
                                    <div class="col-5 text-right align-self-center">
                                        <div class="round align-self-center round-success">
                                            <i class="mdi mdi-wrench mdi-24px"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-12">
                        <div class="card">
                            <div class="card-body shadow">
                                <div class="row">
                                    <div class="col p-r-0 mt-2">
                                        <h6 class="text-muted text-uppercase">Advocacy</h6>
                                        <h4 class="font-light">{{ $total_advocacy }}</h4>
                                        <h6 class="text-muted">Total</h6>
                                    </div>
                                    <div class="col-5 text-right align-self-center">
                                        <div class="round align-self-center round-success">
                                            <i class="mdi mdi-briefcase mdi-24px"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-12">
                        <div class="card">
                            <div class="card-body shadow">
                                <div class="row">
                                    <div class="col p-r-0 mt-2">
                                        <h6 class="text-muted text-uppercase">Members Earned Pts.</h6>
                                        <h4 class="font-light">{{ $total_points }}</h4>
                                        <h6 class="text-muted">Total</h6>
                                    </div>
                                    <div class="col-5 text-right align-self-center">
                                        <div class="round align-self-center round-success">
                                            <i class="mdi mdi-wallet-giftcard mdi-24px"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>                               
                @endrole

                @role('merchant_admin')
                    @if($maintaining_balance > $remaining_balance)
                        <div class="col-12">
                            <div class="alert alert-warning alert-dismissible fade show" role="alert" style="background-color: #f9c23f; color: #fff;">
                                Your Wallet Remaining Balance is now below ₱ {{ number_format($maintaining_balance,2) }}. Please top-up immediately.
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                        </div>
                    @endif
                    @if (auth()->user()->account->merchant->is_mobile == 1)
                        @if(auth()->user()->account->merchant->merchantAgreement->application_type == 'kol-a')
                            <div class="col-lg-4 col-12">
                                <div class="card">
                                    <div class="card-body shadow">
                                        <div class="row">
                                            <div class="col p-r-0 mt-2">
                                                <h6 class="text-muted text-uppercase">Cashiers</h6>
                                                <h4 class="font-light">{{ $merchant_cashier_count }}</h4>
                                                <h6 class="text-muted">Total</h6>
                                            </div>
                                            <div class="col-4 text-right align-self-center">
                                                <div class="round align-self-center round-success">
                                                    <i class="mdi mdi-account-multiple mdi-24px"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4 col-12">
                                <div class="card">
                                    <div class="card-body shadow">
                                        <div class="row">
                                            <div class="col p-r-0 mt-2">
                                                <h6 class="text-muted text-uppercase">Doctors</h6>
                                                <h4 class="font-light">{{ $merchant_doctor_count }}</h4>
                                                <h6 class="text-muted">Total</h6>
                                            </div>
                                            <div class="col-4 text-right align-self-center">
                                                <div class="round align-self-center round-success">
                                                    <i class="mdi mdi-account-multiple-plus mdi-24px"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4 col-12">
                                <div class="card">
                                    <div class="card-body shadow">
                                        <div class="row">
                                            <div class="col p-r-0 mt-2">
                                                <h6 class="text-muted text-uppercase">Patients</h6>
                                                <h4 class="font-light">{{ $merchant_patient_count }}</h4>
                                                <h6 class="text-muted">Total</h6>
                                            </div>
                                            <div class="col-4 text-right align-self-center">
                                                <div class="round align-self-center round-success">
                                                    <i class="mdi mdi-nature-people mdi-24px"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @else
                            <div class="col-lg-4 col-12">
                                <div class="card">
                                    <div class="card-body shadow">
                                        <div class="row">
                                            <div class="col p-r-0 mt-2">
                                                <h6 class="text-muted text-uppercase">Pending Orders</h6>
                                                <h4 class="font-light">{{ $pending_orders_count }}</h4>
                                                <h6 class="text-muted">Total</h6>
                                            </div>
                                            <div class="col-4 text-right align-self-center">
                                                <div class="round align-self-center round-success">
                                                    <i class="mdi mdi-cart mdi-24px"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4 col-12">
                                <div class="card">
                                    <div class="card-body shadow">
                                        <div class="row">
                                            <div class="col p-r-0 mt-2">
                                                <h6 class="text-muted text-uppercase">Customers</h6>
                                                <h4 class="font-light">{{ $customer_count }}</h4>
                                                <h6 class="text-muted">Total</h6>
                                            </div>
                                            <div class="col-4 text-right align-self-center">
                                                <div class="round align-self-center round-success">
                                                    <i class="mdi mdi-account-multiple mdi-24px"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4 col-12">
                                <div class="card">
                                    <div class="card-body shadow">
                                        <div class="row">
                                            <div class="col p-r-0 mt-2">
                                                <h6 class="text-muted text-uppercase">Products</h6>
                                                <h4 class="font-light">{{ $product_count }}</h4>
                                                <h6 class="text-muted">Total</h6>
                                            </div>
                                            <div class="col-4 text-right align-self-center">
                                                <div class="round align-self-center round-success">
                                                    <i class="mdi mdi-dropbox mdi-24px"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif
                        
                        <div class="col-lg-4 col-12">
                            <div class="card">
                                <div class="card-body shadow">
                                    <div class="row">
                                        <div class="col p-r-0 mt-2">
                                            <h6 class="text-muted text-uppercase">Reviews</h6>
                                            <h4 class="font-light">{{ $merchant_review_count }}</h4>
                                            <h6 class="text-muted">Total</h6>
                                        </div>
                                        <div class="col-4 text-right align-self-center">
                                            <div class="round align-self-center round-success">
                                                <i class="mdi mdi-comment-multiple-outline mdi-24px"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                    <div class="col-lg-4 col-12">
                        <div class="card">
                            <div class="card-body shadow">
                                <div class="row">
                                    <div class="col p-r-0 mt-2">
                                        <h6 class="text-muted text-uppercase">Wallet Maintaining Balance</h6>
                                        <h4 class="font-light">₱ {{ number_format($maintaining_balance,2) }}</h4>
                                        <h6 class="text-muted">Total</h6>
                                    </div>
                                    <div class="col-4 text-right align-self-center">
                                        <div class="round align-self-center round-success">
                                            <i class="mdi mdi-credit-card mdi-24px"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-12">
                        <div class="card">
                            <div class="card-body shadow">
                                <div class="row">
                                    <div class="col p-r-0 mt-2">
                                        <h6 class="text-muted text-uppercase">Wallet Remaining Balance</h6>
                                        <h4 class="font-light @if($maintaining_balance > $remaining_balance) text-danger @endif">
                                            ₱ {{ number_format($remaining_balance,2) }}
                                        </h4>
                                        <h6 class="text-muted">Total</h6>
                                    </div>
                                    <div class="col-4 text-right align-self-center">
                                        <div class="round align-self-center round-success">
                                            <i class="mdi mdi-credit-card mdi-24px"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>   
                @endrole

                @role('doctor')
                    <div class="col-lg-4 col-12">
                        <div class="card">
                            <div class="card-body shadow">
                                <div class="row">
                                    <div class="col p-r-0 mt-2">
                                        <h6 class="text-muted text-uppercase">Pending Appointments</h6>
                                        <h4 class="font-light">{{ $doctor_appointment_count }}</h4>
                                        <h6 class="text-muted">Total</h6>
                                    </div>
                                    <div class="col-5 text-right align-self-center">
                                        <div class="round align-self-center round-success">
                                            <i class="mdi mdi-calendar-text mdi-24px"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-12">
                        <div class="card">
                            <div class="card-body shadow">
                                <div class="row">
                                    <div class="col p-r-0 mt-2">
                                        <h6 class="text-muted text-uppercase">Patients</h6>
                                        <h4 class="font-light">{{ $doctor_patient_count }}</h4>
                                        <h6 class="text-muted">Total</h6>
                                    </div>
                                    <div class="col-5 text-right align-self-center">
                                        <div class="round align-self-center round-success">
                                            <i class="mdi mdi-account-multiple mdi-24px"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-12">
                        <div class="card">
                            <div class="card-body shadow">
                                <div class="row">
                                    <div class="col p-r-0 mt-2">
                                        <h6 class="text-muted text-uppercase">Reviews</h6>
                                        <h4 class="font-light">{{ $doctor_reviews_count }}</h4>
                                        <h6 class="text-muted">Total</h6>
                                    </div>
                                    <div class="col-4 text-right align-self-center">
                                        <div class="round align-self-center round-success">
                                            <i class="mdi mdi-comment-multiple-outline mdi-24px"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body shadow" style="height: 100%">
                                <div class="row">
                                    <div class="col-12">
                                        <h5 style="font-weight: 500">
                                            <i class="mdi mdi-calendar-text"></i> 
                                            Pending Appointments (<span id="pending_count"></span>)
                                        </h5>
                                    </div>
                                    <div class="col-12">
                                        <div class="table-responsive">
                                            <table id="pendingAppointmentTable" class="table">
                                                <thead>
                                                    <tr>
                                                        <th>Patient Name</th>
                                                        <th>Reference #</th>
                                                        <th>Schedule</th>
                                                        <th>Payment</th>
                                                        <th>Status</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body shadow" style="height: 100%">
                                <div class="row">
                                    <div class="col-12">
                                        <h5 style="font-weight: 500">
                                            <i class="mdi mdi-calendar-text"></i> 
                                            Recent Appointments (<span id="completed_count"></span>)
                                        </h5>
                                    </div>
                                    <div class="col-12">
                                        <div class="table-responsive">
                                            <table id="recentAppointmentTable" class="table">
                                                <thead>
                                                    <tr>
                                                        <th>Patient Name</th>
                                                        <th>Reference #</th>
                                                        <th>Schedule</th>
                                                        <th>Payment</th>
                                                        <th>Status</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endrole
            </div>
        </div>

        @include('dashboard.partials.footer')

    </div>
        
@endsection

@push('scripts')
    <script type="text/javascript">
        $(document).ready( function(){
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#pendingAppointmentTable').DataTable({
                ajax: "{{ route('doctors.appointments.list','status=pending') }}",
                columns: [
                    { data : 'name' },
                    { data : 'reference_id' },
                    { data : 'date_time' },
                    { data : 'payment_method' },
                    { data : 'status' },
                ],
                paging      : false,
                pageLength  : 5,
                lengthChange: false,
                searching   : false,
                ordering    : false,
                info        : false,
                autoWidth   : false,
                fnDrawCallback: function () {
                    self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                    $('#pending_count').text(self.QtdOcorrenciasAgendadosHoje);
                }
            });

            $('#recentAppointmentTable').DataTable({
                ajax: "{{ route('doctors.appointments.list','status=completed') }}",
                columns: [
                    { data : 'name' },
                    { data : 'reference_id' },
                    { data : 'date_time' },
                    { data : 'payment_method' },
                    { data : 'status' },
                ],
                paging      : false,
                pageLength  : 5,
                lengthChange: false,
                searching   : false,
                ordering    : false,
                info        : false,
                autoWidth   : false,
                fnDrawCallback: function () {
                    self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                    $('#completed_count').text(self.QtdOcorrenciasAgendadosHoje);
                }
            });
        });
    </script>
@endpush