@extends('layouts.admin')
@section('title','Affiliates')
@section('styles')
    <style type="text/css">
        tbody tr td:nth-child(1), 
        tbody tr td:nth-child(3), 
        tbody tr td:nth-child(4), 
        tbody tr td:nth-child(5), 
        tbody tr td:nth-child(6){
            padding-top: 24px !important;
        }
        tbody tr td:nth-child(7){
            padding-top: 20px !important;
        }
        .form-group{
            margin-bottom: .6rem;
        }
    </style>
@endsection

@section('content')

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Affiliates</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('dashboard') }}">Home</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Affiliates</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <h4 class="page-title mt-2">
                        <i class="mdi mdi-account-star-variant"></i>
                        List of Affiliates
                    </h4>                
                </div>
                <div class="col-12 mt-1">
                    <div class="card">
                        <div class="card-body">
                            <ul class="nav nav-tabs" role="tablist">
                                <li class="nav-item"> 
                                    <a class="nav-link active" data-toggle="tab" href="#home" role="tab">
                                        <span class="hidden-sm-up">
                                            <i class="mdi mdi-account-multiple"></i>
                                        </span> 
                                        <span class="hidden-xs-down"> 
                                            Group (<span id="group_count"></span>)
                                        </span>
                                    </a>
                                </li>
                                <li class="nav-item"> 
                                    <a class="nav-link" data-toggle="tab" href="#profile" role="tab">
                                        <span class="hidden-sm-up">
                                            <i class="mdi mdi-account-multiple"></i>
                                        </span> 
                                        <span class="hidden-xs-down"> 
                                            Individial (<span id="individual_count"></span>)
                                        </span>
                                    </a> 
                                </li>
                            </ul>
                            <!-- Tab panes -->
                            <div class="tab-content tabcontent-border">
                                <div class="tab-pane active" id="home" role="tabpanel">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="table-responsive mt-4">
                                                <table id="groupTable" class="table table-hover">
                                                    <thead>
                                                        <tr>
                                                            <th>Affiliates ID</th>
                                                            <th>Name</th>
                                                            <th>Merchant</th>
                                                            <th>Merchant Type</th>
                                                            <th>Affiliate Type</th>
                                                            <th>Status</th>
                                                            <th width="10%">Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                            
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane" id="profile" role="tabpanel">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="table-responsive mt-4">
                                                <table id="individualTable" class="table table-hover">
                                                    <thead>
                                                        <tr>
                                                            <th>Affiliates ID</th>
                                                            <th>Name</th>
                                                            <th>Merchant</th>
                                                            <th>Merchant Type</th>
                                                            <th>Affiliate Type</th>
                                                            <th>Status</th>
                                                            <th width="10%">Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                    
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- view doctors modal -->
        @include('dashboard.merchants.doctors.partials.view-doctors-modal')

        @include('dashboard.partials.footer')
        
    </div>
    
@endsection

@push('scripts')
   <script type="text/javascript">
        
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        var groupTable = $('#groupTable').DataTable({
            ajax: "{{ route('affiliates.group.list') }}",
            columns: [
                { data : 'professional_id' },
                { data : 'name' },
                { data : 'merchant' },
                { data : 'merchant_type' },
                { data : 'doctor_type' },
                { data : 'status' },
                { data : 'action', orderable: false, searchable: false}
            ],
            paging      : true,
            lengthChange: true,
            searching   : true,
            ordering    : false,
            info        : true,
            autoWidth   : false,
            dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                        "<'row'<'col-12'tr>>" +
                        "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
            fnDrawCallback: function () {
                self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                $('#group_count').text(self.QtdOcorrenciasAgendadosHoje);
            }
        });

        var individualTable = $('#individualTable').DataTable({
            ajax: "{{ route('affiliates.individual.list') }}",
            columns: [
                { data : 'professional_id' },
                { data : 'name' },
                { data : 'merchant' },
                { data : 'merchant_type' },
                { data : 'doctor_type' },
                { data : 'status' },
                { data : 'action', orderable: false, searchable: false}
            ],
            paging      : true,
            lengthChange: true,
            searching   : true,
            ordering    : false,
            info        : true,
            autoWidth   : false,
            dom         : "<'row'<'col-sm-12 col-md-6'><'col-12'f>>" +
                        "<'row'<'col-12'tr>>" +
                        "<'row'<'col-lg-4 col-12'l><'col-lg-4 col-12'p><'col-lg-4 col-12 text-right pt-0'i>>",
            fnDrawCallback: function () {
                self.QtdOcorrenciasAgendadosHoje = this.api().page.info().recordsTotal;
                $('#individual_count').text(self.QtdOcorrenciasAgendadosHoje);
            }
        });

        // view modal
        $('body').on('click', '#view', function(e){
            e.preventDefault();

            var url = $(this).attr('href');
            
            $.ajax({
                type: "GET",
                url: url,
                success: function (response) {
                    $('#image').attr('src',response.path);
                    $('#name').text(response.name);
                    $('#email').text(response.email);
                    $('#usertype').text(response.usertype);
                    $('#username').text(response.username);
                    $('#professional_id').text(response.professional_id);
                    $('#contact_number').text(response.contact_number);
                    $('#consulation_fee').text('₱'+response.minimum_consultation_fee+' - '+'₱'+response.maximum_consultation_fee);
                    $('#specialities').text(response.specialities);

                    // schedules
                    const no_schedules = '<span class="text-danger">No Schedule</span>';
                    $('#monday').html(response.schedules.monday ? response.schedules.monday : no_schedules);
                    $('#tuesday').html(response.schedules.tuesday ? response.schedules.tuesday : no_schedules);
                    $('#wednesday').html(response.schedules.wednesday ? response.schedules.wednesday : no_schedules);
                    $('#thursday').html(response.schedules.thursday ? response.schedules.thursday : no_schedules);
                    $('#friday').html(response.schedules.friday ? response.schedules.friday : no_schedules);
                    $('#saturday').html(response.schedules.saturday ? response.schedules.saturday : no_schedules);
                    $('#sunday').html(response.schedules.sunday ? response.schedules.sunday : no_schedules);

                    $('#user_status').empty();
                    if (response.status == 1) {
                        $('#user_status').append('<i class="mdi mdi-checkbox-blank-circle text-success mr-2"></i> Active');
                    } else {
                        $('#user_status').append('<i class="mdi mdi-checkbox-blank-circle text-danger mr-2"></i> Not Active');
                    }
                    $('#created_at').text(response.date_registered);
                    $('#viewDoctorModal').modal('show');
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        });
        
   </script>
@endpush