@extends('layouts.admin')
@section('title','Add User')

@section('content')

    <div class="page-wrapper">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-5 align-self-center">
                    <h4 class="page-title">Add User</h4>
                </div>
                <div class="col-7 align-self-center">
                    <div class="d-flex align-items-center justify-content-end">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('dashboard') }}">Home</a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="{{ route('administration.users') }}">Registered Users</a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">Add User</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <form method="POST" action="{{ route('administration.users.add') }}" enctype="multipart/form-data">
                                @csrf
                                <div class="row">
                                   <div class="col-lg-3 col-12">
                                        <label>PHOTO</label>
                                        <input type="file" id="input-file-now-custom-2" name="image" value="{{ old('image')}}" class="dropify" data-height="300" data-allowed-file-extensions="jpeg png jpg"/>
                                        @error('image')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                        <p class="mt-2 text-center">Image must be square and at least 500x500 pixels</p>
                                    </div>
                                    <div class="col-lg-9 col-12">
                                        <h4 class="card-title mb-4">Personal Information</h4>
                                        <div class="row">
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>First Name*</label>
                                                <input type="text" class="form-control @error('firstname') is-invalid @enderror" name="firstname" value="{{ old('firstname') }}" placeholder="Enter first name" required>
                                                @error('firstname')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                 <label>Middle Name</label>
                                                <input type="text" class="form-control @error('middlename') is-invalid @enderror" name="middlename" value="{{ old('middlename') }}" placeholder="Enter middle name">
                                                @error('middlename')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-4 col-12 form-group">
                                                <label>Last Name*</label>
                                                 <input type="text" class="form-control @error('lastname') is-invalid @enderror" name="lastname" value="{{ old('lastname') }}" placeholder="Enter last name" required>
                                                @error('lastname')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Employee No.*</label>
                                                <input type="text" class="form-control @error('employee_number') is-invalid @enderror" value="{{ old('employee_number') }}" placeholder="Enter employee number" name="employee_number" required>
                                                @error('employee_number')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Department*</label>
                                                <input type="text" class="form-control @error('department') is-invalid @enderror" value="{{ old('department') }}" placeholder="Enter department" name="department" required>
                                                @error('department')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Email*</label>
                                                <input type="email" class="form-control @error('email') is-invalid @enderror" value="{{ old('email') }}" placeholder="Enter email" name="email" required>
                                                @error('email')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Mobile No.</label>
                                                <input type="text" class="form-control @error('contact_number') is-invalid @enderror" value="{{ old('contact_number') }}" placeholder="Enter mobile number" name="contact_number" maxlength="13">
                                                @error('contact_number')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-12 form-group">
                                                <h4 class="card-title mt-2">Account Information</h4>
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Username*</label>
                                                <input type="text" class="form-control @error('username') is-invalid @enderror" value="{{ old('username') }}" placeholder="Enter username" name="username" required>
                                                @error('username')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Usertype*</label>
                                                <select class="form-control @error('usertype') is-invalid @enderror" name="usertype" id="usertype" required>
                                                    <option value="" disabled selected>Select Usertype</option>
                                                    @role('super_admin')
                                                    <option title="System Full Access" value="super_admin" {{ old('usertype') == 'super_admin' ? 'selected' : ''}}>Super Admin</option>
                                                    <option title="System Full Access except adding of user." value="admin" {{ old('usertype') == 'admin' ? 'selected' : ''}}>Administrator</option>
                                                    @endrole
                                                    <option title="Can add/update member information." value="admin_cashier" {{ old('usertype') == 'admin_cashier' ? 'selected' : ''}}>Admin Cashier</option>
                                                    <option title="Merchant Portal Access" value="merchant_admin" {{ old('usertype') == 'merchant_admin' ? 'selected' : ''}}>Merchant Admin</option>
                                                    <option title="Limited Merchant Portal Access" value="merchant_cashier" {{ old('usertype') == 'merchant_cashier' ? 'selected' : ''}}>Merchant Cashier</option>
                                                    <option title="View only the Registered Users" value="human_resource" {{ old('usertype') == 'human_resource' ? 'selected' : ''}}>Human Resource</option>
                                                    <option title="View only list of Merchants and Members" value="accounting" {{ old('usertype') == 'accounting' ? 'selected' : ''}}>Accounting</option>
                                                </select>
                                                @error('usertype')
                                                    <div class="invalid-feedback">{{ $message }}</div>
                                                @enderror
                                            </div>
                                            <div class="col-lg-6 col-12 form-group">
                                                <label>Default Password</label>
                                                <input type="text" class="form-control" value="pplus2020" disabled>
                                            </div>
                                            <div class="col-lg-6 col-12 form-group {{ old('usertype') == 'merchant_admin' || old('usertype') == 'merchant_cashier' ? '' : 'd-none'}} " id="merchants">
                                                <label>Company/Merchant*</label>
                                                <select class="form-control" name="merchant_id" id="merchant_id"></select>
                                            </div>
                                            <div class="col-lg-12 col-12 form-group text-right">
                                                <a href="{{ route('administration.users') }}">
                                                    <button type="button" class="btn btn-danger">
                                                        <i class="mdi mdi-close-circle"></i> Cancel
                                                    </button>
                                                </a>
                                                <button type="submit" class="btn btn-info">
                                                    <i class="fa fa-save"></i> Save
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @include('dashboard.partials.footer')
        
    </div>
    
@endsection

@push('scripts')
   <script type="text/javascript">

        // All select option
        $('select').select2({
            width : '100%'
        });

        getAllMerchants();

        $('#usertype').on('change', function(){
            var usertype = ($(this).val());

            // select merchant_admin or merchant_cashier show merchants
            if (usertype == 'merchant_admin' || usertype == 'merchant_cashier') {

                $('#merchants').removeClass('d-none');
                $('#merchant_id').attr('required',true);
                $('#merchant_id').val('');
                $('#merchant_id').select2('');

                return true;
            }

            $('#merchants').addClass('d-none');
            $('#merchant_id').removeAttr('required',true);
        });

        function getAllMerchants() {
            $.ajax({
                type: "GET",
                url: "{{ route('administration.merchants')}}",
                success: function (response) {
                    $('#merchant_id').append('<option value="" disabled>Select Company/Merchant</option>');
                    for (i = 0; i < response.length; i++) {
                        $('#merchant_id').append('<option value='+response[i].id+' "{{ old("merchant_id") == 'response[i].id' ? "selected" : ''}}">'+response[i].name.toUpperCase()+'</option>');
                    }
                },
                error: function (response) {
                    console.log('Error:', response);
                }
            });
        }

   </script>
@endpush