@extends('layouts.auth')
@section('title','Register')

@section('content')

	<div class="auth-wrapper d-flex no-block justify-content-center align-items-center">
        <div class="auth-box m-0" style="max-width: 500px; width: 100%; padding: 16px 20px;">
            <div id="loginform">
                <div class="logo">
                	<span class="db">
	                    <img src="{{ asset('admin_dashboard/img/logo.png')}}" alt="logo" width="40%" />
	                </span>
	                <h3 class="font-medium mb-2 mt-2 text-center">
	                    Create Member Account
	                </h3>
	            </div>
               	<form method="POST" action="{{ route('register') }}">
                	@csrf
                	<div class="row">
	                	<div class="col-12 form-group">
	                		<label>Firstname*</label>
	                		@if(isset($code))
	                		<input type="hidden" name="code" value="{{ base64_encode($code) }}">
	                		@endif
	                		<input type="text" class="form-control @error('firstname') is-invalid @enderror" name="firstname" value="{{ old('firstname') }}" placeholder="Enter firstname" required>
	                		@error('firstname')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
	                	</div>
	                	<div class="col-12 form-group">
	                		<label>Last Name*</label>
	                		<input type="text" class="form-control @error('lastname') is-invalid @enderror" name="lastname" value="{{ old('lastname') }}" placeholder="Enter lastname" required>
	                		@error('lastname')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
	                	</div>
	                	<div class="col-12 form-group">
	                		<label>Contact*</label>
	                		<div class="input-group">
	                		<div class="input-group-prepend">
							      <span class="input-group-text"><img src="https://www.pngitem.com/pimgs/m/34-348324_download-flag-icon-of-philippines-at-png-format.png" width="30"> +63</span>
							</div>
	                		<input type="text" class="form-control @error('mobile_number') is-invalid @enderror" name="mobile_number" value="{{ old('mobile_number') }}" maxlength="10" placeholder="Enter contact" required>
	                		@error('mobile_number')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
	                           
							</div>
	                	</div>
	                	<div class="col-12 form-group">
	                		<label>Birth Date*</label>
	                		<input type="date" class="form-control @error('birthdate') is-invalid @enderror" name="birthdate" value="{{ old('birthdate') }}" required>
	                		@error('birthdate')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
	                	</div>
	                	<div class="col-12 form-group">
	                		<label>City/Municipality*</label>
	                		<input type="text" class="form-control @error('city') is-invalid @enderror" name="city" value="{{ old('city') }}" placeholder="Enter City/Municipality" required>
	                		@error('city')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
	                	</div>
	                	<div class="col-12 form-group">
	                		<label>E-Mail*</label>
	                		<input type="text" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" placeholder="Enter email" required>
	                		@error('email')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
	                	</div>
	                	<div class="col-12 form-group">
	                		<label>Username*</label>
	                		<input type="text" class="form-control @error('username') is-invalid @enderror" name="username" value="{{ old('username') }}" placeholder="Enter username" required>
	                		@error('username')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
	                	</div>
	                	<div class="col-12 form-group">
	                		<label>Password*</label>
                            <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" placeholder="Enter password" required autocomplete="new-password">
	                		@error('password')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
	                	</div>
	                	<div class="col-12 form-group">
	                		<label>Confirm Password*</label>
	                		<input id="password-confirm" type="password" class="form-control" name="password_confirmation" placeholder="Enter confirm password" required autocomplete="new-password">
	                	</div>
	                	<div class="col-md-12 form-group">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" id="customCheck1" required>
                                <label class="custom-control-label" for="customCheck1">
                                	I signify that I have read the 
                                	<a href="#">Terms and Condition</a> of PrimaryPlus membership.
                                </label>
                            </div>
                        </div>
	                	<div class="col-12 form-group">
	                		<button type="submit" class="btn btn-info btn-block btn-rounded">Register</button>
	                	</div>
	                </div>
                </form>
            </div>
        </div>
    </div>

@endsection